/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=ActivityBuilder.class)
public final class Activity {
    @JsonProperty(value="__typename")
    private final String typeName;
    @JsonProperty(value="__cursor")
    private final String cursor;
    private final String id;
    private final Object actor;
    private final Object recipient;
    private final ZonedDateTime insertedAt;
    private final ZonedDateTime updatedAt;
    @JsonAnySetter
    private final Map<String, Object> data;

    public <T> T data(String key, Class<T> clazz) {
        if (this.data != null && this.data.containsKey(key)) {
            Object o = this.data.get(key);
            return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
        }
        return null;
    }

    Activity(String typeName, String cursor, String id, Object actor, Object recipient, ZonedDateTime insertedAt, ZonedDateTime updatedAt, Map<String, Object> data) {
        this.typeName = typeName;
        this.cursor = cursor;
        this.id = id;
        this.actor = actor;
        this.recipient = recipient;
        this.insertedAt = insertedAt;
        this.updatedAt = updatedAt;
        this.data = data;
    }

    public static ActivityBuilder builder() {
        return new ActivityBuilder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String getId() {
        return this.id;
    }

    public Object getActor() {
        return this.actor;
    }

    public Object getRecipient() {
        return this.recipient;
    }

    public ZonedDateTime getInsertedAt() {
        return this.insertedAt;
    }

    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Activity)) {
            return false;
        }
        Activity other = (Activity)o;
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Object this$actor = this.getActor();
        Object other$actor = other.getActor();
        if (this$actor == null ? other$actor != null : !this$actor.equals(other$actor)) {
            return false;
        }
        Object this$recipient = this.getRecipient();
        Object other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        ZonedDateTime this$insertedAt = this.getInsertedAt();
        ZonedDateTime other$insertedAt = other.getInsertedAt();
        if (this$insertedAt == null ? other$insertedAt != null : !((Object)this$insertedAt).equals(other$insertedAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Map<String, Object> this$data = this.getData();
        Map<String, Object> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Object $actor = this.getActor();
        result = result * 59 + ($actor == null ? 43 : $actor.hashCode());
        Object $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        ZonedDateTime $insertedAt = this.getInsertedAt();
        result = result * 59 + ($insertedAt == null ? 43 : ((Object)$insertedAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Map<String, Object> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "Activity(typeName=" + this.getTypeName() + ", cursor=" + this.getCursor() + ", id=" + this.getId() + ", actor=" + this.getActor() + ", recipient=" + this.getRecipient() + ", insertedAt=" + this.getInsertedAt() + ", updatedAt=" + this.getUpdatedAt() + ", data=" + this.getData() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ActivityBuilder {
        private String typeName;
        private String cursor;
        private String id;
        private Object actor;
        private Object recipient;
        private ZonedDateTime insertedAt;
        private ZonedDateTime updatedAt;
        private ArrayList<String> data$key;
        private ArrayList<Object> data$value;

        ActivityBuilder() {
        }

        @JsonProperty(value="__typename")
        public ActivityBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @JsonProperty(value="__cursor")
        public ActivityBuilder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ActivityBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ActivityBuilder actor(Object actor) {
            this.actor = actor;
            return this;
        }

        public ActivityBuilder recipient(Object recipient) {
            this.recipient = recipient;
            return this;
        }

        public ActivityBuilder insertedAt(ZonedDateTime insertedAt) {
            this.insertedAt = insertedAt;
            return this;
        }

        public ActivityBuilder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonAnySetter
        public ActivityBuilder data(String dataKey, Object dataValue) {
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            this.data$key.add(dataKey);
            this.data$value.add(dataValue);
            return this;
        }

        public ActivityBuilder data(Map<? extends String, ? extends Object> data) {
            if (data == null) {
                throw new NullPointerException("data cannot be null");
            }
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : data.entrySet()) {
                this.data$key.add($lombokEntry.getKey());
                this.data$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ActivityBuilder clearData() {
            if (this.data$key != null) {
                this.data$key.clear();
                this.data$value.clear();
            }
            return this;
        }

        public Activity build() {
            Map<String, Object> data;
            switch (this.data$key == null ? 0 : this.data$key.size()) {
                case 0: {
                    data = Collections.emptyMap();
                    break;
                }
                case 1: {
                    data = Collections.singletonMap(this.data$key.get(0), this.data$value.get(0));
                    break;
                }
                default: {
                    data = new LinkedHashMap(this.data$key.size() < 0x40000000 ? 1 + this.data$key.size() + (this.data$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.data$key.size(); ++$i) {
                        data.put(this.data$key.get($i), this.data$value.get($i));
                    }
                    data = Collections.unmodifiableMap(data);
                }
            }
            return new Activity(this.typeName, this.cursor, this.id, this.actor, this.recipient, this.insertedAt, this.updatedAt, data);
        }

        public String toString() {
            return "Activity.ActivityBuilder(typeName=" + this.typeName + ", cursor=" + this.cursor + ", id=" + this.id + ", actor=" + this.actor + ", recipient=" + this.recipient + ", insertedAt=" + this.insertedAt + ", updatedAt=" + this.updatedAt + ", data$key=" + this.data$key + ", data$value=" + this.data$value + ")";
        }
    }
}

