/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.resources;

import app.knock.api.exception.KnockClientResourceException;
import app.knock.api.http.KnockHttp;
import app.knock.api.model.BulkOperation;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.Request;

public final class BulkOperationsResource {
    private static final String BASE_RESOURCE_PATH = "v1/bulk_operations";
    private final KnockHttp knockHttp;

    HttpUrl bulkOperationUrl(String id) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, id).build();
    }

    public BulkOperation get(String bulkOperationId) {
        HttpUrl url = this.bulkOperationUrl(bulkOperationId);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<BulkOperation>(){});
    }

    public Optional<BulkOperation> oGet(String bulkOperationId) {
        try {
            return Optional.of(this.get(bulkOperationId));
        }
        catch (KnockClientResourceException e) {
            return Optional.empty();
        }
    }

    public BulkOperationsResource(KnockHttp knockHttp) {
        this.knockHttp = knockHttp;
    }

    public KnockHttp getKnockHttp() {
        return this.knockHttp;
    }

    public String toString() {
        return "BulkOperationsResource(knockHttp=" + this.getKnockHttp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkOperationsResource)) {
            return false;
        }
        BulkOperationsResource other = (BulkOperationsResource)o;
        KnockHttp this$knockHttp = this.getKnockHttp();
        KnockHttp other$knockHttp = other.getKnockHttp();
        return !(this$knockHttp == null ? other$knockHttp != null : !this$knockHttp.equals(other$knockHttp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KnockHttp $knockHttp = this.getKnockHttp();
        result = result * 59 + ($knockHttp == null ? 43 : $knockHttp.hashCode());
        return result;
    }
}

