/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.resources;

import app.knock.api.http.KnockHttp;
import app.knock.api.model.WorkflowCancelRequest;
import app.knock.api.model.WorkflowTriggerRequest;
import app.knock.api.model.WorkflowTriggerResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

public final class WorkflowsResource {
    private static final String BASE_RESOURCE_PATH = "v1/workflows";
    private final KnockHttp knockHttp;

    HttpUrl workflowUrl(String key, String action) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, key, action).build();
    }

    public WorkflowTriggerResponse trigger(WorkflowTriggerRequest workflowTrigger) {
        HttpUrl url = this.workflowUrl(workflowTrigger.getKey(), "trigger");
        RequestBody body = this.knockHttp.objectToJsonRequestBody(workflowTrigger);
        Request request = this.knockHttp.baseJsonRequest(url).post(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<WorkflowTriggerResponse>(){});
    }

    public void cancel(WorkflowCancelRequest workflowCancelRequest) {
        HttpUrl url = this.workflowUrl(workflowCancelRequest.getKey(), "cancel");
        RequestBody body = this.knockHttp.objectToJsonRequestBody(workflowCancelRequest);
        Request request = this.knockHttp.baseJsonRequest(url).post(body).build();
        this.knockHttp.execute(request);
    }

    public WorkflowsResource(KnockHttp knockHttp) {
        this.knockHttp = knockHttp;
    }

    public KnockHttp getKnockHttp() {
        return this.knockHttp;
    }

    public String toString() {
        return "WorkflowsResource(knockHttp=" + this.getKnockHttp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowsResource)) {
            return false;
        }
        WorkflowsResource other = (WorkflowsResource)o;
        KnockHttp this$knockHttp = this.getKnockHttp();
        KnockHttp other$knockHttp = other.getKnockHttp();
        return !(this$knockHttp == null ? other$knockHttp != null : !this$knockHttp.equals(other$knockHttp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KnockHttp $knockHttp = this.getKnockHttp();
        result = result * 59 + ($knockHttp == null ? 43 : $knockHttp.hashCode());
        return result;
    }
}

