/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=KnockObjectBuilder.class)
public final class KnockObject {
    @JsonProperty(value="__typename")
    private final String typeName;
    private final String id;
    private final String collection;
    private final ZonedDateTime createdAt;
    private final ZonedDateTime updatedAt;
    @JsonAnySetter
    private final Map<String, Object> properties;

    public <T> T property(String key, Class<T> clazz) {
        if (this.properties != null && this.properties.containsKey(key)) {
            Object o = this.properties.get(key);
            return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
        }
        return null;
    }

    KnockObject(String typeName, String id, String collection, ZonedDateTime createdAt, ZonedDateTime updatedAt, Map<String, Object> properties) {
        this.typeName = typeName;
        this.id = id;
        this.collection = collection;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.properties = properties;
    }

    public static KnockObjectBuilder builder() {
        return new KnockObjectBuilder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getId() {
        return this.id;
    }

    public String getCollection() {
        return this.collection;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KnockObject)) {
            return false;
        }
        KnockObject other = (KnockObject)o;
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "KnockObject(typeName=" + this.getTypeName() + ", id=" + this.getId() + ", collection=" + this.getCollection() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", properties=" + this.getProperties() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class KnockObjectBuilder {
        private String typeName;
        private String id;
        private String collection;
        private ZonedDateTime createdAt;
        private ZonedDateTime updatedAt;
        private ArrayList<String> properties$key;
        private ArrayList<Object> properties$value;

        KnockObjectBuilder() {
        }

        @JsonProperty(value="__typename")
        public KnockObjectBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public KnockObjectBuilder id(String id) {
            this.id = id;
            return this;
        }

        public KnockObjectBuilder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public KnockObjectBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public KnockObjectBuilder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonAnySetter
        public KnockObjectBuilder property(String propertyKey, Object propertyValue) {
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            this.properties$key.add(propertyKey);
            this.properties$value.add(propertyValue);
            return this;
        }

        public KnockObjectBuilder properties(Map<? extends String, ? extends Object> properties) {
            if (properties == null) {
                throw new NullPointerException("properties cannot be null");
            }
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : properties.entrySet()) {
                this.properties$key.add($lombokEntry.getKey());
                this.properties$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public KnockObjectBuilder clearProperties() {
            if (this.properties$key != null) {
                this.properties$key.clear();
                this.properties$value.clear();
            }
            return this;
        }

        public KnockObject build() {
            Map<String, Object> properties;
            switch (this.properties$key == null ? 0 : this.properties$key.size()) {
                case 0: {
                    properties = Collections.emptyMap();
                    break;
                }
                case 1: {
                    properties = Collections.singletonMap(this.properties$key.get(0), this.properties$value.get(0));
                    break;
                }
                default: {
                    properties = new LinkedHashMap(this.properties$key.size() < 0x40000000 ? 1 + this.properties$key.size() + (this.properties$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.properties$key.size(); ++$i) {
                        properties.put(this.properties$key.get($i), this.properties$value.get($i));
                    }
                    properties = Collections.unmodifiableMap(properties);
                }
            }
            return new KnockObject(this.typeName, this.id, this.collection, this.createdAt, this.updatedAt, properties);
        }

        public String toString() {
            return "KnockObject.KnockObjectBuilder(typeName=" + this.typeName + ", id=" + this.id + ", collection=" + this.collection + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", properties$key=" + this.properties$key + ", properties$value=" + this.properties$value + ")";
        }
    }
}

