/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.http;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public final class TokenInterceptor
implements Interceptor {
    private final String AUTHORIZATION_HEADER = "Authorization";
    private final String token;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request newRequest = request.newBuilder().addHeader("Authorization", String.format("Bearer %s", this.token)).build();
        return chain.proceed(newRequest);
    }

    public TokenInterceptor(String token) {
        this.token = token;
    }

    public String getAUTHORIZATION_HEADER() {
        return this.AUTHORIZATION_HEADER;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenInterceptor)) {
            return false;
        }
        TokenInterceptor other = (TokenInterceptor)o;
        String this$AUTHORIZATION_HEADER = this.getAUTHORIZATION_HEADER();
        String other$AUTHORIZATION_HEADER = other.getAUTHORIZATION_HEADER();
        if (this$AUTHORIZATION_HEADER == null ? other$AUTHORIZATION_HEADER != null : !this$AUTHORIZATION_HEADER.equals(other$AUTHORIZATION_HEADER)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $AUTHORIZATION_HEADER = this.getAUTHORIZATION_HEADER();
        result = result * 59 + ($AUTHORIZATION_HEADER == null ? 43 : $AUTHORIZATION_HEADER.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "TokenInterceptor(AUTHORIZATION_HEADER=" + this.getAUTHORIZATION_HEADER() + ", token=" + this.getToken() + ")";
    }
}

