/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=BulkAddObjectSubscriptionRequestBuilder.class)
public final class BulkAddObjectSubscriptionRequest {
    @JsonProperty(value="__typename")
    private final String typeName;
    private final String id;
    private final List<Object> recipients;
    @JsonAnySetter
    private final Map<String, Object> properties;

    public <T> T properties(String key, Class<T> clazz) {
        if (this.properties != null && this.properties.containsKey(key)) {
            Object o = this.properties.get(key);
            return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
        }
        return null;
    }

    BulkAddObjectSubscriptionRequest(String typeName, String id, List<Object> recipients, Map<String, Object> properties) {
        this.typeName = typeName;
        this.id = id;
        this.recipients = recipients;
        this.properties = properties;
    }

    public static BulkAddObjectSubscriptionRequestBuilder builder() {
        return new BulkAddObjectSubscriptionRequestBuilder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getId() {
        return this.id;
    }

    public List<Object> getRecipients() {
        return this.recipients;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkAddObjectSubscriptionRequest)) {
            return false;
        }
        BulkAddObjectSubscriptionRequest other = (BulkAddObjectSubscriptionRequest)o;
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<Object> this$recipients = this.getRecipients();
        List<Object> other$recipients = other.getRecipients();
        if (this$recipients == null ? other$recipients != null : !((Object)this$recipients).equals(other$recipients)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<Object> $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : ((Object)$recipients).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "BulkAddObjectSubscriptionRequest(typeName=" + this.getTypeName() + ", id=" + this.getId() + ", recipients=" + this.getRecipients() + ", properties=" + this.getProperties() + ")";
    }

    public static class ObjectRecipientIdentifier {
        String id;
        String collection;

        ObjectRecipientIdentifier(String id, String collection) {
            this.id = id;
            this.collection = collection;
        }

        public static ObjectRecipientIdentifierBuilder builder() {
            return new ObjectRecipientIdentifierBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getCollection() {
            return this.collection;
        }

        public static class ObjectRecipientIdentifierBuilder {
            private String id;
            private String collection;

            ObjectRecipientIdentifierBuilder() {
            }

            public ObjectRecipientIdentifierBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ObjectRecipientIdentifierBuilder collection(String collection) {
                this.collection = collection;
                return this;
            }

            public ObjectRecipientIdentifier build() {
                return new ObjectRecipientIdentifier(this.id, this.collection);
            }

            public String toString() {
                return "BulkAddObjectSubscriptionRequest.ObjectRecipientIdentifier.ObjectRecipientIdentifierBuilder(id=" + this.id + ", collection=" + this.collection + ")";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class BulkAddObjectSubscriptionRequestBuilder {
        private String typeName;
        private String id;
        private ArrayList<String> properties$key;
        private ArrayList<Object> properties$value;
        List<Object> recipients;

        public BulkAddObjectSubscriptionRequestBuilder addRecipient(String ... userIds) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<Object>();
            }
            Collections.addAll(this.recipients, userIds);
            return this;
        }

        public BulkAddObjectSubscriptionRequestBuilder addRecipient(Map<String, Object> recipient) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<Object>();
            }
            Collections.addAll(this.recipients, recipient);
            return this;
        }

        public BulkAddObjectSubscriptionRequestBuilder addRecipient(ObjectRecipientIdentifier identifier) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<Object>();
            }
            Collections.addAll(this.recipients, identifier);
            return this;
        }

        BulkAddObjectSubscriptionRequestBuilder() {
        }

        @JsonProperty(value="__typename")
        public BulkAddObjectSubscriptionRequestBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public BulkAddObjectSubscriptionRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public BulkAddObjectSubscriptionRequestBuilder recipients(List<Object> recipients) {
            this.recipients = recipients;
            return this;
        }

        @JsonAnySetter
        public BulkAddObjectSubscriptionRequestBuilder properties(String propertiesKey, Object propertiesValue) {
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            this.properties$key.add(propertiesKey);
            this.properties$value.add(propertiesValue);
            return this;
        }

        public BulkAddObjectSubscriptionRequestBuilder properties(Map<? extends String, ? extends Object> properties) {
            if (properties == null) {
                throw new NullPointerException("properties cannot be null");
            }
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : properties.entrySet()) {
                this.properties$key.add($lombokEntry.getKey());
                this.properties$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public BulkAddObjectSubscriptionRequestBuilder clearProperties() {
            if (this.properties$key != null) {
                this.properties$key.clear();
                this.properties$value.clear();
            }
            return this;
        }

        public BulkAddObjectSubscriptionRequest build() {
            Map<String, Object> properties;
            switch (this.properties$key == null ? 0 : this.properties$key.size()) {
                case 0: {
                    properties = Collections.emptyMap();
                    break;
                }
                case 1: {
                    properties = Collections.singletonMap(this.properties$key.get(0), this.properties$value.get(0));
                    break;
                }
                default: {
                    properties = new LinkedHashMap(this.properties$key.size() < 0x40000000 ? 1 + this.properties$key.size() + (this.properties$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.properties$key.size(); ++$i) {
                        properties.put(this.properties$key.get($i), this.properties$value.get($i));
                    }
                    properties = Collections.unmodifiableMap(properties);
                }
            }
            return new BulkAddObjectSubscriptionRequest(this.typeName, this.id, this.recipients, properties);
        }

        public String toString() {
            return "BulkAddObjectSubscriptionRequest.BulkAddObjectSubscriptionRequestBuilder(typeName=" + this.typeName + ", id=" + this.id + ", recipients=" + this.recipients + ", properties$key=" + this.properties$key + ", properties$value=" + this.properties$value + ")";
        }
    }
}

