/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=ObjectSubscriptionBuilder.class)
public final class ObjectSubscription {
    @JsonProperty(value="__typename")
    private final String typeName;
    @JsonProperty(value="__cursor")
    private final String cursor;
    private final Object recipient;
    private final Object object;
    private final ZonedDateTime insertedAt;
    private final ZonedDateTime updatedAt;
    @JsonAnySetter
    @JsonSetter(nulls=Nulls.SKIP)
    private final Map<String, Object> properties;

    public <T> T properties(String key, Class<T> clazz) {
        if (this.properties != null && this.properties.containsKey(key)) {
            Object o = this.properties.get(key);
            return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
        }
        return null;
    }

    ObjectSubscription(String typeName, String cursor, Object recipient, Object object, ZonedDateTime insertedAt, ZonedDateTime updatedAt, Map<String, Object> properties) {
        this.typeName = typeName;
        this.cursor = cursor;
        this.recipient = recipient;
        this.object = object;
        this.insertedAt = insertedAt;
        this.updatedAt = updatedAt;
        this.properties = properties;
    }

    public static ObjectSubscriptionBuilder builder() {
        return new ObjectSubscriptionBuilder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getCursor() {
        return this.cursor;
    }

    public Object getRecipient() {
        return this.recipient;
    }

    public Object getObject() {
        return this.object;
    }

    public ZonedDateTime getInsertedAt() {
        return this.insertedAt;
    }

    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectSubscription)) {
            return false;
        }
        ObjectSubscription other = (ObjectSubscription)o;
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        Object this$recipient = this.getRecipient();
        Object other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        Object this$object = this.getObject();
        Object other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        ZonedDateTime this$insertedAt = this.getInsertedAt();
        ZonedDateTime other$insertedAt = other.getInsertedAt();
        if (this$insertedAt == null ? other$insertedAt != null : !((Object)this$insertedAt).equals(other$insertedAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        Object $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        Object $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        ZonedDateTime $insertedAt = this.getInsertedAt();
        result = result * 59 + ($insertedAt == null ? 43 : ((Object)$insertedAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "ObjectSubscription(typeName=" + this.getTypeName() + ", cursor=" + this.getCursor() + ", recipient=" + this.getRecipient() + ", object=" + this.getObject() + ", insertedAt=" + this.getInsertedAt() + ", updatedAt=" + this.getUpdatedAt() + ", properties=" + this.getProperties() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ObjectSubscriptionBuilder {
        private String typeName;
        private String cursor;
        private Object recipient;
        private Object object;
        private ZonedDateTime insertedAt;
        private ZonedDateTime updatedAt;
        private ArrayList<String> properties$key;
        private ArrayList<Object> properties$value;

        ObjectSubscriptionBuilder() {
        }

        @JsonProperty(value="__typename")
        public ObjectSubscriptionBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @JsonProperty(value="__cursor")
        public ObjectSubscriptionBuilder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ObjectSubscriptionBuilder recipient(Object recipient) {
            this.recipient = recipient;
            return this;
        }

        public ObjectSubscriptionBuilder object(Object object) {
            this.object = object;
            return this;
        }

        public ObjectSubscriptionBuilder insertedAt(ZonedDateTime insertedAt) {
            this.insertedAt = insertedAt;
            return this;
        }

        public ObjectSubscriptionBuilder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonAnySetter
        public ObjectSubscriptionBuilder properties(String propertiesKey, Object propertiesValue) {
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            this.properties$key.add(propertiesKey);
            this.properties$value.add(propertiesValue);
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        public ObjectSubscriptionBuilder properties(Map<? extends String, ? extends Object> properties) {
            if (properties == null) {
                throw new NullPointerException("properties cannot be null");
            }
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : properties.entrySet()) {
                this.properties$key.add($lombokEntry.getKey());
                this.properties$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ObjectSubscriptionBuilder clearProperties() {
            if (this.properties$key != null) {
                this.properties$key.clear();
                this.properties$value.clear();
            }
            return this;
        }

        public ObjectSubscription build() {
            Map<String, Object> properties;
            switch (this.properties$key == null ? 0 : this.properties$key.size()) {
                case 0: {
                    properties = Collections.emptyMap();
                    break;
                }
                case 1: {
                    properties = Collections.singletonMap(this.properties$key.get(0), this.properties$value.get(0));
                    break;
                }
                default: {
                    properties = new LinkedHashMap(this.properties$key.size() < 0x40000000 ? 1 + this.properties$key.size() + (this.properties$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.properties$key.size(); ++$i) {
                        properties.put(this.properties$key.get($i), this.properties$value.get($i));
                    }
                    properties = Collections.unmodifiableMap(properties);
                }
            }
            return new ObjectSubscription(this.typeName, this.cursor, this.recipient, this.object, this.insertedAt, this.updatedAt, properties);
        }

        public String toString() {
            return "ObjectSubscription.ObjectSubscriptionBuilder(typeName=" + this.typeName + ", cursor=" + this.cursor + ", recipient=" + this.recipient + ", object=" + this.object + ", insertedAt=" + this.insertedAt + ", updatedAt=" + this.updatedAt + ", properties$key=" + this.properties$key + ", properties$value=" + this.properties$value + ")";
        }
    }
}

