/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import app.knock.api.model.ScheduleRepeat;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=ScheduleBuilder.class)
public final class Schedule {
    @JsonProperty(value="__typename")
    private final String typeName;
    @JsonProperty(value="__cursor")
    private final String cursor;
    private final String id;
    private final String workflow;
    private final Object recipient;
    private final List<ScheduleRepeat> repeats;
    private final Object actor;
    private final String tenant;
    private final ZonedDateTime lastOccurrenceAt;
    private final ZonedDateTime nextOccurrenceAt;
    private final ZonedDateTime insertedAt;
    private final ZonedDateTime updatedAt;
    @JsonAnySetter
    @JsonSetter(nulls=Nulls.SKIP)
    private final Map<String, Object> data;

    public <T> T data(String key, Class<T> clazz) {
        if (this.data != null && this.data.containsKey(key)) {
            Object o = this.data.get(key);
            return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
        }
        return null;
    }

    Schedule(String typeName, String cursor, String id, String workflow, Object recipient, List<ScheduleRepeat> repeats, Object actor, String tenant, ZonedDateTime lastOccurrenceAt, ZonedDateTime nextOccurrenceAt, ZonedDateTime insertedAt, ZonedDateTime updatedAt, Map<String, Object> data) {
        this.typeName = typeName;
        this.cursor = cursor;
        this.id = id;
        this.workflow = workflow;
        this.recipient = recipient;
        this.repeats = repeats;
        this.actor = actor;
        this.tenant = tenant;
        this.lastOccurrenceAt = lastOccurrenceAt;
        this.nextOccurrenceAt = nextOccurrenceAt;
        this.insertedAt = insertedAt;
        this.updatedAt = updatedAt;
        this.data = data;
    }

    public static ScheduleBuilder builder() {
        return new ScheduleBuilder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String getId() {
        return this.id;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public Object getRecipient() {
        return this.recipient;
    }

    public List<ScheduleRepeat> getRepeats() {
        return this.repeats;
    }

    public Object getActor() {
        return this.actor;
    }

    public String getTenant() {
        return this.tenant;
    }

    public ZonedDateTime getLastOccurrenceAt() {
        return this.lastOccurrenceAt;
    }

    public ZonedDateTime getNextOccurrenceAt() {
        return this.nextOccurrenceAt;
    }

    public ZonedDateTime getInsertedAt() {
        return this.insertedAt;
    }

    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)o;
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$workflow = this.getWorkflow();
        String other$workflow = other.getWorkflow();
        if (this$workflow == null ? other$workflow != null : !this$workflow.equals(other$workflow)) {
            return false;
        }
        Object this$recipient = this.getRecipient();
        Object other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        List<ScheduleRepeat> this$repeats = this.getRepeats();
        List<ScheduleRepeat> other$repeats = other.getRepeats();
        if (this$repeats == null ? other$repeats != null : !((Object)this$repeats).equals(other$repeats)) {
            return false;
        }
        Object this$actor = this.getActor();
        Object other$actor = other.getActor();
        if (this$actor == null ? other$actor != null : !this$actor.equals(other$actor)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        ZonedDateTime this$lastOccurrenceAt = this.getLastOccurrenceAt();
        ZonedDateTime other$lastOccurrenceAt = other.getLastOccurrenceAt();
        if (this$lastOccurrenceAt == null ? other$lastOccurrenceAt != null : !((Object)this$lastOccurrenceAt).equals(other$lastOccurrenceAt)) {
            return false;
        }
        ZonedDateTime this$nextOccurrenceAt = this.getNextOccurrenceAt();
        ZonedDateTime other$nextOccurrenceAt = other.getNextOccurrenceAt();
        if (this$nextOccurrenceAt == null ? other$nextOccurrenceAt != null : !((Object)this$nextOccurrenceAt).equals(other$nextOccurrenceAt)) {
            return false;
        }
        ZonedDateTime this$insertedAt = this.getInsertedAt();
        ZonedDateTime other$insertedAt = other.getInsertedAt();
        if (this$insertedAt == null ? other$insertedAt != null : !((Object)this$insertedAt).equals(other$insertedAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Map<String, Object> this$data = this.getData();
        Map<String, Object> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $workflow = this.getWorkflow();
        result = result * 59 + ($workflow == null ? 43 : $workflow.hashCode());
        Object $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        List<ScheduleRepeat> $repeats = this.getRepeats();
        result = result * 59 + ($repeats == null ? 43 : ((Object)$repeats).hashCode());
        Object $actor = this.getActor();
        result = result * 59 + ($actor == null ? 43 : $actor.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        ZonedDateTime $lastOccurrenceAt = this.getLastOccurrenceAt();
        result = result * 59 + ($lastOccurrenceAt == null ? 43 : ((Object)$lastOccurrenceAt).hashCode());
        ZonedDateTime $nextOccurrenceAt = this.getNextOccurrenceAt();
        result = result * 59 + ($nextOccurrenceAt == null ? 43 : ((Object)$nextOccurrenceAt).hashCode());
        ZonedDateTime $insertedAt = this.getInsertedAt();
        result = result * 59 + ($insertedAt == null ? 43 : ((Object)$insertedAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Map<String, Object> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "Schedule(typeName=" + this.getTypeName() + ", cursor=" + this.getCursor() + ", id=" + this.getId() + ", workflow=" + this.getWorkflow() + ", recipient=" + this.getRecipient() + ", repeats=" + this.getRepeats() + ", actor=" + this.getActor() + ", tenant=" + this.getTenant() + ", lastOccurrenceAt=" + this.getLastOccurrenceAt() + ", nextOccurrenceAt=" + this.getNextOccurrenceAt() + ", insertedAt=" + this.getInsertedAt() + ", updatedAt=" + this.getUpdatedAt() + ", data=" + this.getData() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ScheduleBuilder {
        private String typeName;
        private String cursor;
        private String id;
        private String workflow;
        private Object recipient;
        private List<ScheduleRepeat> repeats;
        private Object actor;
        private String tenant;
        private ZonedDateTime lastOccurrenceAt;
        private ZonedDateTime nextOccurrenceAt;
        private ZonedDateTime insertedAt;
        private ZonedDateTime updatedAt;
        private ArrayList<String> data$key;
        private ArrayList<Object> data$value;

        ScheduleBuilder() {
        }

        @JsonProperty(value="__typename")
        public ScheduleBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @JsonProperty(value="__cursor")
        public ScheduleBuilder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ScheduleBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ScheduleBuilder workflow(String workflow) {
            this.workflow = workflow;
            return this;
        }

        public ScheduleBuilder recipient(Object recipient) {
            this.recipient = recipient;
            return this;
        }

        public ScheduleBuilder repeats(List<ScheduleRepeat> repeats) {
            this.repeats = repeats;
            return this;
        }

        public ScheduleBuilder actor(Object actor) {
            this.actor = actor;
            return this;
        }

        public ScheduleBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public ScheduleBuilder lastOccurrenceAt(ZonedDateTime lastOccurrenceAt) {
            this.lastOccurrenceAt = lastOccurrenceAt;
            return this;
        }

        public ScheduleBuilder nextOccurrenceAt(ZonedDateTime nextOccurrenceAt) {
            this.nextOccurrenceAt = nextOccurrenceAt;
            return this;
        }

        public ScheduleBuilder insertedAt(ZonedDateTime insertedAt) {
            this.insertedAt = insertedAt;
            return this;
        }

        public ScheduleBuilder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonAnySetter
        public ScheduleBuilder data(String dataKey, Object dataValue) {
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            this.data$key.add(dataKey);
            this.data$value.add(dataValue);
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        public ScheduleBuilder data(Map<? extends String, ? extends Object> data) {
            if (data == null) {
                throw new NullPointerException("data cannot be null");
            }
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : data.entrySet()) {
                this.data$key.add($lombokEntry.getKey());
                this.data$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ScheduleBuilder clearData() {
            if (this.data$key != null) {
                this.data$key.clear();
                this.data$value.clear();
            }
            return this;
        }

        public Schedule build() {
            Map<Object, Object> data;
            switch (this.data$key == null ? 0 : this.data$key.size()) {
                case 0: {
                    data = Collections.emptyMap();
                    break;
                }
                case 1: {
                    data = Collections.singletonMap(this.data$key.get(0), this.data$value.get(0));
                    break;
                }
                default: {
                    data = new LinkedHashMap(this.data$key.size() < 0x40000000 ? 1 + this.data$key.size() + (this.data$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.data$key.size(); ++$i) {
                        data.put(this.data$key.get($i), this.data$value.get($i));
                    }
                    data = Collections.unmodifiableMap(data);
                }
            }
            return new Schedule(this.typeName, this.cursor, this.id, this.workflow, this.recipient, this.repeats, this.actor, this.tenant, this.lastOccurrenceAt, this.nextOccurrenceAt, this.insertedAt, this.updatedAt, data);
        }

        public String toString() {
            return "Schedule.ScheduleBuilder(typeName=" + this.typeName + ", cursor=" + this.cursor + ", id=" + this.id + ", workflow=" + this.workflow + ", recipient=" + this.recipient + ", repeats=" + this.repeats + ", actor=" + this.actor + ", tenant=" + this.tenant + ", lastOccurrenceAt=" + this.lastOccurrenceAt + ", nextOccurrenceAt=" + this.nextOccurrenceAt + ", insertedAt=" + this.insertedAt + ", updatedAt=" + this.updatedAt + ", data$key=" + this.data$key + ", data$value=" + this.data$value + ")";
        }
    }
}

