/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.resources;

import app.knock.api.http.KnockHttp;
import app.knock.api.model.AddSubscriptionsRequest;
import app.knock.api.model.BulkAddObjectSubscriptionRequest;
import app.knock.api.model.BulkOperation;
import app.knock.api.model.ChannelData;
import app.knock.api.model.CursorResult;
import app.knock.api.model.DeleteSubscriptionsRequest;
import app.knock.api.model.KnockMessage;
import app.knock.api.model.KnockObject;
import app.knock.api.model.ObjectSubscription;
import app.knock.api.model.PreferenceSet;
import app.knock.api.model.PreferenceSetRequest;
import app.knock.api.model.Schedule;
import app.knock.api.resources.MessagesResource;
import app.knock.api.resources.WorkflowsResource;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

public final class ObjectsResource {
    private static final String BASE_RESOURCE_PATH = "v1/objects";
    private final KnockHttp knockHttp;

    HttpUrl buildListResource(String objectId, ListParams queryParams) {
        HttpUrl.Builder urlBuilder = this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, objectId);
        queryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    HttpUrl objectUrl(String collection, String objectId) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, collection, objectId).build();
    }

    HttpUrl objectChannelDataUrl(String collection, String objectId, String channelId) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, collection, objectId, "channel_data", channelId).build();
    }

    HttpUrl objectMessagesUrl(String collection, String objectId, MessagesResource.QueryParams queryParams) {
        HttpUrl.Builder urlBuilder = this.objectUrl(collection, objectId).newBuilder().addEncodedPathSegment("messages");
        queryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    HttpUrl objectSchedulesUrl(String collection, String objectId, WorkflowsResource.SchedulesQueryParams queryParams) {
        HttpUrl.Builder urlBuilder = this.objectUrl(collection, objectId).newBuilder().addEncodedPathSegment("schedules");
        queryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    HttpUrl objectSubscriptionsUrl(String collection, String objectId) {
        HttpUrl.Builder urlBuilder = this.objectUrl(collection, objectId).newBuilder().addEncodedPathSegment("subscriptions");
        return urlBuilder.build();
    }

    HttpUrl listObjectSubscriptionsUrl(String collection, String objectId, ListSubscriptionParams queryParams) {
        HttpUrl.Builder urlBuilder = this.objectUrl(collection, objectId).newBuilder().addEncodedPathSegment("subscriptions");
        queryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    HttpUrl objectPreferencesUrl(String collection, String objectId) {
        return this.objectUrl(collection, objectId).newBuilder().addEncodedPathSegment("preferences").build();
    }

    HttpUrl objectPreferenceUrl(String collection, String objectId, String preferenceId) {
        return this.objectUrl(collection, objectId).newBuilder().addEncodedPathSegment("preferences").addEncodedPathSegment(preferenceId).build();
    }

    HttpUrl objectBulkSetUrl(String collection) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, collection, "bulk", "set").build();
    }

    HttpUrl objectBulkDeleteUrl(String collection) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, collection, "bulk", "delete").build();
    }

    HttpUrl objectBulkAddSubscriptionsUrl(String collection) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, collection, "bulk", "subscriptions", "add").build();
    }

    public KnockObject get(String collection, String objectId) {
        HttpUrl url = this.objectUrl(collection, objectId);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<KnockObject>(){});
    }

    public CursorResult<KnockObject> list(String collection, ListParams queryParams) {
        HttpUrl url = this.buildListResource(collection, queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<KnockObject>>(){});
    }

    public KnockObject set(String collection, String objectId, Map<String, Object> properties) {
        HttpUrl url = this.objectUrl(collection, objectId);
        RequestBody body = this.knockHttp.objectToJsonRequestBody(properties);
        Request request = this.knockHttp.baseJsonRequest(url).put(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<KnockObject>(){});
    }

    public void delete(String collection, String objectId) {
        HttpUrl url = this.objectUrl(collection, objectId);
        Request request = this.knockHttp.baseJsonRequest(url).delete().build();
        this.knockHttp.execute(request);
    }

    public ChannelData getChannelData(String collection, String objectId, String channelId) {
        HttpUrl url = this.objectChannelDataUrl(collection, objectId, channelId);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<ChannelData>(){});
    }

    public ChannelData setChannelData(String collection, String objectId, String channelId, Map<String, Object> data) {
        HttpUrl url = this.objectChannelDataUrl(collection, objectId, channelId);
        RequestBody body = this.knockHttp.objectToJsonRequestBody(Collections.singletonMap("data", data));
        Request request = this.knockHttp.baseJsonRequest(url).put(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<ChannelData>(){});
    }

    public void unsetChannelData(String collection, String objectId, String channelId) {
        HttpUrl url = this.objectChannelDataUrl(collection, objectId, channelId);
        Request request = this.knockHttp.baseJsonRequest(url).delete().build();
        this.knockHttp.execute(request);
    }

    public CursorResult<KnockMessage> getMessages(String collection, String objectId, MessagesResource.QueryParams queryParams) {
        HttpUrl url = this.objectMessagesUrl(collection, objectId, queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<KnockMessage>>(){});
    }

    public CursorResult<Schedule> getSchedules(String collection, String objectId, WorkflowsResource.SchedulesQueryParams queryParams) {
        HttpUrl url = this.objectSchedulesUrl(collection, objectId, queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<Schedule>>(){});
    }

    public CursorResult<ObjectSubscription> listSubscriptions(String collection, String objectId, ListSubscriptionParams queryParams) {
        HttpUrl url = this.listObjectSubscriptionsUrl(collection, objectId, queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<ObjectSubscription>>(){});
    }

    public CursorResult<ObjectSubscription> getSubscriptions(String collection, String objectId, ListSubscriptionParams queryParams) {
        queryParams.mode("recipient");
        HttpUrl url = this.listObjectSubscriptionsUrl(collection, objectId, queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<ObjectSubscription>>(){});
    }

    public List<ObjectSubscription> addSubscriptions(String collection, String objectId, AddSubscriptionsRequest addSubscriptionsRequest) {
        HttpUrl url = this.objectSubscriptionsUrl(collection, objectId);
        RequestBody body = this.knockHttp.objectToJsonRequestBody(addSubscriptionsRequest);
        Request.Builder requestBuilder = this.knockHttp.baseJsonRequest(url).post(body);
        Request request = requestBuilder.build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<List<ObjectSubscription>>(){});
    }

    public BulkOperation bulkAddSubscriptions(String collection, List<BulkAddObjectSubscriptionRequest> subscriptions) {
        HttpUrl url = this.objectBulkAddSubscriptionsUrl(collection);
        RequestBody body = this.knockHttp.objectToJsonRequestBody(Collections.singletonMap("subscriptions", subscriptions));
        Request request = this.knockHttp.baseJsonRequest(url).post(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<BulkOperation>(){});
    }

    public List<ObjectSubscription> deleteSubscriptions(String collection, String objectId, DeleteSubscriptionsRequest deleteSubscriptionsRequest) {
        HttpUrl url = this.objectSubscriptionsUrl(collection, objectId);
        RequestBody body = this.knockHttp.objectToJsonRequestBody(deleteSubscriptionsRequest);
        Request.Builder requestBuilder = this.knockHttp.baseJsonRequest(url).post(body);
        Request request = requestBuilder.build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<List<ObjectSubscription>>(){});
    }

    public List<PreferenceSet> getPreferences(String collection, String objectId) {
        HttpUrl url = this.objectPreferencesUrl(collection, objectId);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<List<PreferenceSet>>(){});
    }

    public PreferenceSet getPreferencesById(String collection, String objectId, String preferenceId) {
        HttpUrl url = this.objectPreferenceUrl(collection, objectId, preferenceId);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<PreferenceSet>(){});
    }

    public PreferenceSet setPreferences(String collection, String objectId, String preferenceId, PreferenceSetRequest preferenceSetRequest) {
        HttpUrl url = this.objectPreferenceUrl(collection, objectId, preferenceId);
        Request request = this.knockHttp.baseJsonRequest(url).put(this.knockHttp.objectToJsonRequestBody(preferenceSetRequest)).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<PreferenceSet>(){});
    }

    public BulkOperation bulkSetInCollection(String collection, List<Map<String, Object>> objects) {
        objects.stream().filter(object -> object.get("id") != null).findAny().orElseThrow(() -> new IllegalArgumentException("All object maps in the objects list must have a key of 'id' with a non-null string value."));
        HttpUrl url = this.objectBulkSetUrl(collection);
        Request request = this.knockHttp.baseJsonRequest(url).post(this.knockHttp.objectToJsonRequestBody(Collections.singletonMap("objects", objects))).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<BulkOperation>(){});
    }

    public BulkOperation bulkDeleteInCollection(String collection, List<String> object_ids) {
        HttpUrl url = this.objectBulkDeleteUrl(collection);
        Request request = this.knockHttp.baseJsonRequest(url).post(this.knockHttp.objectToJsonRequestBody(Collections.singletonMap("object_ids", object_ids))).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<BulkOperation>(){});
    }

    public ObjectsResource(KnockHttp knockHttp) {
        this.knockHttp = knockHttp;
    }

    public KnockHttp getKnockHttp() {
        return this.knockHttp;
    }

    public String toString() {
        return "ObjectsResource(knockHttp=" + this.getKnockHttp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectsResource)) {
            return false;
        }
        ObjectsResource other = (ObjectsResource)o;
        KnockHttp this$knockHttp = this.getKnockHttp();
        KnockHttp other$knockHttp = other.getKnockHttp();
        return !(this$knockHttp == null ? other$knockHttp != null : !this$knockHttp.equals(other$knockHttp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KnockHttp $knockHttp = this.getKnockHttp();
        result = result * 59 + ($knockHttp == null ? 43 : $knockHttp.hashCode());
        return result;
    }

    public static final class ListSubscriptionParams {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public void pageSize(Integer pageSize) {
            this.params.put("page_size", pageSize);
        }

        public void after(String after) {
            this.params.put("after", after);
        }

        public void before(String before) {
            this.params.put("before", before);
        }

        public void mode(String mode) {
            this.params.put("mode", mode);
        }

        public void addQueryParams(HttpUrl.Builder uriBuilder) {
            this.params.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> uriBuilder.addQueryParameter((String)entry.getKey(), entry.getValue().toString()));
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public String toString() {
            return "ObjectsResource.ListSubscriptionParams(params=" + this.getParams() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListSubscriptionParams)) {
                return false;
            }
            ListSubscriptionParams other = (ListSubscriptionParams)o;
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }
    }

    public static final class ListParams {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public void pageSize(Integer pageSize) {
            this.params.put("page_size", pageSize);
        }

        public void after(String after) {
            this.params.put("after", after);
        }

        public void before(String before) {
            this.params.put("before", before);
        }

        public void addQueryParams(HttpUrl.Builder uriBuilder) {
            this.params.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> uriBuilder.addQueryParameter((String)entry.getKey(), entry.getValue().toString()));
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public String toString() {
            return "ObjectsResource.ListParams(params=" + this.getParams() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListParams)) {
                return false;
            }
            ListParams other = (ListParams)o;
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }
    }
}

