/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.resources;

import app.knock.api.exception.KnockClientResourceException;
import app.knock.api.http.KnockHttp;
import app.knock.api.model.BulkOperation;
import app.knock.api.model.ChannelData;
import app.knock.api.model.CursorResult;
import app.knock.api.model.FeedCursorResult;
import app.knock.api.model.KnockMessage;
import app.knock.api.model.ObjectSubscription;
import app.knock.api.model.PreferenceSet;
import app.knock.api.model.PreferenceSetRequest;
import app.knock.api.model.Schedule;
import app.knock.api.model.UserIdentity;
import app.knock.api.resources.MessagesResource;
import app.knock.api.resources.ObjectsResource;
import app.knock.api.resources.WorkflowsResource;
import app.knock.api.serialize.Json;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

public final class UsersResource {
    private static final String BASE_RESOURCE_PATH = "v1/users";
    private final KnockHttp knockHttp;

    HttpUrl buildListResource(UsersParams queryParams) {
        HttpUrl.Builder urlBuilder = this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, new String[0]);
        queryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    HttpUrl userUrl(String userId) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, userId).build();
    }

    HttpUrl userChannelUrl(String userId, String channelId) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, userId, "channel_data", channelId).build();
    }

    HttpUrl userMergeUrl(String userId) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, userId, "merge").build();
    }

    HttpUrl userPreferencesUrl(String userId) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, userId, "preferences").build();
    }

    HttpUrl userPreferencesUrl(String userId, String preferenceId) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, userId, "preferences", preferenceId).build();
    }

    HttpUrl userMessagesUrl(String userId, MessagesResource.QueryParams queryParams) {
        HttpUrl.Builder urlBuilder = this.userUrl(userId).newBuilder().addEncodedPathSegment("messages");
        queryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    HttpUrl userSchedulesUrl(String userId, WorkflowsResource.SchedulesQueryParams queryParams) {
        HttpUrl.Builder urlBuilder = this.userUrl(userId).newBuilder().addEncodedPathSegment("schedules");
        queryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    HttpUrl userSubscriptionsUrl(String userId, ObjectsResource.ListParams queryParams) {
        HttpUrl.Builder urlBuilder = this.userUrl(userId).newBuilder().addEncodedPathSegment("subscriptions");
        queryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    HttpUrl userFeedUrl(String userId, String feedId, FeedQueryParams feedQueryParams) {
        HttpUrl.Builder urlBuilder = this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, userId, "feeds", feedId);
        feedQueryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    HttpUrl userBulkActionUrl(String action) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, "bulk", action).build();
    }

    public UserIdentity identify(UserIdentity identity) {
        if (identity.getId() == null) {
            throw new IllegalArgumentException("identity.id must not be null");
        }
        return this.identify(identity.getId(), identity);
    }

    public UserIdentity identify(String userId, UserIdentity identity) {
        HttpUrl url = this.userUrl(userId);
        RequestBody body = this.knockHttp.objectToJsonRequestBody(identity);
        Request request = this.knockHttp.baseJsonRequest(url).put(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<UserIdentity>(){});
    }

    public BulkOperation bulkIdentify(List<UserIdentity> userIdentities) {
        HttpUrl url = this.userBulkActionUrl("identify");
        RequestBody body = this.knockHttp.objectToJsonRequestBody(Collections.singletonMap("users", userIdentities));
        Request request = this.knockHttp.baseJsonRequest(url).post(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<BulkOperation>(){});
    }

    public UserIdentity get(String userId) {
        HttpUrl url = this.userUrl(userId);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<UserIdentity>(){});
    }

    public CursorResult<UserIdentity> list(UsersParams queryParams) {
        HttpUrl url = this.buildListResource(queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<UserIdentity>>(){});
    }

    public Optional<UserIdentity> oGet(String userId) {
        try {
            return Optional.of(this.get(userId));
        }
        catch (KnockClientResourceException e) {
            return Optional.empty();
        }
    }

    public UserIdentity merge(String userId, String fromUserId) {
        HttpUrl url = this.userUrl(userId);
        Request request = this.knockHttp.baseJsonRequest(url).post(this.knockHttp.objectToJsonRequestBody(Collections.singletonMap("from_user_id", fromUserId))).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<UserIdentity>(){});
    }

    public void delete(String userId) {
        HttpUrl url = this.userUrl(userId);
        Request request = this.knockHttp.baseJsonRequest(url).delete().build();
        this.knockHttp.execute(request);
    }

    public BulkOperation bulkDelete(List<String> userIds) {
        HttpUrl url = this.userBulkActionUrl("delete");
        RequestBody body = this.knockHttp.objectToJsonRequestBody(Collections.singletonMap("user_ids", userIds));
        Request request = this.knockHttp.baseJsonRequest(url).post(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<BulkOperation>(){});
    }

    public CursorResult<KnockMessage> getMessages(String userId, MessagesResource.QueryParams queryParams) {
        HttpUrl url = this.userMessagesUrl(userId, queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<KnockMessage>>(){});
    }

    public CursorResult<Schedule> getSchedules(String userId, WorkflowsResource.SchedulesQueryParams queryParams) {
        HttpUrl url = this.userSchedulesUrl(userId, queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<Schedule>>(){});
    }

    public CursorResult<ObjectSubscription> getSubscriptions(String userId, ObjectsResource.ListParams queryParams) {
        HttpUrl url = this.userSubscriptionsUrl(userId, queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<ObjectSubscription>>(){});
    }

    public ChannelData getChannelData(String userId, String channelId) {
        HttpUrl url = this.userChannelUrl(userId, channelId);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<ChannelData>(){});
    }

    public void unsetChannelData(String userId, String channelId) {
        HttpUrl url = this.userChannelUrl(userId, channelId);
        Request request = this.knockHttp.baseJsonRequest(url).delete().build();
        this.knockHttp.execute(request);
    }

    public ChannelData setChannelData(String userId, String channelId, Map<String, Object> data) {
        HttpUrl url = this.userChannelUrl(userId, channelId);
        RequestBody body = this.knockHttp.objectToJsonRequestBody(Collections.singletonMap("data", data));
        Request request = this.knockHttp.baseJsonRequest(url).put(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<ChannelData>(){});
    }

    public List<PreferenceSet> getPreferences(String userId) {
        HttpUrl url = this.userPreferencesUrl(userId);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<List<PreferenceSet>>(){});
    }

    public PreferenceSet getDefaultPreferences(String userId) {
        return this.getPreferencesById(userId, "default");
    }

    public PreferenceSet getPreferencesById(String userId, String preferenceId) {
        HttpUrl url = this.userPreferencesUrl(userId, preferenceId);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<PreferenceSet>(){});
    }

    public PreferenceSet setPreferences(String userId, PreferenceSetRequest preferenceSetRequest) {
        String preferenceSetId = "default";
        if (preferenceSetRequest.getId() != null) {
            preferenceSetId = preferenceSetRequest.getId();
        }
        HttpUrl url = this.userPreferencesUrl(userId, preferenceSetId);
        RequestBody body = this.knockHttp.objectToJsonRequestBody(preferenceSetRequest);
        Request request = this.knockHttp.baseJsonRequest(url).put(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<PreferenceSet>(){});
    }

    public FeedCursorResult getFeed(String userId, String feedId, FeedQueryParams feedQueryParams) {
        HttpUrl url = this.userFeedUrl(userId, feedId, feedQueryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<FeedCursorResult>(){});
    }

    public UsersResource(KnockHttp knockHttp) {
        this.knockHttp = knockHttp;
    }

    public KnockHttp getKnockHttp() {
        return this.knockHttp;
    }

    public String toString() {
        return "UsersResource(knockHttp=" + this.getKnockHttp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsersResource)) {
            return false;
        }
        UsersResource other = (UsersResource)o;
        KnockHttp this$knockHttp = this.getKnockHttp();
        KnockHttp other$knockHttp = other.getKnockHttp();
        return !(this$knockHttp == null ? other$knockHttp != null : !this$knockHttp.equals(other$knockHttp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KnockHttp $knockHttp = this.getKnockHttp();
        result = result * 59 + ($knockHttp == null ? 43 : $knockHttp.hashCode());
        return result;
    }

    public static final class UsersParams {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public void pageSize(Integer pageSize) {
            this.params.put("page_size", pageSize);
        }

        public void after(String after) {
            this.params.put("after", after);
        }

        public void before(String before) {
            this.params.put("before", before);
        }

        public void addQueryParams(HttpUrl.Builder uriBuilder) {
            this.params.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> uriBuilder.addQueryParameter((String)entry.getKey(), entry.getValue().toString()));
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public String toString() {
            return "UsersResource.UsersParams(params=" + this.getParams() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsersParams)) {
                return false;
            }
            UsersParams other = (UsersParams)o;
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }
    }

    public static final class FeedQueryParams {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public void pageSize(Integer pageSize) {
            this.params.put("page_size", pageSize);
        }

        public void after(String after) {
            this.params.put("after", after);
        }

        public void before(String before) {
            this.params.put("before", before);
        }

        public void tenant(String tenant) {
            this.params.put("tenant", tenant);
        }

        public void has_tenant(boolean tenant) {
            this.params.put("has_tenant", tenant);
        }

        public void source(String source) {
            this.params.put("source", source);
        }

        public void status(String ... status) {
            this.params.put("status[]", Arrays.toString(status));
        }

        public void trigger_data(Map<String, Object> triggerData) {
            this.params.put("trigger_data", Json.writeString(triggerData));
        }

        public void addQueryParams(HttpUrl.Builder uriBuilder) {
            this.params.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> uriBuilder.addQueryParameter((String)entry.getKey(), entry.getValue().toString()));
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public String toString() {
            return "UsersResource.FeedQueryParams(params=" + this.getParams() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeedQueryParams)) {
                return false;
            }
            FeedQueryParams other = (FeedQueryParams)o;
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }
    }
}

