/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import app.knock.api.model.WorkflowSource;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=KnockMessageBuilder.class)
public final class KnockMessage {
    @JsonProperty(value="__typename")
    private final String typeName;
    @JsonProperty(value="__cursor")
    private final String cursor;
    private final String id;
    private final String channelId;
    private final Object recipient;
    private final String workflow;
    private final String tenant;
    private final String status;
    private final ZonedDateTime readAt;
    private final ZonedDateTime seenAt;
    private final ZonedDateTime archivedAt;
    private final ZonedDateTime insertedAt;
    private final ZonedDateTime updatedAt;
    private final WorkflowSource source;
    @JsonAnySetter
    @JsonSetter(nulls=Nulls.SKIP)
    private final Map<String, Object> data;

    public <T> T data(String key, Class<T> clazz) {
        if (this.data != null && this.data.containsKey(key)) {
            Object o = this.data.get(key);
            return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
        }
        return null;
    }

    KnockMessage(String typeName, String cursor, String id, String channelId, Object recipient, String workflow, String tenant, String status, ZonedDateTime readAt, ZonedDateTime seenAt, ZonedDateTime archivedAt, ZonedDateTime insertedAt, ZonedDateTime updatedAt, WorkflowSource source, Map<String, Object> data) {
        this.typeName = typeName;
        this.cursor = cursor;
        this.id = id;
        this.channelId = channelId;
        this.recipient = recipient;
        this.workflow = workflow;
        this.tenant = tenant;
        this.status = status;
        this.readAt = readAt;
        this.seenAt = seenAt;
        this.archivedAt = archivedAt;
        this.insertedAt = insertedAt;
        this.updatedAt = updatedAt;
        this.source = source;
        this.data = data;
    }

    public static KnockMessageBuilder builder() {
        return new KnockMessageBuilder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String getId() {
        return this.id;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public Object getRecipient() {
        return this.recipient;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getStatus() {
        return this.status;
    }

    public ZonedDateTime getReadAt() {
        return this.readAt;
    }

    public ZonedDateTime getSeenAt() {
        return this.seenAt;
    }

    public ZonedDateTime getArchivedAt() {
        return this.archivedAt;
    }

    public ZonedDateTime getInsertedAt() {
        return this.insertedAt;
    }

    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public WorkflowSource getSource() {
        return this.source;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KnockMessage)) {
            return false;
        }
        KnockMessage other = (KnockMessage)o;
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        Object this$recipient = this.getRecipient();
        Object other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        String this$workflow = this.getWorkflow();
        String other$workflow = other.getWorkflow();
        if (this$workflow == null ? other$workflow != null : !this$workflow.equals(other$workflow)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ZonedDateTime this$readAt = this.getReadAt();
        ZonedDateTime other$readAt = other.getReadAt();
        if (this$readAt == null ? other$readAt != null : !((Object)this$readAt).equals(other$readAt)) {
            return false;
        }
        ZonedDateTime this$seenAt = this.getSeenAt();
        ZonedDateTime other$seenAt = other.getSeenAt();
        if (this$seenAt == null ? other$seenAt != null : !((Object)this$seenAt).equals(other$seenAt)) {
            return false;
        }
        ZonedDateTime this$archivedAt = this.getArchivedAt();
        ZonedDateTime other$archivedAt = other.getArchivedAt();
        if (this$archivedAt == null ? other$archivedAt != null : !((Object)this$archivedAt).equals(other$archivedAt)) {
            return false;
        }
        ZonedDateTime this$insertedAt = this.getInsertedAt();
        ZonedDateTime other$insertedAt = other.getInsertedAt();
        if (this$insertedAt == null ? other$insertedAt != null : !((Object)this$insertedAt).equals(other$insertedAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        WorkflowSource this$source = this.getSource();
        WorkflowSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Map<String, Object> this$data = this.getData();
        Map<String, Object> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        Object $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        String $workflow = this.getWorkflow();
        result = result * 59 + ($workflow == null ? 43 : $workflow.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ZonedDateTime $readAt = this.getReadAt();
        result = result * 59 + ($readAt == null ? 43 : ((Object)$readAt).hashCode());
        ZonedDateTime $seenAt = this.getSeenAt();
        result = result * 59 + ($seenAt == null ? 43 : ((Object)$seenAt).hashCode());
        ZonedDateTime $archivedAt = this.getArchivedAt();
        result = result * 59 + ($archivedAt == null ? 43 : ((Object)$archivedAt).hashCode());
        ZonedDateTime $insertedAt = this.getInsertedAt();
        result = result * 59 + ($insertedAt == null ? 43 : ((Object)$insertedAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        WorkflowSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Map<String, Object> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "KnockMessage(typeName=" + this.getTypeName() + ", cursor=" + this.getCursor() + ", id=" + this.getId() + ", channelId=" + this.getChannelId() + ", recipient=" + this.getRecipient() + ", workflow=" + this.getWorkflow() + ", tenant=" + this.getTenant() + ", status=" + this.getStatus() + ", readAt=" + this.getReadAt() + ", seenAt=" + this.getSeenAt() + ", archivedAt=" + this.getArchivedAt() + ", insertedAt=" + this.getInsertedAt() + ", updatedAt=" + this.getUpdatedAt() + ", source=" + this.getSource() + ", data=" + this.getData() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class KnockMessageBuilder {
        private String typeName;
        private String cursor;
        private String id;
        private String channelId;
        private Object recipient;
        private String workflow;
        private String tenant;
        private String status;
        private ZonedDateTime readAt;
        private ZonedDateTime seenAt;
        private ZonedDateTime archivedAt;
        private ZonedDateTime insertedAt;
        private ZonedDateTime updatedAt;
        private WorkflowSource source;
        private ArrayList<String> data$key;
        private ArrayList<Object> data$value;

        KnockMessageBuilder() {
        }

        @JsonProperty(value="__typename")
        public KnockMessageBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @JsonProperty(value="__cursor")
        public KnockMessageBuilder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public KnockMessageBuilder id(String id) {
            this.id = id;
            return this;
        }

        public KnockMessageBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public KnockMessageBuilder recipient(Object recipient) {
            this.recipient = recipient;
            return this;
        }

        public KnockMessageBuilder workflow(String workflow) {
            this.workflow = workflow;
            return this;
        }

        public KnockMessageBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public KnockMessageBuilder status(String status) {
            this.status = status;
            return this;
        }

        public KnockMessageBuilder readAt(ZonedDateTime readAt) {
            this.readAt = readAt;
            return this;
        }

        public KnockMessageBuilder seenAt(ZonedDateTime seenAt) {
            this.seenAt = seenAt;
            return this;
        }

        public KnockMessageBuilder archivedAt(ZonedDateTime archivedAt) {
            this.archivedAt = archivedAt;
            return this;
        }

        public KnockMessageBuilder insertedAt(ZonedDateTime insertedAt) {
            this.insertedAt = insertedAt;
            return this;
        }

        public KnockMessageBuilder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public KnockMessageBuilder source(WorkflowSource source) {
            this.source = source;
            return this;
        }

        @JsonAnySetter
        public KnockMessageBuilder data(String dataKey, Object dataValue) {
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            this.data$key.add(dataKey);
            this.data$value.add(dataValue);
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        public KnockMessageBuilder data(Map<? extends String, ? extends Object> data) {
            if (data == null) {
                throw new NullPointerException("data cannot be null");
            }
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : data.entrySet()) {
                this.data$key.add($lombokEntry.getKey());
                this.data$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public KnockMessageBuilder clearData() {
            if (this.data$key != null) {
                this.data$key.clear();
                this.data$value.clear();
            }
            return this;
        }

        public KnockMessage build() {
            Map<Object, Object> data;
            switch (this.data$key == null ? 0 : this.data$key.size()) {
                case 0: {
                    data = Collections.emptyMap();
                    break;
                }
                case 1: {
                    data = Collections.singletonMap(this.data$key.get(0), this.data$value.get(0));
                    break;
                }
                default: {
                    data = new LinkedHashMap(this.data$key.size() < 0x40000000 ? 1 + this.data$key.size() + (this.data$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.data$key.size(); ++$i) {
                        data.put(this.data$key.get($i), this.data$value.get($i));
                    }
                    data = Collections.unmodifiableMap(data);
                }
            }
            return new KnockMessage(this.typeName, this.cursor, this.id, this.channelId, this.recipient, this.workflow, this.tenant, this.status, this.readAt, this.seenAt, this.archivedAt, this.insertedAt, this.updatedAt, this.source, data);
        }

        public String toString() {
            return "KnockMessage.KnockMessageBuilder(typeName=" + this.typeName + ", cursor=" + this.cursor + ", id=" + this.id + ", channelId=" + this.channelId + ", recipient=" + this.recipient + ", workflow=" + this.workflow + ", tenant=" + this.tenant + ", status=" + this.status + ", readAt=" + this.readAt + ", seenAt=" + this.seenAt + ", archivedAt=" + this.archivedAt + ", insertedAt=" + this.insertedAt + ", updatedAt=" + this.updatedAt + ", source=" + this.source + ", data$key=" + this.data$key + ", data$value=" + this.data$value + ")";
        }
    }
}

