/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import app.knock.api.model.ObjectRecipientIdentifier;
import app.knock.api.model.ScheduleRepeat;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=UpdateSchedulesRequestBuilder.class)
public final class UpdateSchedulesRequest {
    @JsonProperty(value="__typename")
    private final String typeName;
    private final List<String> scheduleIds;
    private final List<ScheduleRepeat> repeats;
    private final Object actor;
    private final String tenant;
    private final ZonedDateTime scheduledAt;
    @JsonAnySetter
    private final Map<String, Object> data;

    public <T> T data(String key, Class<T> clazz) {
        if (this.data != null && this.data.containsKey(key)) {
            Object o = this.data.get(key);
            return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
        }
        return null;
    }

    UpdateSchedulesRequest(String typeName, List<String> scheduleIds, List<ScheduleRepeat> repeats, Object actor, String tenant, ZonedDateTime scheduledAt, Map<String, Object> data) {
        this.typeName = typeName;
        this.scheduleIds = scheduleIds;
        this.repeats = repeats;
        this.actor = actor;
        this.tenant = tenant;
        this.scheduledAt = scheduledAt;
        this.data = data;
    }

    public static UpdateSchedulesRequestBuilder builder() {
        return new UpdateSchedulesRequestBuilder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public List<String> getScheduleIds() {
        return this.scheduleIds;
    }

    public List<ScheduleRepeat> getRepeats() {
        return this.repeats;
    }

    public Object getActor() {
        return this.actor;
    }

    public String getTenant() {
        return this.tenant;
    }

    public ZonedDateTime getScheduledAt() {
        return this.scheduledAt;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateSchedulesRequest)) {
            return false;
        }
        UpdateSchedulesRequest other = (UpdateSchedulesRequest)o;
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        List<String> this$scheduleIds = this.getScheduleIds();
        List<String> other$scheduleIds = other.getScheduleIds();
        if (this$scheduleIds == null ? other$scheduleIds != null : !((Object)this$scheduleIds).equals(other$scheduleIds)) {
            return false;
        }
        List<ScheduleRepeat> this$repeats = this.getRepeats();
        List<ScheduleRepeat> other$repeats = other.getRepeats();
        if (this$repeats == null ? other$repeats != null : !((Object)this$repeats).equals(other$repeats)) {
            return false;
        }
        Object this$actor = this.getActor();
        Object other$actor = other.getActor();
        if (this$actor == null ? other$actor != null : !this$actor.equals(other$actor)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        ZonedDateTime this$scheduledAt = this.getScheduledAt();
        ZonedDateTime other$scheduledAt = other.getScheduledAt();
        if (this$scheduledAt == null ? other$scheduledAt != null : !((Object)this$scheduledAt).equals(other$scheduledAt)) {
            return false;
        }
        Map<String, Object> this$data = this.getData();
        Map<String, Object> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        List<String> $scheduleIds = this.getScheduleIds();
        result = result * 59 + ($scheduleIds == null ? 43 : ((Object)$scheduleIds).hashCode());
        List<ScheduleRepeat> $repeats = this.getRepeats();
        result = result * 59 + ($repeats == null ? 43 : ((Object)$repeats).hashCode());
        Object $actor = this.getActor();
        result = result * 59 + ($actor == null ? 43 : $actor.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        ZonedDateTime $scheduledAt = this.getScheduledAt();
        result = result * 59 + ($scheduledAt == null ? 43 : ((Object)$scheduledAt).hashCode());
        Map<String, Object> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "UpdateSchedulesRequest(typeName=" + this.getTypeName() + ", scheduleIds=" + this.getScheduleIds() + ", repeats=" + this.getRepeats() + ", actor=" + this.getActor() + ", tenant=" + this.getTenant() + ", scheduledAt=" + this.getScheduledAt() + ", data=" + this.getData() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class UpdateSchedulesRequestBuilder {
        private String typeName;
        private List<String> scheduleIds;
        private List<ScheduleRepeat> repeats;
        private Object actor;
        private String tenant;
        private ZonedDateTime scheduledAt;
        private ArrayList<String> data$key;
        private ArrayList<Object> data$value;
        List<Object> recipients;

        public UpdateSchedulesRequestBuilder addActor(ObjectRecipientIdentifier identifier) {
            this.actor = identifier;
            return this;
        }

        public UpdateSchedulesRequestBuilder addActor(String actor) {
            this.actor = actor;
            return this;
        }

        public UpdateSchedulesRequestBuilder addRepeat(ScheduleRepeat repeat) {
            if (this.repeats == null) {
                this.repeats = new ArrayList<ScheduleRepeat>();
            }
            Collections.addAll(this.repeats, repeat);
            return this;
        }

        UpdateSchedulesRequestBuilder() {
        }

        @JsonProperty(value="__typename")
        public UpdateSchedulesRequestBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public UpdateSchedulesRequestBuilder scheduleIds(List<String> scheduleIds) {
            this.scheduleIds = scheduleIds;
            return this;
        }

        public UpdateSchedulesRequestBuilder repeats(List<ScheduleRepeat> repeats) {
            this.repeats = repeats;
            return this;
        }

        public UpdateSchedulesRequestBuilder actor(Object actor) {
            this.actor = actor;
            return this;
        }

        public UpdateSchedulesRequestBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public UpdateSchedulesRequestBuilder scheduledAt(ZonedDateTime scheduledAt) {
            this.scheduledAt = scheduledAt;
            return this;
        }

        @JsonAnySetter
        public UpdateSchedulesRequestBuilder data(String dataKey, Object dataValue) {
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            this.data$key.add(dataKey);
            this.data$value.add(dataValue);
            return this;
        }

        public UpdateSchedulesRequestBuilder data(Map<? extends String, ? extends Object> data) {
            if (data == null) {
                throw new NullPointerException("data cannot be null");
            }
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : data.entrySet()) {
                this.data$key.add($lombokEntry.getKey());
                this.data$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public UpdateSchedulesRequestBuilder clearData() {
            if (this.data$key != null) {
                this.data$key.clear();
                this.data$value.clear();
            }
            return this;
        }

        public UpdateSchedulesRequest build() {
            Map<String, Object> data;
            switch (this.data$key == null ? 0 : this.data$key.size()) {
                case 0: {
                    data = Collections.emptyMap();
                    break;
                }
                case 1: {
                    data = Collections.singletonMap(this.data$key.get(0), this.data$value.get(0));
                    break;
                }
                default: {
                    data = new LinkedHashMap(this.data$key.size() < 0x40000000 ? 1 + this.data$key.size() + (this.data$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.data$key.size(); ++$i) {
                        data.put(this.data$key.get($i), this.data$value.get($i));
                    }
                    data = Collections.unmodifiableMap(data);
                }
            }
            return new UpdateSchedulesRequest(this.typeName, this.scheduleIds, this.repeats, this.actor, this.tenant, this.scheduledAt, data);
        }

        public String toString() {
            return "UpdateSchedulesRequest.UpdateSchedulesRequestBuilder(typeName=" + this.typeName + ", scheduleIds=" + this.scheduleIds + ", repeats=" + this.repeats + ", actor=" + this.actor + ", tenant=" + this.tenant + ", scheduledAt=" + this.scheduledAt + ", data$key=" + this.data$key + ", data$value=" + this.data$value + ")";
        }
    }
}

