/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import app.knock.api.model.ObjectRecipientIdentifier;
import app.knock.api.model.ScheduleRepeat;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=CreateSchedulesRequestBuilder.class)
public final class CreateSchedulesRequest {
    @JsonProperty(value="__typename")
    private final String typeName;
    private final String workflow;
    private final List<Object> recipients;
    private final List<ScheduleRepeat> repeats;
    private final Object actor;
    private final String tenant;
    private final ZonedDateTime scheduledAt;
    @JsonAnySetter
    private final Map<String, Object> data;

    public <T> T data(String key, Class<T> clazz) {
        if (this.data != null && this.data.containsKey(key)) {
            Object o = this.data.get(key);
            return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
        }
        return null;
    }

    CreateSchedulesRequest(String typeName, String workflow, List<Object> recipients, List<ScheduleRepeat> repeats, Object actor, String tenant, ZonedDateTime scheduledAt, Map<String, Object> data) {
        this.typeName = typeName;
        this.workflow = workflow;
        this.recipients = recipients;
        this.repeats = repeats;
        this.actor = actor;
        this.tenant = tenant;
        this.scheduledAt = scheduledAt;
        this.data = data;
    }

    public static CreateSchedulesRequestBuilder builder() {
        return new CreateSchedulesRequestBuilder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public List<Object> getRecipients() {
        return this.recipients;
    }

    public List<ScheduleRepeat> getRepeats() {
        return this.repeats;
    }

    public Object getActor() {
        return this.actor;
    }

    public String getTenant() {
        return this.tenant;
    }

    public ZonedDateTime getScheduledAt() {
        return this.scheduledAt;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateSchedulesRequest)) {
            return false;
        }
        CreateSchedulesRequest other = (CreateSchedulesRequest)o;
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$workflow = this.getWorkflow();
        String other$workflow = other.getWorkflow();
        if (this$workflow == null ? other$workflow != null : !this$workflow.equals(other$workflow)) {
            return false;
        }
        List<Object> this$recipients = this.getRecipients();
        List<Object> other$recipients = other.getRecipients();
        if (this$recipients == null ? other$recipients != null : !((Object)this$recipients).equals(other$recipients)) {
            return false;
        }
        List<ScheduleRepeat> this$repeats = this.getRepeats();
        List<ScheduleRepeat> other$repeats = other.getRepeats();
        if (this$repeats == null ? other$repeats != null : !((Object)this$repeats).equals(other$repeats)) {
            return false;
        }
        Object this$actor = this.getActor();
        Object other$actor = other.getActor();
        if (this$actor == null ? other$actor != null : !this$actor.equals(other$actor)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        ZonedDateTime this$scheduledAt = this.getScheduledAt();
        ZonedDateTime other$scheduledAt = other.getScheduledAt();
        if (this$scheduledAt == null ? other$scheduledAt != null : !((Object)this$scheduledAt).equals(other$scheduledAt)) {
            return false;
        }
        Map<String, Object> this$data = this.getData();
        Map<String, Object> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $workflow = this.getWorkflow();
        result = result * 59 + ($workflow == null ? 43 : $workflow.hashCode());
        List<Object> $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : ((Object)$recipients).hashCode());
        List<ScheduleRepeat> $repeats = this.getRepeats();
        result = result * 59 + ($repeats == null ? 43 : ((Object)$repeats).hashCode());
        Object $actor = this.getActor();
        result = result * 59 + ($actor == null ? 43 : $actor.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        ZonedDateTime $scheduledAt = this.getScheduledAt();
        result = result * 59 + ($scheduledAt == null ? 43 : ((Object)$scheduledAt).hashCode());
        Map<String, Object> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "CreateSchedulesRequest(typeName=" + this.getTypeName() + ", workflow=" + this.getWorkflow() + ", recipients=" + this.getRecipients() + ", repeats=" + this.getRepeats() + ", actor=" + this.getActor() + ", tenant=" + this.getTenant() + ", scheduledAt=" + this.getScheduledAt() + ", data=" + this.getData() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class CreateSchedulesRequestBuilder {
        private String typeName;
        private String workflow;
        private List<ScheduleRepeat> repeats;
        private Object actor;
        private String tenant;
        private ZonedDateTime scheduledAt;
        private ArrayList<String> data$key;
        private ArrayList<Object> data$value;
        List<Object> recipients;

        public CreateSchedulesRequestBuilder addActor(ObjectRecipientIdentifier identifier) {
            this.actor = identifier;
            return this;
        }

        public CreateSchedulesRequestBuilder addActor(String actor) {
            this.actor = actor;
            return this;
        }

        public CreateSchedulesRequestBuilder addActor(Map<String, Object> actor) {
            this.actor = actor;
            return this;
        }

        public CreateSchedulesRequestBuilder addRecipient(String ... userIds) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<Object>();
            }
            Collections.addAll(this.recipients, userIds);
            return this;
        }

        public CreateSchedulesRequestBuilder addRecipient(Map<String, Object> recipient) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<Object>();
            }
            Collections.addAll(this.recipients, recipient);
            return this;
        }

        public CreateSchedulesRequestBuilder addRecipient(ObjectRecipientIdentifier identifier) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<Object>();
            }
            Collections.addAll(this.recipients, identifier);
            return this;
        }

        public CreateSchedulesRequestBuilder addRepeat(ScheduleRepeat repeat) {
            if (this.repeats == null) {
                this.repeats = new ArrayList<ScheduleRepeat>();
            }
            Collections.addAll(this.repeats, repeat);
            return this;
        }

        CreateSchedulesRequestBuilder() {
        }

        @JsonProperty(value="__typename")
        public CreateSchedulesRequestBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public CreateSchedulesRequestBuilder workflow(String workflow) {
            this.workflow = workflow;
            return this;
        }

        public CreateSchedulesRequestBuilder recipients(List<Object> recipients) {
            this.recipients = recipients;
            return this;
        }

        public CreateSchedulesRequestBuilder repeats(List<ScheduleRepeat> repeats) {
            this.repeats = repeats;
            return this;
        }

        public CreateSchedulesRequestBuilder actor(Object actor) {
            this.actor = actor;
            return this;
        }

        public CreateSchedulesRequestBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public CreateSchedulesRequestBuilder scheduledAt(ZonedDateTime scheduledAt) {
            this.scheduledAt = scheduledAt;
            return this;
        }

        @JsonAnySetter
        public CreateSchedulesRequestBuilder data(String dataKey, Object dataValue) {
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            this.data$key.add(dataKey);
            this.data$value.add(dataValue);
            return this;
        }

        public CreateSchedulesRequestBuilder data(Map<? extends String, ? extends Object> data) {
            if (data == null) {
                throw new NullPointerException("data cannot be null");
            }
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : data.entrySet()) {
                this.data$key.add($lombokEntry.getKey());
                this.data$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateSchedulesRequestBuilder clearData() {
            if (this.data$key != null) {
                this.data$key.clear();
                this.data$value.clear();
            }
            return this;
        }

        public CreateSchedulesRequest build() {
            Map<String, Object> data;
            switch (this.data$key == null ? 0 : this.data$key.size()) {
                case 0: {
                    data = Collections.emptyMap();
                    break;
                }
                case 1: {
                    data = Collections.singletonMap(this.data$key.get(0), this.data$value.get(0));
                    break;
                }
                default: {
                    data = new LinkedHashMap(this.data$key.size() < 0x40000000 ? 1 + this.data$key.size() + (this.data$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.data$key.size(); ++$i) {
                        data.put(this.data$key.get($i), this.data$value.get($i));
                    }
                    data = Collections.unmodifiableMap(data);
                }
            }
            return new CreateSchedulesRequest(this.typeName, this.workflow, this.recipients, this.repeats, this.actor, this.tenant, this.scheduledAt, data);
        }

        public String toString() {
            return "CreateSchedulesRequest.CreateSchedulesRequestBuilder(typeName=" + this.typeName + ", workflow=" + this.workflow + ", recipients=" + this.recipients + ", repeats=" + this.repeats + ", actor=" + this.actor + ", tenant=" + this.tenant + ", scheduledAt=" + this.scheduledAt + ", data$key=" + this.data$key + ", data$value=" + this.data$value + ")";
        }
    }
}

