/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=KnockMessageContentBuilder.class)
public final class KnockMessageContent {
    private final String id;
    private final ZonedDateTime insertedAt;
    @JsonAnySetter
    private final Map<String, Object> data;

    public <T> T data(String key, Class<T> clazz) {
        if (this.data != null && this.data.containsKey(key)) {
            Object o = this.data.get(key);
            return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
        }
        return null;
    }

    KnockMessageContent(String id, ZonedDateTime insertedAt, Map<String, Object> data) {
        this.id = id;
        this.insertedAt = insertedAt;
        this.data = data;
    }

    public static KnockMessageContentBuilder builder() {
        return new KnockMessageContentBuilder();
    }

    public String getId() {
        return this.id;
    }

    public ZonedDateTime getInsertedAt() {
        return this.insertedAt;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KnockMessageContent)) {
            return false;
        }
        KnockMessageContent other = (KnockMessageContent)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ZonedDateTime this$insertedAt = this.getInsertedAt();
        ZonedDateTime other$insertedAt = other.getInsertedAt();
        if (this$insertedAt == null ? other$insertedAt != null : !((Object)this$insertedAt).equals(other$insertedAt)) {
            return false;
        }
        Map<String, Object> this$data = this.getData();
        Map<String, Object> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ZonedDateTime $insertedAt = this.getInsertedAt();
        result = result * 59 + ($insertedAt == null ? 43 : ((Object)$insertedAt).hashCode());
        Map<String, Object> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "KnockMessageContent(id=" + this.getId() + ", insertedAt=" + this.getInsertedAt() + ", data=" + this.getData() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class KnockMessageContentBuilder {
        private String id;
        private ZonedDateTime insertedAt;
        private ArrayList<String> data$key;
        private ArrayList<Object> data$value;

        KnockMessageContentBuilder() {
        }

        public KnockMessageContentBuilder id(String id) {
            this.id = id;
            return this;
        }

        public KnockMessageContentBuilder insertedAt(ZonedDateTime insertedAt) {
            this.insertedAt = insertedAt;
            return this;
        }

        @JsonAnySetter
        public KnockMessageContentBuilder data(String dataKey, Object dataValue) {
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            this.data$key.add(dataKey);
            this.data$value.add(dataValue);
            return this;
        }

        public KnockMessageContentBuilder data(Map<? extends String, ? extends Object> data) {
            if (data == null) {
                throw new NullPointerException("data cannot be null");
            }
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : data.entrySet()) {
                this.data$key.add($lombokEntry.getKey());
                this.data$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public KnockMessageContentBuilder clearData() {
            if (this.data$key != null) {
                this.data$key.clear();
                this.data$value.clear();
            }
            return this;
        }

        public KnockMessageContent build() {
            Map<String, Object> data;
            switch (this.data$key == null ? 0 : this.data$key.size()) {
                case 0: {
                    data = Collections.emptyMap();
                    break;
                }
                case 1: {
                    data = Collections.singletonMap(this.data$key.get(0), this.data$value.get(0));
                    break;
                }
                default: {
                    data = new LinkedHashMap(this.data$key.size() < 0x40000000 ? 1 + this.data$key.size() + (this.data$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.data$key.size(); ++$i) {
                        data.put(this.data$key.get($i), this.data$value.get($i));
                    }
                    data = Collections.unmodifiableMap(data);
                }
            }
            return new KnockMessageContent(this.id, this.insertedAt, data);
        }

        public String toString() {
            return "KnockMessageContent.KnockMessageContentBuilder(id=" + this.id + ", insertedAt=" + this.insertedAt + ", data$key=" + this.data$key + ", data$value=" + this.data$value + ")";
        }
    }
}

