/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import app.knock.api.model.util.PropertyBuilderHelper;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PreferenceSetRequest {
    private final String id;
    @JsonAnySetter
    private final Map<String, Object> channelTypes;
    @JsonAnySetter
    private final Map<String, Object> workflows;
    @JsonAnySetter
    private final Map<String, Object> categories;

    public <T> T channelType(String key, Class<T> clazz) {
        return PropertyBuilderHelper.setProperty(this.channelTypes, key, clazz);
    }

    public <T> T workflow(String key, Class<T> clazz) {
        return PropertyBuilderHelper.setProperty(this.workflows, key, clazz);
    }

    public <T> T category(String key, Class<T> clazz) {
        return PropertyBuilderHelper.setProperty(this.categories, key, clazz);
    }

    PreferenceSetRequest(String id, Map<String, Object> channelTypes, Map<String, Object> workflows, Map<String, Object> categories) {
        this.id = id;
        this.channelTypes = channelTypes;
        this.workflows = workflows;
        this.categories = categories;
    }

    public static PreferenceSetRequestBuilder builder() {
        return new PreferenceSetRequestBuilder();
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getChannelTypes() {
        return this.channelTypes;
    }

    public Map<String, Object> getWorkflows() {
        return this.workflows;
    }

    public Map<String, Object> getCategories() {
        return this.categories;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreferenceSetRequest)) {
            return false;
        }
        PreferenceSetRequest other = (PreferenceSetRequest)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, Object> this$channelTypes = this.getChannelTypes();
        Map<String, Object> other$channelTypes = other.getChannelTypes();
        if (this$channelTypes == null ? other$channelTypes != null : !((Object)this$channelTypes).equals(other$channelTypes)) {
            return false;
        }
        Map<String, Object> this$workflows = this.getWorkflows();
        Map<String, Object> other$workflows = other.getWorkflows();
        if (this$workflows == null ? other$workflows != null : !((Object)this$workflows).equals(other$workflows)) {
            return false;
        }
        Map<String, Object> this$categories = this.getCategories();
        Map<String, Object> other$categories = other.getCategories();
        return !(this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, Object> $channelTypes = this.getChannelTypes();
        result = result * 59 + ($channelTypes == null ? 43 : ((Object)$channelTypes).hashCode());
        Map<String, Object> $workflows = this.getWorkflows();
        result = result * 59 + ($workflows == null ? 43 : ((Object)$workflows).hashCode());
        Map<String, Object> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        return result;
    }

    public String toString() {
        return "PreferenceSetRequest(id=" + this.getId() + ", channelTypes=" + this.getChannelTypes() + ", workflows=" + this.getWorkflows() + ", categories=" + this.getCategories() + ")";
    }

    public static class PreferenceSetRequestBuilder {
        private String id;
        private ArrayList<String> channelTypes$key;
        private ArrayList<Object> channelTypes$value;
        private ArrayList<String> workflows$key;
        private ArrayList<Object> workflows$value;
        private ArrayList<String> categories$key;
        private ArrayList<Object> categories$value;

        PreferenceSetRequestBuilder() {
        }

        public PreferenceSetRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonAnySetter
        public PreferenceSetRequestBuilder channelType(String channelTypeKey, Object channelTypeValue) {
            if (this.channelTypes$key == null) {
                this.channelTypes$key = new ArrayList();
                this.channelTypes$value = new ArrayList();
            }
            this.channelTypes$key.add(channelTypeKey);
            this.channelTypes$value.add(channelTypeValue);
            return this;
        }

        public PreferenceSetRequestBuilder channelTypes(Map<? extends String, ? extends Object> channelTypes) {
            if (channelTypes == null) {
                throw new NullPointerException("channelTypes cannot be null");
            }
            if (this.channelTypes$key == null) {
                this.channelTypes$key = new ArrayList();
                this.channelTypes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : channelTypes.entrySet()) {
                this.channelTypes$key.add($lombokEntry.getKey());
                this.channelTypes$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PreferenceSetRequestBuilder clearChannelTypes() {
            if (this.channelTypes$key != null) {
                this.channelTypes$key.clear();
                this.channelTypes$value.clear();
            }
            return this;
        }

        @JsonAnySetter
        public PreferenceSetRequestBuilder workflow(String workflowKey, Object workflowValue) {
            if (this.workflows$key == null) {
                this.workflows$key = new ArrayList();
                this.workflows$value = new ArrayList();
            }
            this.workflows$key.add(workflowKey);
            this.workflows$value.add(workflowValue);
            return this;
        }

        public PreferenceSetRequestBuilder workflows(Map<? extends String, ? extends Object> workflows) {
            if (workflows == null) {
                throw new NullPointerException("workflows cannot be null");
            }
            if (this.workflows$key == null) {
                this.workflows$key = new ArrayList();
                this.workflows$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : workflows.entrySet()) {
                this.workflows$key.add($lombokEntry.getKey());
                this.workflows$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PreferenceSetRequestBuilder clearWorkflows() {
            if (this.workflows$key != null) {
                this.workflows$key.clear();
                this.workflows$value.clear();
            }
            return this;
        }

        @JsonAnySetter
        public PreferenceSetRequestBuilder category(String categoryKey, Object categoryValue) {
            if (this.categories$key == null) {
                this.categories$key = new ArrayList();
                this.categories$value = new ArrayList();
            }
            this.categories$key.add(categoryKey);
            this.categories$value.add(categoryValue);
            return this;
        }

        public PreferenceSetRequestBuilder categories(Map<? extends String, ? extends Object> categories) {
            if (categories == null) {
                throw new NullPointerException("categories cannot be null");
            }
            if (this.categories$key == null) {
                this.categories$key = new ArrayList();
                this.categories$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : categories.entrySet()) {
                this.categories$key.add($lombokEntry.getKey());
                this.categories$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PreferenceSetRequestBuilder clearCategories() {
            if (this.categories$key != null) {
                this.categories$key.clear();
                this.categories$value.clear();
            }
            return this;
        }

        public PreferenceSetRequest build() {
            Map<String, Object> categories;
            Map<Object, Object> workflows;
            Map<Object, Object> channelTypes;
            switch (this.channelTypes$key == null ? 0 : this.channelTypes$key.size()) {
                case 0: {
                    channelTypes = Collections.emptyMap();
                    break;
                }
                case 1: {
                    channelTypes = Collections.singletonMap(this.channelTypes$key.get(0), this.channelTypes$value.get(0));
                    break;
                }
                default: {
                    channelTypes = new LinkedHashMap(this.channelTypes$key.size() < 0x40000000 ? 1 + this.channelTypes$key.size() + (this.channelTypes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.channelTypes$key.size(); ++$i) {
                        channelTypes.put(this.channelTypes$key.get($i), this.channelTypes$value.get($i));
                    }
                    channelTypes = Collections.unmodifiableMap(channelTypes);
                }
            }
            switch (this.workflows$key == null ? 0 : this.workflows$key.size()) {
                case 0: {
                    workflows = Collections.emptyMap();
                    break;
                }
                case 1: {
                    workflows = Collections.singletonMap(this.workflows$key.get(0), this.workflows$value.get(0));
                    break;
                }
                default: {
                    workflows = new LinkedHashMap(this.workflows$key.size() < 0x40000000 ? 1 + this.workflows$key.size() + (this.workflows$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.workflows$key.size(); ++$i) {
                        workflows.put(this.workflows$key.get($i), this.workflows$value.get($i));
                    }
                    workflows = Collections.unmodifiableMap(workflows);
                }
            }
            switch (this.categories$key == null ? 0 : this.categories$key.size()) {
                case 0: {
                    categories = Collections.emptyMap();
                    break;
                }
                case 1: {
                    categories = Collections.singletonMap(this.categories$key.get(0), this.categories$value.get(0));
                    break;
                }
                default: {
                    categories = new LinkedHashMap(this.categories$key.size() < 0x40000000 ? 1 + this.categories$key.size() + (this.categories$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.categories$key.size(); ++$i) {
                        categories.put(this.categories$key.get($i), this.categories$value.get($i));
                    }
                    categories = Collections.unmodifiableMap(categories);
                }
            }
            return new PreferenceSetRequest(this.id, channelTypes, workflows, categories);
        }

        public String toString() {
            return "PreferenceSetRequest.PreferenceSetRequestBuilder(id=" + this.id + ", channelTypes$key=" + this.channelTypes$key + ", channelTypes$value=" + this.channelTypes$value + ", workflows$key=" + this.workflows$key + ", workflows$value=" + this.workflows$value + ", categories$key=" + this.categories$key + ", categories$value=" + this.categories$value + ")";
        }
    }
}

