/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.resources;

import app.knock.api.http.KnockHttp;
import app.knock.api.model.CursorResult;
import app.knock.api.model.Tenant;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

public final class TenantsResource {
    private static final String BASE_RESOURCE_PATH = "v1/tenants";
    private final KnockHttp knockHttp;

    HttpUrl buildListResource(QueryParams queryParams) {
        HttpUrl.Builder urlBuilder = this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, new String[0]);
        queryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    HttpUrl tenantUrl(String tenantId) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, tenantId).build();
    }

    public CursorResult<Tenant> list(QueryParams queryParams) {
        HttpUrl url = this.buildListResource(queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<Tenant>>(){});
    }

    public Tenant get(String tenantId) {
        HttpUrl url = this.tenantUrl(tenantId);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<Tenant>(){});
    }

    public Tenant set(String tenantId, Map<String, Object> tenantData) {
        HttpUrl url = this.tenantUrl(tenantId);
        RequestBody body = this.knockHttp.objectToJsonRequestBody(tenantData);
        Request request = this.knockHttp.baseJsonRequest(url).put(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<Tenant>(){});
    }

    public void delete(String tenantId) {
        HttpUrl url = this.tenantUrl(tenantId);
        Request request = this.knockHttp.baseJsonRequest(url).delete().build();
        this.knockHttp.execute(request);
    }

    public TenantsResource(KnockHttp knockHttp) {
        this.knockHttp = knockHttp;
    }

    public KnockHttp getKnockHttp() {
        return this.knockHttp;
    }

    public String toString() {
        return "TenantsResource(knockHttp=" + this.getKnockHttp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantsResource)) {
            return false;
        }
        TenantsResource other = (TenantsResource)o;
        KnockHttp this$knockHttp = this.getKnockHttp();
        KnockHttp other$knockHttp = other.getKnockHttp();
        return !(this$knockHttp == null ? other$knockHttp != null : !this$knockHttp.equals(other$knockHttp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KnockHttp $knockHttp = this.getKnockHttp();
        result = result * 59 + ($knockHttp == null ? 43 : $knockHttp.hashCode());
        return result;
    }

    public static final class QueryParams {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public void pageSize(Integer pageSize) {
            this.params.put("page_size", pageSize);
        }

        public void after(String after) {
            this.params.put("after", after);
        }

        public void before(String before) {
            this.params.put("before", before);
        }

        public void tenantId(String tenantId) {
            this.params.put("tenantId", tenantId);
        }

        public void name(String name) {
            this.params.put("name", name);
        }

        public void addQueryParams(HttpUrl.Builder uriBuilder) {
            this.params.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> uriBuilder.addQueryParameter((String)entry.getKey(), entry.getValue().toString()));
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public String toString() {
            return "TenantsResource.QueryParams(params=" + this.getParams() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryParams)) {
                return false;
            }
            QueryParams other = (QueryParams)o;
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }
    }
}

