/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import app.knock.api.model.util.PropertyBuilderHelper;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=UserIdentityBuilder.class)
public final class UserIdentity {
    @JsonProperty(value="__typename")
    private final String typeName;
    private final String id;
    private final String name;
    private final String email;
    private final ZonedDateTime createdAt;
    private final ZonedDateTime updatedAt;
    private final String avatar;
    private final String phoneNumber;
    @JsonAnySetter
    private final Map<String, Object> properties;

    public <T> T property(String key, Class<T> clazz) {
        return PropertyBuilderHelper.setProperty(this.properties, key, clazz);
    }

    UserIdentity(String typeName, String id, String name, String email, ZonedDateTime createdAt, ZonedDateTime updatedAt, String avatar, String phoneNumber, Map<String, Object> properties) {
        this.typeName = typeName;
        this.id = id;
        this.name = name;
        this.email = email;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.avatar = avatar;
        this.phoneNumber = phoneNumber;
        this.properties = properties;
    }

    public static UserIdentityBuilder builder() {
        return new UserIdentityBuilder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserIdentity)) {
            return false;
        }
        UserIdentity other = (UserIdentity)o;
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$avatar = this.getAvatar();
        String other$avatar = other.getAvatar();
        if (this$avatar == null ? other$avatar != null : !this$avatar.equals(other$avatar)) {
            return false;
        }
        String this$phoneNumber = this.getPhoneNumber();
        String other$phoneNumber = other.getPhoneNumber();
        if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $avatar = this.getAvatar();
        result = result * 59 + ($avatar == null ? 43 : $avatar.hashCode());
        String $phoneNumber = this.getPhoneNumber();
        result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "UserIdentity(typeName=" + this.getTypeName() + ", id=" + this.getId() + ", name=" + this.getName() + ", email=" + this.getEmail() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", avatar=" + this.getAvatar() + ", phoneNumber=" + this.getPhoneNumber() + ", properties=" + this.getProperties() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class UserIdentityBuilder {
        private String typeName;
        private String id;
        private String name;
        private String email;
        private ZonedDateTime createdAt;
        private ZonedDateTime updatedAt;
        private String avatar;
        private String phoneNumber;
        private ArrayList<String> properties$key;
        private ArrayList<Object> properties$value;

        UserIdentityBuilder() {
        }

        @JsonProperty(value="__typename")
        public UserIdentityBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public UserIdentityBuilder id(String id) {
            this.id = id;
            return this;
        }

        public UserIdentityBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UserIdentityBuilder email(String email) {
            this.email = email;
            return this;
        }

        public UserIdentityBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public UserIdentityBuilder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public UserIdentityBuilder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public UserIdentityBuilder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @JsonAnySetter
        public UserIdentityBuilder property(String propertyKey, Object propertyValue) {
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            this.properties$key.add(propertyKey);
            this.properties$value.add(propertyValue);
            return this;
        }

        public UserIdentityBuilder properties(Map<? extends String, ? extends Object> properties) {
            if (properties == null) {
                throw new NullPointerException("properties cannot be null");
            }
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : properties.entrySet()) {
                this.properties$key.add($lombokEntry.getKey());
                this.properties$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public UserIdentityBuilder clearProperties() {
            if (this.properties$key != null) {
                this.properties$key.clear();
                this.properties$value.clear();
            }
            return this;
        }

        public UserIdentity build() {
            Map<String, Object> properties;
            switch (this.properties$key == null ? 0 : this.properties$key.size()) {
                case 0: {
                    properties = Collections.emptyMap();
                    break;
                }
                case 1: {
                    properties = Collections.singletonMap(this.properties$key.get(0), this.properties$value.get(0));
                    break;
                }
                default: {
                    properties = new LinkedHashMap(this.properties$key.size() < 0x40000000 ? 1 + this.properties$key.size() + (this.properties$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.properties$key.size(); ++$i) {
                        properties.put(this.properties$key.get($i), this.properties$value.get($i));
                    }
                    properties = Collections.unmodifiableMap(properties);
                }
            }
            return new UserIdentity(this.typeName, this.id, this.name, this.email, this.createdAt, this.updatedAt, this.avatar, this.phoneNumber, properties);
        }

        public String toString() {
            return "UserIdentity.UserIdentityBuilder(typeName=" + this.typeName + ", id=" + this.id + ", name=" + this.name + ", email=" + this.email + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", avatar=" + this.avatar + ", phoneNumber=" + this.phoneNumber + ", properties$key=" + this.properties$key + ", properties$value=" + this.properties$value + ")";
        }
    }
}

