/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.resources;

import app.knock.api.http.KnockHttp;
import app.knock.api.model.CreateSchedulesRequest;
import app.knock.api.model.CursorResult;
import app.knock.api.model.DeleteSchedulesRequest;
import app.knock.api.model.MethodOptions;
import app.knock.api.model.Schedule;
import app.knock.api.model.UpdateSchedulesRequest;
import app.knock.api.model.WorkflowCancelRequest;
import app.knock.api.model.WorkflowTriggerRequest;
import app.knock.api.model.WorkflowTriggerResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

public final class WorkflowsResource {
    private static final String BASE_RESOURCE_PATH = "v1/workflows";
    private static final String BASE_SCHEDULES_RESOURCE_PATH = "v1/schedules";
    private final KnockHttp knockHttp;

    HttpUrl workflowUrl(String key, String action) {
        return this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, key, action).build();
    }

    HttpUrl buildListResource(SchedulesQueryParams queryParams) {
        HttpUrl.Builder urlBuilder = this.knockHttp.baseUrlBuilder(BASE_SCHEDULES_RESOURCE_PATH, new String[0]);
        queryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    public WorkflowTriggerResponse trigger(WorkflowTriggerRequest workflowTrigger) {
        return this.trigger(workflowTrigger, null);
    }

    public WorkflowTriggerResponse trigger(WorkflowTriggerRequest workflowTrigger, MethodOptions methodOptions) {
        HttpUrl url = this.workflowUrl(workflowTrigger.getKey(), "trigger");
        RequestBody body = this.knockHttp.objectToJsonRequestBody(workflowTrigger);
        Request.Builder requestBuilder = this.knockHttp.baseJsonRequest(url).post(body);
        if (methodOptions != null && methodOptions.getIdempotencyKey() != null) {
            requestBuilder.addHeader("Idempotency-Key", methodOptions.getIdempotencyKey());
        }
        Request request = requestBuilder.build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<WorkflowTriggerResponse>(){});
    }

    public void cancel(WorkflowCancelRequest workflowCancelRequest) {
        HttpUrl url = this.workflowUrl(workflowCancelRequest.getKey(), "cancel");
        RequestBody body = this.knockHttp.objectToJsonRequestBody(workflowCancelRequest);
        Request request = this.knockHttp.baseJsonRequest(url).post(body).build();
        this.knockHttp.execute(request);
    }

    public List<Schedule> createSchedules(CreateSchedulesRequest createSchedulesRequest) {
        HttpUrl url = this.knockHttp.baseUrlBuilder(BASE_SCHEDULES_RESOURCE_PATH, new String[0]).build();
        RequestBody body = this.knockHttp.objectToJsonRequestBody(createSchedulesRequest);
        Request.Builder requestBuilder = this.knockHttp.baseJsonRequest(url).post(body);
        Request request = requestBuilder.build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<List<Schedule>>(){});
    }

    public List<Schedule> updateSchedules(UpdateSchedulesRequest updateSchedulesRequest) {
        HttpUrl url = this.knockHttp.baseUrlBuilder(BASE_SCHEDULES_RESOURCE_PATH, new String[0]).build();
        RequestBody body = this.knockHttp.objectToJsonRequestBody(updateSchedulesRequest);
        Request.Builder requestBuilder = this.knockHttp.baseJsonRequest(url).put(body);
        Request request = requestBuilder.build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<List<Schedule>>(){});
    }

    public List<Schedule> deleteSchedules(DeleteSchedulesRequest deleteSchedulesRequest) {
        HttpUrl url = this.knockHttp.baseUrlBuilder(BASE_SCHEDULES_RESOURCE_PATH, new String[0]).build();
        RequestBody body = this.knockHttp.objectToJsonRequestBody(deleteSchedulesRequest);
        Request.Builder requestBuilder = this.knockHttp.baseJsonRequest(url).delete(body);
        Request request = requestBuilder.build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<List<Schedule>>(){});
    }

    public CursorResult<Schedule> listSchedules(String workflowKey, SchedulesQueryParams queryParams) {
        queryParams.workflow(workflowKey);
        HttpUrl url = this.buildListResource(queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<Schedule>>(){});
    }

    public WorkflowsResource(KnockHttp knockHttp) {
        this.knockHttp = knockHttp;
    }

    public KnockHttp getKnockHttp() {
        return this.knockHttp;
    }

    public String toString() {
        return "WorkflowsResource(knockHttp=" + this.getKnockHttp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowsResource)) {
            return false;
        }
        WorkflowsResource other = (WorkflowsResource)o;
        KnockHttp this$knockHttp = this.getKnockHttp();
        KnockHttp other$knockHttp = other.getKnockHttp();
        return !(this$knockHttp == null ? other$knockHttp != null : !this$knockHttp.equals(other$knockHttp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KnockHttp $knockHttp = this.getKnockHttp();
        result = result * 59 + ($knockHttp == null ? 43 : $knockHttp.hashCode());
        return result;
    }

    public static final class SchedulesQueryParams {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public void pageSize(Integer pageSize) {
            this.params.put("page_size", pageSize);
        }

        public void after(String after) {
            this.params.put("after", after);
        }

        public void before(String before) {
            this.params.put("before", before);
        }

        public void tenant(String tenant) {
            this.params.put("tenant", tenant);
        }

        public void workflow(String workflowKey) {
            this.params.put("workflow", workflowKey);
        }

        public void recipients(String ... userIds) {
            this.params.put("recipients", userIds);
        }

        public void recipients(List<Map<String, Object>> recipients) {
            this.params.put("recipients", recipients);
        }

        public void addQueryParams(HttpUrl.Builder uriBuilder) {
            this.params.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> uriBuilder.addQueryParameter((String)entry.getKey(), entry.getValue().toString()));
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public String toString() {
            return "WorkflowsResource.SchedulesQueryParams(params=" + this.getParams() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchedulesQueryParams)) {
                return false;
            }
            SchedulesQueryParams other = (SchedulesQueryParams)o;
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }
    }
}

