/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.http;

import app.knock.api.exception.KnockClientResourceException;
import app.knock.api.model.KnockErrorResponse;
import app.knock.api.serialize.Json;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class KnockHttp {
    private final OkHttpClient client;
    private final HttpUrl httpUrl;

    public KnockHttp(OkHttpClient client, String baseUrl) {
        this.client = client;
        this.httpUrl = HttpUrl.parse((String)baseUrl);
    }

    public HttpUrl.Builder baseUrlBuilder(String baseUrl, String ... pathSegments) {
        HttpUrl.Builder urlBuilder = this.httpUrl.newBuilder();
        urlBuilder.addPathSegments(baseUrl);
        for (String pathSegment : pathSegments) {
            urlBuilder.addEncodedPathSegment(pathSegment);
        }
        return urlBuilder;
    }

    public Request.Builder baseJsonRequest(HttpUrl httpUrl) {
        return new Request.Builder().url(httpUrl).addHeader("Content-Type", "application/json");
    }

    public RequestBody objectToJsonRequestBody(Object object) {
        MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
        return RequestBody.create((byte[])Json.writeBytes(object), (MediaType)json);
    }

    public void execute(Request request) {
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                KnockErrorResponse errorResponse = Json.readBytes(response.body().bytes(), KnockErrorResponse.class);
                throw new KnockClientResourceException(errorResponse);
            }
        }
        catch (IOException e) {
            throw new KnockClientResourceException("an error occurred while calling a knock endpoint", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeWithResponseType(Request request, TypeReference<T> typeRef) {
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                KnockErrorResponse errorResponse = Json.readBytes(response.body().bytes(), KnockErrorResponse.class);
                throw new KnockClientResourceException(errorResponse);
            }
            if (response.body() == null) throw new KnockClientResourceException("empty response");
            T t = Json.readBytes(response.body().bytes(), typeRef);
            return t;
        }
        catch (IOException e) {
            throw new KnockClientResourceException("an error occurred while calling a knock endpoint", e);
        }
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public HttpUrl getHttpUrl() {
        return this.httpUrl;
    }
}

