/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=DeleteSubscriptionsRequestBuilder.class)
public final class DeleteSubscriptionsRequest {
    @JsonProperty(value="__typename")
    private final String typeName;
    private final List<Object> recipients;

    DeleteSubscriptionsRequest(String typeName, List<Object> recipients) {
        this.typeName = typeName;
        this.recipients = recipients;
    }

    public static DeleteSubscriptionsRequestBuilder builder() {
        return new DeleteSubscriptionsRequestBuilder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public List<Object> getRecipients() {
        return this.recipients;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteSubscriptionsRequest)) {
            return false;
        }
        DeleteSubscriptionsRequest other = (DeleteSubscriptionsRequest)o;
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        List<Object> this$recipients = this.getRecipients();
        List<Object> other$recipients = other.getRecipients();
        return !(this$recipients == null ? other$recipients != null : !((Object)this$recipients).equals(other$recipients));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        List<Object> $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : ((Object)$recipients).hashCode());
        return result;
    }

    public String toString() {
        return "DeleteSubscriptionsRequest(typeName=" + this.getTypeName() + ", recipients=" + this.getRecipients() + ")";
    }

    public static class ObjectRecipientIdentifier {
        String id;
        String collection;

        ObjectRecipientIdentifier(String id, String collection) {
            this.id = id;
            this.collection = collection;
        }

        public static ObjectRecipientIdentifierBuilder builder() {
            return new ObjectRecipientIdentifierBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getCollection() {
            return this.collection;
        }

        public static class ObjectRecipientIdentifierBuilder {
            private String id;
            private String collection;

            ObjectRecipientIdentifierBuilder() {
            }

            public ObjectRecipientIdentifierBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ObjectRecipientIdentifierBuilder collection(String collection) {
                this.collection = collection;
                return this;
            }

            public ObjectRecipientIdentifier build() {
                return new ObjectRecipientIdentifier(this.id, this.collection);
            }

            public String toString() {
                return "DeleteSubscriptionsRequest.ObjectRecipientIdentifier.ObjectRecipientIdentifierBuilder(id=" + this.id + ", collection=" + this.collection + ")";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class DeleteSubscriptionsRequestBuilder {
        private String typeName;
        List<Object> recipients;

        public DeleteSubscriptionsRequestBuilder addRecipient(String ... userIds) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<Object>();
            }
            Collections.addAll(this.recipients, userIds);
            return this;
        }

        public DeleteSubscriptionsRequestBuilder addRecipient(Map<String, Object> recipient) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<Object>();
            }
            Collections.addAll(this.recipients, recipient);
            return this;
        }

        public DeleteSubscriptionsRequestBuilder addRecipient(ObjectRecipientIdentifier identifier) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<Object>();
            }
            Collections.addAll(this.recipients, identifier);
            return this;
        }

        DeleteSubscriptionsRequestBuilder() {
        }

        @JsonProperty(value="__typename")
        public DeleteSubscriptionsRequestBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public DeleteSubscriptionsRequestBuilder recipients(List<Object> recipients) {
            this.recipients = recipients;
            return this;
        }

        public DeleteSubscriptionsRequest build() {
            return new DeleteSubscriptionsRequest(this.typeName, this.recipients);
        }

        public String toString() {
            return "DeleteSubscriptionsRequest.DeleteSubscriptionsRequestBuilder(typeName=" + this.typeName + ", recipients=" + this.recipients + ")";
        }
    }
}

