// File generated from our OpenAPI spec by Stainless.

package app.knock.api.models.messages

import app.knock.api.core.Enum
import app.knock.api.core.ExcludeMissing
import app.knock.api.core.JsonField
import app.knock.api.core.JsonMissing
import app.knock.api.core.JsonValue
import app.knock.api.core.checkKnown
import app.knock.api.core.checkRequired
import app.knock.api.core.toImmutable
import app.knock.api.errors.KnockInvalidDataException
import app.knock.api.models.recipients.RecipientReference
import com.fasterxml.jackson.annotation.JsonAnyGetter
import com.fasterxml.jackson.annotation.JsonAnySetter
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonProperty
import java.time.OffsetDateTime
import java.util.Collections
import java.util.Objects
import java.util.Optional
import kotlin.jvm.optionals.getOrNull

/** Represents a single message that was generated by a workflow for a given channel. */
class Message
private constructor(
    private val id: JsonField<String>,
    private val _typename: JsonField<String>,
    private val actors: JsonField<List<RecipientReference>>,
    private val archivedAt: JsonField<OffsetDateTime>,
    private val channelId: JsonField<String>,
    private val clickedAt: JsonField<OffsetDateTime>,
    private val data: JsonField<Data>,
    private val engagementStatuses: JsonField<List<EngagementStatus>>,
    private val insertedAt: JsonField<OffsetDateTime>,
    private val interactedAt: JsonField<OffsetDateTime>,
    private val linkClickedAt: JsonField<OffsetDateTime>,
    private val metadata: JsonField<Metadata>,
    private val readAt: JsonField<OffsetDateTime>,
    private val recipient: JsonField<RecipientReference>,
    private val scheduledAt: JsonField<OffsetDateTime>,
    private val seenAt: JsonField<OffsetDateTime>,
    private val source: JsonField<Source>,
    private val status: JsonField<Status>,
    private val tenant: JsonField<String>,
    private val updatedAt: JsonField<OffsetDateTime>,
    private val workflow: JsonField<String>,
    private val additionalProperties: MutableMap<String, JsonValue>,
) {

    @JsonCreator
    private constructor(
        @JsonProperty("id") @ExcludeMissing id: JsonField<String> = JsonMissing.of(),
        @JsonProperty("__typename") @ExcludeMissing _typename: JsonField<String> = JsonMissing.of(),
        @JsonProperty("actors")
        @ExcludeMissing
        actors: JsonField<List<RecipientReference>> = JsonMissing.of(),
        @JsonProperty("archived_at")
        @ExcludeMissing
        archivedAt: JsonField<OffsetDateTime> = JsonMissing.of(),
        @JsonProperty("channel_id") @ExcludeMissing channelId: JsonField<String> = JsonMissing.of(),
        @JsonProperty("clicked_at")
        @ExcludeMissing
        clickedAt: JsonField<OffsetDateTime> = JsonMissing.of(),
        @JsonProperty("data") @ExcludeMissing data: JsonField<Data> = JsonMissing.of(),
        @JsonProperty("engagement_statuses")
        @ExcludeMissing
        engagementStatuses: JsonField<List<EngagementStatus>> = JsonMissing.of(),
        @JsonProperty("inserted_at")
        @ExcludeMissing
        insertedAt: JsonField<OffsetDateTime> = JsonMissing.of(),
        @JsonProperty("interacted_at")
        @ExcludeMissing
        interactedAt: JsonField<OffsetDateTime> = JsonMissing.of(),
        @JsonProperty("link_clicked_at")
        @ExcludeMissing
        linkClickedAt: JsonField<OffsetDateTime> = JsonMissing.of(),
        @JsonProperty("metadata") @ExcludeMissing metadata: JsonField<Metadata> = JsonMissing.of(),
        @JsonProperty("read_at")
        @ExcludeMissing
        readAt: JsonField<OffsetDateTime> = JsonMissing.of(),
        @JsonProperty("recipient")
        @ExcludeMissing
        recipient: JsonField<RecipientReference> = JsonMissing.of(),
        @JsonProperty("scheduled_at")
        @ExcludeMissing
        scheduledAt: JsonField<OffsetDateTime> = JsonMissing.of(),
        @JsonProperty("seen_at")
        @ExcludeMissing
        seenAt: JsonField<OffsetDateTime> = JsonMissing.of(),
        @JsonProperty("source") @ExcludeMissing source: JsonField<Source> = JsonMissing.of(),
        @JsonProperty("status") @ExcludeMissing status: JsonField<Status> = JsonMissing.of(),
        @JsonProperty("tenant") @ExcludeMissing tenant: JsonField<String> = JsonMissing.of(),
        @JsonProperty("updated_at")
        @ExcludeMissing
        updatedAt: JsonField<OffsetDateTime> = JsonMissing.of(),
        @JsonProperty("workflow") @ExcludeMissing workflow: JsonField<String> = JsonMissing.of(),
    ) : this(
        id,
        _typename,
        actors,
        archivedAt,
        channelId,
        clickedAt,
        data,
        engagementStatuses,
        insertedAt,
        interactedAt,
        linkClickedAt,
        metadata,
        readAt,
        recipient,
        scheduledAt,
        seenAt,
        source,
        status,
        tenant,
        updatedAt,
        workflow,
        mutableMapOf(),
    )

    /**
     * The unique identifier for the message.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun id(): Optional<String> = id.getOptional("id")

    /**
     * The typename of the schema.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun _typename(): Optional<String> = _typename.getOptional("__typename")

    /**
     * One or more actors that are associated with this message. Note: this is a list that can
     * contain up to 10 actors if the message is produced from a
     * [batch](/designing-workflows/batch-function).
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun actors(): Optional<List<RecipientReference>> = actors.getOptional("actors")

    /**
     * Timestamp when the message was archived.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun archivedAt(): Optional<OffsetDateTime> = archivedAt.getOptional("archived_at")

    /**
     * The ID for the channel the message was sent through.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun channelId(): Optional<String> = channelId.getOptional("channel_id")

    /**
     * Timestamp when the message was clicked.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun clickedAt(): Optional<OffsetDateTime> = clickedAt.getOptional("clicked_at")

    /**
     * Data associated with the message’s workflow run. Includes the workflow trigger request’s
     * `data` payload merged with any additional data returned by a
     * [fetch function](/designing-workflows/fetch-function). For messages produced after a
     * [batch step](/designing-workflows/batch-function), includes the payload `data` from the
     * most-recent trigger request (the final `activity` in the batch).
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun data(): Optional<Data> = data.getOptional("data")

    /**
     * A list of engagement statuses.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun engagementStatuses(): Optional<List<EngagementStatus>> =
        engagementStatuses.getOptional("engagement_statuses")

    /**
     * Timestamp when the resource was created.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun insertedAt(): Optional<OffsetDateTime> = insertedAt.getOptional("inserted_at")

    /**
     * Timestamp when the message was interacted with.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun interactedAt(): Optional<OffsetDateTime> = interactedAt.getOptional("interacted_at")

    /**
     * Timestamp when a link in the message was clicked.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun linkClickedAt(): Optional<OffsetDateTime> = linkClickedAt.getOptional("link_clicked_at")

    /**
     * The metadata associated with the message.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun metadata(): Optional<Metadata> = metadata.getOptional("metadata")

    /**
     * Timestamp when the message was read.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun readAt(): Optional<OffsetDateTime> = readAt.getOptional("read_at")

    /**
     * A reference to a recipient, either a user identifier (string) or an object reference (ID,
     * collection).
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun recipient(): Optional<RecipientReference> = recipient.getOptional("recipient")

    /**
     * Timestamp when the message was scheduled to be sent.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun scheduledAt(): Optional<OffsetDateTime> = scheduledAt.getOptional("scheduled_at")

    /**
     * Timestamp when the message was seen.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun seenAt(): Optional<OffsetDateTime> = seenAt.getOptional("seen_at")

    /**
     * The workflow that triggered the message.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun source(): Optional<Source> = source.getOptional("source")

    /**
     * The message delivery status.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun status(): Optional<Status> = status.getOptional("status")

    /**
     * The ID of the `tenant` associated with the message. Only present when a `tenant` is provided
     * on a workflow trigger request.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun tenant(): Optional<String> = tenant.getOptional("tenant")

    /**
     * The timestamp when the resource was last updated.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun updatedAt(): Optional<OffsetDateTime> = updatedAt.getOptional("updated_at")

    /**
     * The key of the workflow that generated the message.
     *
     * @throws KnockInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    @Deprecated("deprecated") fun workflow(): Optional<String> = workflow.getOptional("workflow")

    /**
     * Returns the raw JSON value of [id].
     *
     * Unlike [id], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("id") @ExcludeMissing fun _id(): JsonField<String> = id

    /**
     * Returns the raw JSON value of [_typename].
     *
     * Unlike [_typename], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("__typename") @ExcludeMissing fun __typename(): JsonField<String> = _typename

    /**
     * Returns the raw JSON value of [actors].
     *
     * Unlike [actors], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("actors")
    @ExcludeMissing
    fun _actors(): JsonField<List<RecipientReference>> = actors

    /**
     * Returns the raw JSON value of [archivedAt].
     *
     * Unlike [archivedAt], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("archived_at")
    @ExcludeMissing
    fun _archivedAt(): JsonField<OffsetDateTime> = archivedAt

    /**
     * Returns the raw JSON value of [channelId].
     *
     * Unlike [channelId], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("channel_id") @ExcludeMissing fun _channelId(): JsonField<String> = channelId

    /**
     * Returns the raw JSON value of [clickedAt].
     *
     * Unlike [clickedAt], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("clicked_at")
    @ExcludeMissing
    fun _clickedAt(): JsonField<OffsetDateTime> = clickedAt

    /**
     * Returns the raw JSON value of [data].
     *
     * Unlike [data], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("data") @ExcludeMissing fun _data(): JsonField<Data> = data

    /**
     * Returns the raw JSON value of [engagementStatuses].
     *
     * Unlike [engagementStatuses], this method doesn't throw if the JSON field has an unexpected
     * type.
     */
    @JsonProperty("engagement_statuses")
    @ExcludeMissing
    fun _engagementStatuses(): JsonField<List<EngagementStatus>> = engagementStatuses

    /**
     * Returns the raw JSON value of [insertedAt].
     *
     * Unlike [insertedAt], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("inserted_at")
    @ExcludeMissing
    fun _insertedAt(): JsonField<OffsetDateTime> = insertedAt

    /**
     * Returns the raw JSON value of [interactedAt].
     *
     * Unlike [interactedAt], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("interacted_at")
    @ExcludeMissing
    fun _interactedAt(): JsonField<OffsetDateTime> = interactedAt

    /**
     * Returns the raw JSON value of [linkClickedAt].
     *
     * Unlike [linkClickedAt], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("link_clicked_at")
    @ExcludeMissing
    fun _linkClickedAt(): JsonField<OffsetDateTime> = linkClickedAt

    /**
     * Returns the raw JSON value of [metadata].
     *
     * Unlike [metadata], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("metadata") @ExcludeMissing fun _metadata(): JsonField<Metadata> = metadata

    /**
     * Returns the raw JSON value of [readAt].
     *
     * Unlike [readAt], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("read_at") @ExcludeMissing fun _readAt(): JsonField<OffsetDateTime> = readAt

    /**
     * Returns the raw JSON value of [recipient].
     *
     * Unlike [recipient], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("recipient")
    @ExcludeMissing
    fun _recipient(): JsonField<RecipientReference> = recipient

    /**
     * Returns the raw JSON value of [scheduledAt].
     *
     * Unlike [scheduledAt], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("scheduled_at")
    @ExcludeMissing
    fun _scheduledAt(): JsonField<OffsetDateTime> = scheduledAt

    /**
     * Returns the raw JSON value of [seenAt].
     *
     * Unlike [seenAt], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("seen_at") @ExcludeMissing fun _seenAt(): JsonField<OffsetDateTime> = seenAt

    /**
     * Returns the raw JSON value of [source].
     *
     * Unlike [source], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("source") @ExcludeMissing fun _source(): JsonField<Source> = source

    /**
     * Returns the raw JSON value of [status].
     *
     * Unlike [status], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("status") @ExcludeMissing fun _status(): JsonField<Status> = status

    /**
     * Returns the raw JSON value of [tenant].
     *
     * Unlike [tenant], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("tenant") @ExcludeMissing fun _tenant(): JsonField<String> = tenant

    /**
     * Returns the raw JSON value of [updatedAt].
     *
     * Unlike [updatedAt], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("updated_at")
    @ExcludeMissing
    fun _updatedAt(): JsonField<OffsetDateTime> = updatedAt

    /**
     * Returns the raw JSON value of [workflow].
     *
     * Unlike [workflow], this method doesn't throw if the JSON field has an unexpected type.
     */
    @Deprecated("deprecated")
    @JsonProperty("workflow")
    @ExcludeMissing
    fun _workflow(): JsonField<String> = workflow

    @JsonAnySetter
    private fun putAdditionalProperty(key: String, value: JsonValue) {
        additionalProperties.put(key, value)
    }

    @JsonAnyGetter
    @ExcludeMissing
    fun _additionalProperties(): Map<String, JsonValue> =
        Collections.unmodifiableMap(additionalProperties)

    fun toBuilder() = Builder().from(this)

    companion object {

        /** Returns a mutable builder for constructing an instance of [Message]. */
        @JvmStatic fun builder() = Builder()
    }

    /** A builder for [Message]. */
    class Builder internal constructor() {

        private var id: JsonField<String> = JsonMissing.of()
        private var _typename: JsonField<String> = JsonMissing.of()
        private var actors: JsonField<MutableList<RecipientReference>>? = null
        private var archivedAt: JsonField<OffsetDateTime> = JsonMissing.of()
        private var channelId: JsonField<String> = JsonMissing.of()
        private var clickedAt: JsonField<OffsetDateTime> = JsonMissing.of()
        private var data: JsonField<Data> = JsonMissing.of()
        private var engagementStatuses: JsonField<MutableList<EngagementStatus>>? = null
        private var insertedAt: JsonField<OffsetDateTime> = JsonMissing.of()
        private var interactedAt: JsonField<OffsetDateTime> = JsonMissing.of()
        private var linkClickedAt: JsonField<OffsetDateTime> = JsonMissing.of()
        private var metadata: JsonField<Metadata> = JsonMissing.of()
        private var readAt: JsonField<OffsetDateTime> = JsonMissing.of()
        private var recipient: JsonField<RecipientReference> = JsonMissing.of()
        private var scheduledAt: JsonField<OffsetDateTime> = JsonMissing.of()
        private var seenAt: JsonField<OffsetDateTime> = JsonMissing.of()
        private var source: JsonField<Source> = JsonMissing.of()
        private var status: JsonField<Status> = JsonMissing.of()
        private var tenant: JsonField<String> = JsonMissing.of()
        private var updatedAt: JsonField<OffsetDateTime> = JsonMissing.of()
        private var workflow: JsonField<String> = JsonMissing.of()
        private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

        @JvmSynthetic
        internal fun from(message: Message) = apply {
            id = message.id
            _typename = message._typename
            actors = message.actors.map { it.toMutableList() }
            archivedAt = message.archivedAt
            channelId = message.channelId
            clickedAt = message.clickedAt
            data = message.data
            engagementStatuses = message.engagementStatuses.map { it.toMutableList() }
            insertedAt = message.insertedAt
            interactedAt = message.interactedAt
            linkClickedAt = message.linkClickedAt
            metadata = message.metadata
            readAt = message.readAt
            recipient = message.recipient
            scheduledAt = message.scheduledAt
            seenAt = message.seenAt
            source = message.source
            status = message.status
            tenant = message.tenant
            updatedAt = message.updatedAt
            workflow = message.workflow
            additionalProperties = message.additionalProperties.toMutableMap()
        }

        /** The unique identifier for the message. */
        fun id(id: String) = id(JsonField.of(id))

        /**
         * Sets [Builder.id] to an arbitrary JSON value.
         *
         * You should usually call [Builder.id] with a well-typed [String] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun id(id: JsonField<String>) = apply { this.id = id }

        /** The typename of the schema. */
        fun _typename(_typename: String) = _typename(JsonField.of(_typename))

        /**
         * Sets [Builder._typename] to an arbitrary JSON value.
         *
         * You should usually call [Builder._typename] with a well-typed [String] value instead.
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun _typename(_typename: JsonField<String>) = apply { this._typename = _typename }

        /**
         * One or more actors that are associated with this message. Note: this is a list that can
         * contain up to 10 actors if the message is produced from a
         * [batch](/designing-workflows/batch-function).
         */
        fun actors(actors: List<RecipientReference>) = actors(JsonField.of(actors))

        /**
         * Sets [Builder.actors] to an arbitrary JSON value.
         *
         * You should usually call [Builder.actors] with a well-typed `List<RecipientReference>`
         * value instead. This method is primarily for setting the field to an undocumented or not
         * yet supported value.
         */
        fun actors(actors: JsonField<List<RecipientReference>>) = apply {
            this.actors = actors.map { it.toMutableList() }
        }

        /**
         * Adds a single [RecipientReference] to [actors].
         *
         * @throws IllegalStateException if the field was previously set to a non-list.
         */
        fun addActor(actor: RecipientReference) = apply {
            actors =
                (actors ?: JsonField.of(mutableListOf())).also {
                    checkKnown("actors", it).add(actor)
                }
        }

        /** Alias for calling [addActor] with `RecipientReference.ofUser(user)`. */
        fun addActor(user: String) = addActor(RecipientReference.ofUser(user))

        /**
         * Alias for calling [addActor] with
         * `RecipientReference.ofObjectReference(objectReference)`.
         */
        fun addActor(objectReference: RecipientReference.ObjectReference) =
            addActor(RecipientReference.ofObjectReference(objectReference))

        /** Timestamp when the message was archived. */
        fun archivedAt(archivedAt: OffsetDateTime?) = archivedAt(JsonField.ofNullable(archivedAt))

        /** Alias for calling [Builder.archivedAt] with `archivedAt.orElse(null)`. */
        fun archivedAt(archivedAt: Optional<OffsetDateTime>) = archivedAt(archivedAt.getOrNull())

        /**
         * Sets [Builder.archivedAt] to an arbitrary JSON value.
         *
         * You should usually call [Builder.archivedAt] with a well-typed [OffsetDateTime] value
         * instead. This method is primarily for setting the field to an undocumented or not yet
         * supported value.
         */
        fun archivedAt(archivedAt: JsonField<OffsetDateTime>) = apply {
            this.archivedAt = archivedAt
        }

        /** The ID for the channel the message was sent through. */
        fun channelId(channelId: String) = channelId(JsonField.of(channelId))

        /**
         * Sets [Builder.channelId] to an arbitrary JSON value.
         *
         * You should usually call [Builder.channelId] with a well-typed [String] value instead.
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun channelId(channelId: JsonField<String>) = apply { this.channelId = channelId }

        /** Timestamp when the message was clicked. */
        fun clickedAt(clickedAt: OffsetDateTime?) = clickedAt(JsonField.ofNullable(clickedAt))

        /** Alias for calling [Builder.clickedAt] with `clickedAt.orElse(null)`. */
        fun clickedAt(clickedAt: Optional<OffsetDateTime>) = clickedAt(clickedAt.getOrNull())

        /**
         * Sets [Builder.clickedAt] to an arbitrary JSON value.
         *
         * You should usually call [Builder.clickedAt] with a well-typed [OffsetDateTime] value
         * instead. This method is primarily for setting the field to an undocumented or not yet
         * supported value.
         */
        fun clickedAt(clickedAt: JsonField<OffsetDateTime>) = apply { this.clickedAt = clickedAt }

        /**
         * Data associated with the message’s workflow run. Includes the workflow trigger request’s
         * `data` payload merged with any additional data returned by a
         * [fetch function](/designing-workflows/fetch-function). For messages produced after a
         * [batch step](/designing-workflows/batch-function), includes the payload `data` from the
         * most-recent trigger request (the final `activity` in the batch).
         */
        fun data(data: Data?) = data(JsonField.ofNullable(data))

        /** Alias for calling [Builder.data] with `data.orElse(null)`. */
        fun data(data: Optional<Data>) = data(data.getOrNull())

        /**
         * Sets [Builder.data] to an arbitrary JSON value.
         *
         * You should usually call [Builder.data] with a well-typed [Data] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun data(data: JsonField<Data>) = apply { this.data = data }

        /** A list of engagement statuses. */
        fun engagementStatuses(engagementStatuses: List<EngagementStatus>) =
            engagementStatuses(JsonField.of(engagementStatuses))

        /**
         * Sets [Builder.engagementStatuses] to an arbitrary JSON value.
         *
         * You should usually call [Builder.engagementStatuses] with a well-typed
         * `List<EngagementStatus>` value instead. This method is primarily for setting the field to
         * an undocumented or not yet supported value.
         */
        fun engagementStatuses(engagementStatuses: JsonField<List<EngagementStatus>>) = apply {
            this.engagementStatuses = engagementStatuses.map { it.toMutableList() }
        }

        /**
         * Adds a single [EngagementStatus] to [engagementStatuses].
         *
         * @throws IllegalStateException if the field was previously set to a non-list.
         */
        fun addEngagementStatus(engagementStatus: EngagementStatus) = apply {
            engagementStatuses =
                (engagementStatuses ?: JsonField.of(mutableListOf())).also {
                    checkKnown("engagementStatuses", it).add(engagementStatus)
                }
        }

        /** Timestamp when the resource was created. */
        fun insertedAt(insertedAt: OffsetDateTime) = insertedAt(JsonField.of(insertedAt))

        /**
         * Sets [Builder.insertedAt] to an arbitrary JSON value.
         *
         * You should usually call [Builder.insertedAt] with a well-typed [OffsetDateTime] value
         * instead. This method is primarily for setting the field to an undocumented or not yet
         * supported value.
         */
        fun insertedAt(insertedAt: JsonField<OffsetDateTime>) = apply {
            this.insertedAt = insertedAt
        }

        /** Timestamp when the message was interacted with. */
        fun interactedAt(interactedAt: OffsetDateTime?) =
            interactedAt(JsonField.ofNullable(interactedAt))

        /** Alias for calling [Builder.interactedAt] with `interactedAt.orElse(null)`. */
        fun interactedAt(interactedAt: Optional<OffsetDateTime>) =
            interactedAt(interactedAt.getOrNull())

        /**
         * Sets [Builder.interactedAt] to an arbitrary JSON value.
         *
         * You should usually call [Builder.interactedAt] with a well-typed [OffsetDateTime] value
         * instead. This method is primarily for setting the field to an undocumented or not yet
         * supported value.
         */
        fun interactedAt(interactedAt: JsonField<OffsetDateTime>) = apply {
            this.interactedAt = interactedAt
        }

        /** Timestamp when a link in the message was clicked. */
        fun linkClickedAt(linkClickedAt: OffsetDateTime?) =
            linkClickedAt(JsonField.ofNullable(linkClickedAt))

        /** Alias for calling [Builder.linkClickedAt] with `linkClickedAt.orElse(null)`. */
        fun linkClickedAt(linkClickedAt: Optional<OffsetDateTime>) =
            linkClickedAt(linkClickedAt.getOrNull())

        /**
         * Sets [Builder.linkClickedAt] to an arbitrary JSON value.
         *
         * You should usually call [Builder.linkClickedAt] with a well-typed [OffsetDateTime] value
         * instead. This method is primarily for setting the field to an undocumented or not yet
         * supported value.
         */
        fun linkClickedAt(linkClickedAt: JsonField<OffsetDateTime>) = apply {
            this.linkClickedAt = linkClickedAt
        }

        /** The metadata associated with the message. */
        fun metadata(metadata: Metadata?) = metadata(JsonField.ofNullable(metadata))

        /** Alias for calling [Builder.metadata] with `metadata.orElse(null)`. */
        fun metadata(metadata: Optional<Metadata>) = metadata(metadata.getOrNull())

        /**
         * Sets [Builder.metadata] to an arbitrary JSON value.
         *
         * You should usually call [Builder.metadata] with a well-typed [Metadata] value instead.
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun metadata(metadata: JsonField<Metadata>) = apply { this.metadata = metadata }

        /** Timestamp when the message was read. */
        fun readAt(readAt: OffsetDateTime?) = readAt(JsonField.ofNullable(readAt))

        /** Alias for calling [Builder.readAt] with `readAt.orElse(null)`. */
        fun readAt(readAt: Optional<OffsetDateTime>) = readAt(readAt.getOrNull())

        /**
         * Sets [Builder.readAt] to an arbitrary JSON value.
         *
         * You should usually call [Builder.readAt] with a well-typed [OffsetDateTime] value
         * instead. This method is primarily for setting the field to an undocumented or not yet
         * supported value.
         */
        fun readAt(readAt: JsonField<OffsetDateTime>) = apply { this.readAt = readAt }

        /**
         * A reference to a recipient, either a user identifier (string) or an object reference (ID,
         * collection).
         */
        fun recipient(recipient: RecipientReference) = recipient(JsonField.of(recipient))

        /**
         * Sets [Builder.recipient] to an arbitrary JSON value.
         *
         * You should usually call [Builder.recipient] with a well-typed [RecipientReference] value
         * instead. This method is primarily for setting the field to an undocumented or not yet
         * supported value.
         */
        fun recipient(recipient: JsonField<RecipientReference>) = apply {
            this.recipient = recipient
        }

        /** Alias for calling [recipient] with `RecipientReference.ofUser(user)`. */
        fun recipient(user: String) = recipient(RecipientReference.ofUser(user))

        /**
         * Alias for calling [recipient] with
         * `RecipientReference.ofObjectReference(objectReference)`.
         */
        fun recipient(objectReference: RecipientReference.ObjectReference) =
            recipient(RecipientReference.ofObjectReference(objectReference))

        /** Timestamp when the message was scheduled to be sent. */
        fun scheduledAt(scheduledAt: OffsetDateTime?) =
            scheduledAt(JsonField.ofNullable(scheduledAt))

        /** Alias for calling [Builder.scheduledAt] with `scheduledAt.orElse(null)`. */
        fun scheduledAt(scheduledAt: Optional<OffsetDateTime>) =
            scheduledAt(scheduledAt.getOrNull())

        /**
         * Sets [Builder.scheduledAt] to an arbitrary JSON value.
         *
         * You should usually call [Builder.scheduledAt] with a well-typed [OffsetDateTime] value
         * instead. This method is primarily for setting the field to an undocumented or not yet
         * supported value.
         */
        fun scheduledAt(scheduledAt: JsonField<OffsetDateTime>) = apply {
            this.scheduledAt = scheduledAt
        }

        /** Timestamp when the message was seen. */
        fun seenAt(seenAt: OffsetDateTime?) = seenAt(JsonField.ofNullable(seenAt))

        /** Alias for calling [Builder.seenAt] with `seenAt.orElse(null)`. */
        fun seenAt(seenAt: Optional<OffsetDateTime>) = seenAt(seenAt.getOrNull())

        /**
         * Sets [Builder.seenAt] to an arbitrary JSON value.
         *
         * You should usually call [Builder.seenAt] with a well-typed [OffsetDateTime] value
         * instead. This method is primarily for setting the field to an undocumented or not yet
         * supported value.
         */
        fun seenAt(seenAt: JsonField<OffsetDateTime>) = apply { this.seenAt = seenAt }

        /** The workflow that triggered the message. */
        fun source(source: Source) = source(JsonField.of(source))

        /**
         * Sets [Builder.source] to an arbitrary JSON value.
         *
         * You should usually call [Builder.source] with a well-typed [Source] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun source(source: JsonField<Source>) = apply { this.source = source }

        /** The message delivery status. */
        fun status(status: Status) = status(JsonField.of(status))

        /**
         * Sets [Builder.status] to an arbitrary JSON value.
         *
         * You should usually call [Builder.status] with a well-typed [Status] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun status(status: JsonField<Status>) = apply { this.status = status }

        /**
         * The ID of the `tenant` associated with the message. Only present when a `tenant` is
         * provided on a workflow trigger request.
         */
        fun tenant(tenant: String?) = tenant(JsonField.ofNullable(tenant))

        /** Alias for calling [Builder.tenant] with `tenant.orElse(null)`. */
        fun tenant(tenant: Optional<String>) = tenant(tenant.getOrNull())

        /**
         * Sets [Builder.tenant] to an arbitrary JSON value.
         *
         * You should usually call [Builder.tenant] with a well-typed [String] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun tenant(tenant: JsonField<String>) = apply { this.tenant = tenant }

        /** The timestamp when the resource was last updated. */
        fun updatedAt(updatedAt: OffsetDateTime) = updatedAt(JsonField.of(updatedAt))

        /**
         * Sets [Builder.updatedAt] to an arbitrary JSON value.
         *
         * You should usually call [Builder.updatedAt] with a well-typed [OffsetDateTime] value
         * instead. This method is primarily for setting the field to an undocumented or not yet
         * supported value.
         */
        fun updatedAt(updatedAt: JsonField<OffsetDateTime>) = apply { this.updatedAt = updatedAt }

        /** The key of the workflow that generated the message. */
        @Deprecated("deprecated")
        fun workflow(workflow: String?) = workflow(JsonField.ofNullable(workflow))

        /** Alias for calling [Builder.workflow] with `workflow.orElse(null)`. */
        @Deprecated("deprecated")
        fun workflow(workflow: Optional<String>) = workflow(workflow.getOrNull())

        /**
         * Sets [Builder.workflow] to an arbitrary JSON value.
         *
         * You should usually call [Builder.workflow] with a well-typed [String] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        @Deprecated("deprecated")
        fun workflow(workflow: JsonField<String>) = apply { this.workflow = workflow }

        fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
            this.additionalProperties.clear()
            putAllAdditionalProperties(additionalProperties)
        }

        fun putAdditionalProperty(key: String, value: JsonValue) = apply {
            additionalProperties.put(key, value)
        }

        fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
            this.additionalProperties.putAll(additionalProperties)
        }

        fun removeAdditionalProperty(key: String) = apply { additionalProperties.remove(key) }

        fun removeAllAdditionalProperties(keys: Set<String>) = apply {
            keys.forEach(::removeAdditionalProperty)
        }

        /**
         * Returns an immutable instance of [Message].
         *
         * Further updates to this [Builder] will not mutate the returned instance.
         */
        fun build(): Message =
            Message(
                id,
                _typename,
                (actors ?: JsonMissing.of()).map { it.toImmutable() },
                archivedAt,
                channelId,
                clickedAt,
                data,
                (engagementStatuses ?: JsonMissing.of()).map { it.toImmutable() },
                insertedAt,
                interactedAt,
                linkClickedAt,
                metadata,
                readAt,
                recipient,
                scheduledAt,
                seenAt,
                source,
                status,
                tenant,
                updatedAt,
                workflow,
                additionalProperties.toMutableMap(),
            )
    }

    private var validated: Boolean = false

    fun validate(): Message = apply {
        if (validated) {
            return@apply
        }

        id()
        _typename()
        actors().ifPresent { it.forEach { it.validate() } }
        archivedAt()
        channelId()
        clickedAt()
        data().ifPresent { it.validate() }
        engagementStatuses().ifPresent { it.forEach { it.validate() } }
        insertedAt()
        interactedAt()
        linkClickedAt()
        metadata().ifPresent { it.validate() }
        readAt()
        recipient().ifPresent { it.validate() }
        scheduledAt()
        seenAt()
        source().ifPresent { it.validate() }
        status().ifPresent { it.validate() }
        tenant()
        updatedAt()
        workflow()
        validated = true
    }

    fun isValid(): Boolean =
        try {
            validate()
            true
        } catch (e: KnockInvalidDataException) {
            false
        }

    /**
     * Returns a score indicating how many valid values are contained in this object recursively.
     *
     * Used for best match union deserialization.
     */
    @JvmSynthetic
    internal fun validity(): Int =
        (if (id.asKnown().isPresent) 1 else 0) +
            (if (_typename.asKnown().isPresent) 1 else 0) +
            (actors.asKnown().getOrNull()?.sumOf { it.validity().toInt() } ?: 0) +
            (if (archivedAt.asKnown().isPresent) 1 else 0) +
            (if (channelId.asKnown().isPresent) 1 else 0) +
            (if (clickedAt.asKnown().isPresent) 1 else 0) +
            (data.asKnown().getOrNull()?.validity() ?: 0) +
            (engagementStatuses.asKnown().getOrNull()?.sumOf { it.validity().toInt() } ?: 0) +
            (if (insertedAt.asKnown().isPresent) 1 else 0) +
            (if (interactedAt.asKnown().isPresent) 1 else 0) +
            (if (linkClickedAt.asKnown().isPresent) 1 else 0) +
            (metadata.asKnown().getOrNull()?.validity() ?: 0) +
            (if (readAt.asKnown().isPresent) 1 else 0) +
            (recipient.asKnown().getOrNull()?.validity() ?: 0) +
            (if (scheduledAt.asKnown().isPresent) 1 else 0) +
            (if (seenAt.asKnown().isPresent) 1 else 0) +
            (source.asKnown().getOrNull()?.validity() ?: 0) +
            (status.asKnown().getOrNull()?.validity() ?: 0) +
            (if (tenant.asKnown().isPresent) 1 else 0) +
            (if (updatedAt.asKnown().isPresent) 1 else 0) +
            (if (workflow.asKnown().isPresent) 1 else 0)

    /**
     * Data associated with the message’s workflow run. Includes the workflow trigger request’s
     * `data` payload merged with any additional data returned by a
     * [fetch function](/designing-workflows/fetch-function). For messages produced after a
     * [batch step](/designing-workflows/batch-function), includes the payload `data` from the
     * most-recent trigger request (the final `activity` in the batch).
     */
    class Data
    @JsonCreator
    private constructor(
        @com.fasterxml.jackson.annotation.JsonValue
        private val additionalProperties: Map<String, JsonValue>
    ) {

        @JsonAnyGetter
        @ExcludeMissing
        fun _additionalProperties(): Map<String, JsonValue> = additionalProperties

        fun toBuilder() = Builder().from(this)

        companion object {

            /** Returns a mutable builder for constructing an instance of [Data]. */
            @JvmStatic fun builder() = Builder()
        }

        /** A builder for [Data]. */
        class Builder internal constructor() {

            private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

            @JvmSynthetic
            internal fun from(data: Data) = apply {
                additionalProperties = data.additionalProperties.toMutableMap()
            }

            fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                this.additionalProperties.clear()
                putAllAdditionalProperties(additionalProperties)
            }

            fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                additionalProperties.put(key, value)
            }

            fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                this.additionalProperties.putAll(additionalProperties)
            }

            fun removeAdditionalProperty(key: String) = apply { additionalProperties.remove(key) }

            fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                keys.forEach(::removeAdditionalProperty)
            }

            /**
             * Returns an immutable instance of [Data].
             *
             * Further updates to this [Builder] will not mutate the returned instance.
             */
            fun build(): Data = Data(additionalProperties.toImmutable())
        }

        private var validated: Boolean = false

        fun validate(): Data = apply {
            if (validated) {
                return@apply
            }

            validated = true
        }

        fun isValid(): Boolean =
            try {
                validate()
                true
            } catch (e: KnockInvalidDataException) {
                false
            }

        /**
         * Returns a score indicating how many valid values are contained in this object
         * recursively.
         *
         * Used for best match union deserialization.
         */
        @JvmSynthetic
        internal fun validity(): Int =
            additionalProperties.count { (_, value) -> !value.isNull() && !value.isMissing() }

        override fun equals(other: Any?): Boolean {
            if (this === other) {
                return true
            }

            return /* spotless:off */ other is Data && additionalProperties == other.additionalProperties /* spotless:on */
        }

        /* spotless:off */
        private val hashCode: Int by lazy { Objects.hash(additionalProperties) }
        /* spotless:on */

        override fun hashCode(): Int = hashCode

        override fun toString() = "Data{additionalProperties=$additionalProperties}"
    }

    /**
     * An engagement status for a message. Can be one of: read, seen, interacted, link_clicked,
     * archived.
     */
    class EngagementStatus @JsonCreator private constructor(private val value: JsonField<String>) :
        Enum {

        /**
         * Returns this class instance's raw value.
         *
         * This is usually only useful if this instance was deserialized from data that doesn't
         * match any known member, and you want to know that value. For example, if the SDK is on an
         * older version than the API, then the API may respond with new members that the SDK is
         * unaware of.
         */
        @com.fasterxml.jackson.annotation.JsonValue fun _value(): JsonField<String> = value

        companion object {

            @JvmField val SEEN = of("seen")

            @JvmField val READ = of("read")

            @JvmField val INTERACTED = of("interacted")

            @JvmField val LINK_CLICKED = of("link_clicked")

            @JvmField val ARCHIVED = of("archived")

            @JvmStatic fun of(value: String) = EngagementStatus(JsonField.of(value))
        }

        /** An enum containing [EngagementStatus]'s known values. */
        enum class Known {
            SEEN,
            READ,
            INTERACTED,
            LINK_CLICKED,
            ARCHIVED,
        }

        /**
         * An enum containing [EngagementStatus]'s known values, as well as an [_UNKNOWN] member.
         *
         * An instance of [EngagementStatus] can contain an unknown value in a couple of cases:
         * - It was deserialized from data that doesn't match any known member. For example, if the
         *   SDK is on an older version than the API, then the API may respond with new members that
         *   the SDK is unaware of.
         * - It was constructed with an arbitrary value using the [of] method.
         */
        enum class Value {
            SEEN,
            READ,
            INTERACTED,
            LINK_CLICKED,
            ARCHIVED,
            /**
             * An enum member indicating that [EngagementStatus] was instantiated with an unknown
             * value.
             */
            _UNKNOWN,
        }

        /**
         * Returns an enum member corresponding to this class instance's value, or [Value._UNKNOWN]
         * if the class was instantiated with an unknown value.
         *
         * Use the [known] method instead if you're certain the value is always known or if you want
         * to throw for the unknown case.
         */
        fun value(): Value =
            when (this) {
                SEEN -> Value.SEEN
                READ -> Value.READ
                INTERACTED -> Value.INTERACTED
                LINK_CLICKED -> Value.LINK_CLICKED
                ARCHIVED -> Value.ARCHIVED
                else -> Value._UNKNOWN
            }

        /**
         * Returns an enum member corresponding to this class instance's value.
         *
         * Use the [value] method instead if you're uncertain the value is always known and don't
         * want to throw for the unknown case.
         *
         * @throws KnockInvalidDataException if this class instance's value is a not a known member.
         */
        fun known(): Known =
            when (this) {
                SEEN -> Known.SEEN
                READ -> Known.READ
                INTERACTED -> Known.INTERACTED
                LINK_CLICKED -> Known.LINK_CLICKED
                ARCHIVED -> Known.ARCHIVED
                else -> throw KnockInvalidDataException("Unknown EngagementStatus: $value")
            }

        /**
         * Returns this class instance's primitive wire representation.
         *
         * This differs from the [toString] method because that method is primarily for debugging
         * and generally doesn't throw.
         *
         * @throws KnockInvalidDataException if this class instance's value does not have the
         *   expected primitive type.
         */
        fun asString(): String =
            _value().asString().orElseThrow { KnockInvalidDataException("Value is not a String") }

        private var validated: Boolean = false

        fun validate(): EngagementStatus = apply {
            if (validated) {
                return@apply
            }

            known()
            validated = true
        }

        fun isValid(): Boolean =
            try {
                validate()
                true
            } catch (e: KnockInvalidDataException) {
                false
            }

        /**
         * Returns a score indicating how many valid values are contained in this object
         * recursively.
         *
         * Used for best match union deserialization.
         */
        @JvmSynthetic internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

        override fun equals(other: Any?): Boolean {
            if (this === other) {
                return true
            }

            return /* spotless:off */ other is EngagementStatus && value == other.value /* spotless:on */
        }

        override fun hashCode() = value.hashCode()

        override fun toString() = value.toString()
    }

    /** The metadata associated with the message. */
    class Metadata
    @JsonCreator
    private constructor(
        @com.fasterxml.jackson.annotation.JsonValue
        private val additionalProperties: Map<String, JsonValue>
    ) {

        @JsonAnyGetter
        @ExcludeMissing
        fun _additionalProperties(): Map<String, JsonValue> = additionalProperties

        fun toBuilder() = Builder().from(this)

        companion object {

            /** Returns a mutable builder for constructing an instance of [Metadata]. */
            @JvmStatic fun builder() = Builder()
        }

        /** A builder for [Metadata]. */
        class Builder internal constructor() {

            private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

            @JvmSynthetic
            internal fun from(metadata: Metadata) = apply {
                additionalProperties = metadata.additionalProperties.toMutableMap()
            }

            fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                this.additionalProperties.clear()
                putAllAdditionalProperties(additionalProperties)
            }

            fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                additionalProperties.put(key, value)
            }

            fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                this.additionalProperties.putAll(additionalProperties)
            }

            fun removeAdditionalProperty(key: String) = apply { additionalProperties.remove(key) }

            fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                keys.forEach(::removeAdditionalProperty)
            }

            /**
             * Returns an immutable instance of [Metadata].
             *
             * Further updates to this [Builder] will not mutate the returned instance.
             */
            fun build(): Metadata = Metadata(additionalProperties.toImmutable())
        }

        private var validated: Boolean = false

        fun validate(): Metadata = apply {
            if (validated) {
                return@apply
            }

            validated = true
        }

        fun isValid(): Boolean =
            try {
                validate()
                true
            } catch (e: KnockInvalidDataException) {
                false
            }

        /**
         * Returns a score indicating how many valid values are contained in this object
         * recursively.
         *
         * Used for best match union deserialization.
         */
        @JvmSynthetic
        internal fun validity(): Int =
            additionalProperties.count { (_, value) -> !value.isNull() && !value.isMissing() }

        override fun equals(other: Any?): Boolean {
            if (this === other) {
                return true
            }

            return /* spotless:off */ other is Metadata && additionalProperties == other.additionalProperties /* spotless:on */
        }

        /* spotless:off */
        private val hashCode: Int by lazy { Objects.hash(additionalProperties) }
        /* spotless:on */

        override fun hashCode(): Int = hashCode

        override fun toString() = "Metadata{additionalProperties=$additionalProperties}"
    }

    /** The workflow that triggered the message. */
    class Source
    private constructor(
        private val _typename: JsonField<String>,
        private val categories: JsonField<List<String>>,
        private val key: JsonField<String>,
        private val versionId: JsonField<String>,
        private val additionalProperties: MutableMap<String, JsonValue>,
    ) {

        @JsonCreator
        private constructor(
            @JsonProperty("__typename")
            @ExcludeMissing
            _typename: JsonField<String> = JsonMissing.of(),
            @JsonProperty("categories")
            @ExcludeMissing
            categories: JsonField<List<String>> = JsonMissing.of(),
            @JsonProperty("key") @ExcludeMissing key: JsonField<String> = JsonMissing.of(),
            @JsonProperty("version_id")
            @ExcludeMissing
            versionId: JsonField<String> = JsonMissing.of(),
        ) : this(_typename, categories, key, versionId, mutableMapOf())

        /**
         * @throws KnockInvalidDataException if the JSON field has an unexpected type or is
         *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
         */
        fun _typename(): String = _typename.getRequired("__typename")

        /**
         * The categories associated with the message.
         *
         * @throws KnockInvalidDataException if the JSON field has an unexpected type or is
         *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
         */
        fun categories(): List<String> = categories.getRequired("categories")

        /**
         * The key of the workflow that triggered the message.
         *
         * @throws KnockInvalidDataException if the JSON field has an unexpected type or is
         *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
         */
        fun key(): String = key.getRequired("key")

        /**
         * The ID of the version of the workflow that triggered the message.
         *
         * @throws KnockInvalidDataException if the JSON field has an unexpected type or is
         *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
         */
        fun versionId(): String = versionId.getRequired("version_id")

        /**
         * Returns the raw JSON value of [_typename].
         *
         * Unlike [_typename], this method doesn't throw if the JSON field has an unexpected type.
         */
        @JsonProperty("__typename") @ExcludeMissing fun __typename(): JsonField<String> = _typename

        /**
         * Returns the raw JSON value of [categories].
         *
         * Unlike [categories], this method doesn't throw if the JSON field has an unexpected type.
         */
        @JsonProperty("categories")
        @ExcludeMissing
        fun _categories(): JsonField<List<String>> = categories

        /**
         * Returns the raw JSON value of [key].
         *
         * Unlike [key], this method doesn't throw if the JSON field has an unexpected type.
         */
        @JsonProperty("key") @ExcludeMissing fun _key(): JsonField<String> = key

        /**
         * Returns the raw JSON value of [versionId].
         *
         * Unlike [versionId], this method doesn't throw if the JSON field has an unexpected type.
         */
        @JsonProperty("version_id") @ExcludeMissing fun _versionId(): JsonField<String> = versionId

        @JsonAnySetter
        private fun putAdditionalProperty(key: String, value: JsonValue) {
            additionalProperties.put(key, value)
        }

        @JsonAnyGetter
        @ExcludeMissing
        fun _additionalProperties(): Map<String, JsonValue> =
            Collections.unmodifiableMap(additionalProperties)

        fun toBuilder() = Builder().from(this)

        companion object {

            /**
             * Returns a mutable builder for constructing an instance of [Source].
             *
             * The following fields are required:
             * ```java
             * ._typename()
             * .categories()
             * .key()
             * .versionId()
             * ```
             */
            @JvmStatic fun builder() = Builder()
        }

        /** A builder for [Source]. */
        class Builder internal constructor() {

            private var _typename: JsonField<String>? = null
            private var categories: JsonField<MutableList<String>>? = null
            private var key: JsonField<String>? = null
            private var versionId: JsonField<String>? = null
            private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

            @JvmSynthetic
            internal fun from(source: Source) = apply {
                _typename = source._typename
                categories = source.categories.map { it.toMutableList() }
                key = source.key
                versionId = source.versionId
                additionalProperties = source.additionalProperties.toMutableMap()
            }

            fun _typename(_typename: String) = _typename(JsonField.of(_typename))

            /**
             * Sets [Builder._typename] to an arbitrary JSON value.
             *
             * You should usually call [Builder._typename] with a well-typed [String] value instead.
             * This method is primarily for setting the field to an undocumented or not yet
             * supported value.
             */
            fun _typename(_typename: JsonField<String>) = apply { this._typename = _typename }

            /** The categories associated with the message. */
            fun categories(categories: List<String>) = categories(JsonField.of(categories))

            /**
             * Sets [Builder.categories] to an arbitrary JSON value.
             *
             * You should usually call [Builder.categories] with a well-typed `List<String>` value
             * instead. This method is primarily for setting the field to an undocumented or not yet
             * supported value.
             */
            fun categories(categories: JsonField<List<String>>) = apply {
                this.categories = categories.map { it.toMutableList() }
            }

            /**
             * Adds a single [String] to [categories].
             *
             * @throws IllegalStateException if the field was previously set to a non-list.
             */
            fun addCategory(category: String) = apply {
                categories =
                    (categories ?: JsonField.of(mutableListOf())).also {
                        checkKnown("categories", it).add(category)
                    }
            }

            /** The key of the workflow that triggered the message. */
            fun key(key: String) = key(JsonField.of(key))

            /**
             * Sets [Builder.key] to an arbitrary JSON value.
             *
             * You should usually call [Builder.key] with a well-typed [String] value instead. This
             * method is primarily for setting the field to an undocumented or not yet supported
             * value.
             */
            fun key(key: JsonField<String>) = apply { this.key = key }

            /** The ID of the version of the workflow that triggered the message. */
            fun versionId(versionId: String) = versionId(JsonField.of(versionId))

            /**
             * Sets [Builder.versionId] to an arbitrary JSON value.
             *
             * You should usually call [Builder.versionId] with a well-typed [String] value instead.
             * This method is primarily for setting the field to an undocumented or not yet
             * supported value.
             */
            fun versionId(versionId: JsonField<String>) = apply { this.versionId = versionId }

            fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                this.additionalProperties.clear()
                putAllAdditionalProperties(additionalProperties)
            }

            fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                additionalProperties.put(key, value)
            }

            fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                this.additionalProperties.putAll(additionalProperties)
            }

            fun removeAdditionalProperty(key: String) = apply { additionalProperties.remove(key) }

            fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                keys.forEach(::removeAdditionalProperty)
            }

            /**
             * Returns an immutable instance of [Source].
             *
             * Further updates to this [Builder] will not mutate the returned instance.
             *
             * The following fields are required:
             * ```java
             * ._typename()
             * .categories()
             * .key()
             * .versionId()
             * ```
             *
             * @throws IllegalStateException if any required field is unset.
             */
            fun build(): Source =
                Source(
                    checkRequired("_typename", _typename),
                    checkRequired("categories", categories).map { it.toImmutable() },
                    checkRequired("key", key),
                    checkRequired("versionId", versionId),
                    additionalProperties.toMutableMap(),
                )
        }

        private var validated: Boolean = false

        fun validate(): Source = apply {
            if (validated) {
                return@apply
            }

            _typename()
            categories()
            key()
            versionId()
            validated = true
        }

        fun isValid(): Boolean =
            try {
                validate()
                true
            } catch (e: KnockInvalidDataException) {
                false
            }

        /**
         * Returns a score indicating how many valid values are contained in this object
         * recursively.
         *
         * Used for best match union deserialization.
         */
        @JvmSynthetic
        internal fun validity(): Int =
            (if (_typename.asKnown().isPresent) 1 else 0) +
                (categories.asKnown().getOrNull()?.size ?: 0) +
                (if (key.asKnown().isPresent) 1 else 0) +
                (if (versionId.asKnown().isPresent) 1 else 0)

        override fun equals(other: Any?): Boolean {
            if (this === other) {
                return true
            }

            return /* spotless:off */ other is Source && _typename == other._typename && categories == other.categories && key == other.key && versionId == other.versionId && additionalProperties == other.additionalProperties /* spotless:on */
        }

        /* spotless:off */
        private val hashCode: Int by lazy { Objects.hash(_typename, categories, key, versionId, additionalProperties) }
        /* spotless:on */

        override fun hashCode(): Int = hashCode

        override fun toString() =
            "Source{_typename=$_typename, categories=$categories, key=$key, versionId=$versionId, additionalProperties=$additionalProperties}"
    }

    /** The message delivery status. */
    class Status @JsonCreator private constructor(private val value: JsonField<String>) : Enum {

        /**
         * Returns this class instance's raw value.
         *
         * This is usually only useful if this instance was deserialized from data that doesn't
         * match any known member, and you want to know that value. For example, if the SDK is on an
         * older version than the API, then the API may respond with new members that the SDK is
         * unaware of.
         */
        @com.fasterxml.jackson.annotation.JsonValue fun _value(): JsonField<String> = value

        companion object {

            @JvmField val QUEUED = of("queued")

            @JvmField val SENT = of("sent")

            @JvmField val DELIVERED = of("delivered")

            @JvmField val DELIVERY_ATTEMPTED = of("delivery_attempted")

            @JvmField val UNDELIVERED = of("undelivered")

            @JvmField val NOT_SENT = of("not_sent")

            @JvmField val BOUNCED = of("bounced")

            @JvmStatic fun of(value: String) = Status(JsonField.of(value))
        }

        /** An enum containing [Status]'s known values. */
        enum class Known {
            QUEUED,
            SENT,
            DELIVERED,
            DELIVERY_ATTEMPTED,
            UNDELIVERED,
            NOT_SENT,
            BOUNCED,
        }

        /**
         * An enum containing [Status]'s known values, as well as an [_UNKNOWN] member.
         *
         * An instance of [Status] can contain an unknown value in a couple of cases:
         * - It was deserialized from data that doesn't match any known member. For example, if the
         *   SDK is on an older version than the API, then the API may respond with new members that
         *   the SDK is unaware of.
         * - It was constructed with an arbitrary value using the [of] method.
         */
        enum class Value {
            QUEUED,
            SENT,
            DELIVERED,
            DELIVERY_ATTEMPTED,
            UNDELIVERED,
            NOT_SENT,
            BOUNCED,
            /** An enum member indicating that [Status] was instantiated with an unknown value. */
            _UNKNOWN,
        }

        /**
         * Returns an enum member corresponding to this class instance's value, or [Value._UNKNOWN]
         * if the class was instantiated with an unknown value.
         *
         * Use the [known] method instead if you're certain the value is always known or if you want
         * to throw for the unknown case.
         */
        fun value(): Value =
            when (this) {
                QUEUED -> Value.QUEUED
                SENT -> Value.SENT
                DELIVERED -> Value.DELIVERED
                DELIVERY_ATTEMPTED -> Value.DELIVERY_ATTEMPTED
                UNDELIVERED -> Value.UNDELIVERED
                NOT_SENT -> Value.NOT_SENT
                BOUNCED -> Value.BOUNCED
                else -> Value._UNKNOWN
            }

        /**
         * Returns an enum member corresponding to this class instance's value.
         *
         * Use the [value] method instead if you're uncertain the value is always known and don't
         * want to throw for the unknown case.
         *
         * @throws KnockInvalidDataException if this class instance's value is a not a known member.
         */
        fun known(): Known =
            when (this) {
                QUEUED -> Known.QUEUED
                SENT -> Known.SENT
                DELIVERED -> Known.DELIVERED
                DELIVERY_ATTEMPTED -> Known.DELIVERY_ATTEMPTED
                UNDELIVERED -> Known.UNDELIVERED
                NOT_SENT -> Known.NOT_SENT
                BOUNCED -> Known.BOUNCED
                else -> throw KnockInvalidDataException("Unknown Status: $value")
            }

        /**
         * Returns this class instance's primitive wire representation.
         *
         * This differs from the [toString] method because that method is primarily for debugging
         * and generally doesn't throw.
         *
         * @throws KnockInvalidDataException if this class instance's value does not have the
         *   expected primitive type.
         */
        fun asString(): String =
            _value().asString().orElseThrow { KnockInvalidDataException("Value is not a String") }

        private var validated: Boolean = false

        fun validate(): Status = apply {
            if (validated) {
                return@apply
            }

            known()
            validated = true
        }

        fun isValid(): Boolean =
            try {
                validate()
                true
            } catch (e: KnockInvalidDataException) {
                false
            }

        /**
         * Returns a score indicating how many valid values are contained in this object
         * recursively.
         *
         * Used for best match union deserialization.
         */
        @JvmSynthetic internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

        override fun equals(other: Any?): Boolean {
            if (this === other) {
                return true
            }

            return /* spotless:off */ other is Status && value == other.value /* spotless:on */
        }

        override fun hashCode() = value.hashCode()

        override fun toString() = value.toString()
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) {
            return true
        }

        return /* spotless:off */ other is Message && id == other.id && _typename == other._typename && actors == other.actors && archivedAt == other.archivedAt && channelId == other.channelId && clickedAt == other.clickedAt && data == other.data && engagementStatuses == other.engagementStatuses && insertedAt == other.insertedAt && interactedAt == other.interactedAt && linkClickedAt == other.linkClickedAt && metadata == other.metadata && readAt == other.readAt && recipient == other.recipient && scheduledAt == other.scheduledAt && seenAt == other.seenAt && source == other.source && status == other.status && tenant == other.tenant && updatedAt == other.updatedAt && workflow == other.workflow && additionalProperties == other.additionalProperties /* spotless:on */
    }

    /* spotless:off */
    private val hashCode: Int by lazy { Objects.hash(id, _typename, actors, archivedAt, channelId, clickedAt, data, engagementStatuses, insertedAt, interactedAt, linkClickedAt, metadata, readAt, recipient, scheduledAt, seenAt, source, status, tenant, updatedAt, workflow, additionalProperties) }
    /* spotless:on */

    override fun hashCode(): Int = hashCode

    override fun toString() =
        "Message{id=$id, _typename=$_typename, actors=$actors, archivedAt=$archivedAt, channelId=$channelId, clickedAt=$clickedAt, data=$data, engagementStatuses=$engagementStatuses, insertedAt=$insertedAt, interactedAt=$interactedAt, linkClickedAt=$linkClickedAt, metadata=$metadata, readAt=$readAt, recipient=$recipient, scheduledAt=$scheduledAt, seenAt=$seenAt, source=$source, status=$status, tenant=$tenant, updatedAt=$updatedAt, workflow=$workflow, additionalProperties=$additionalProperties}"
}
