/*
 * Kntrl API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 0.10.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package app.kntrl.client.openapi.model;

import java.util.Objects;
import java.util.Arrays;
import app.kntrl.client.openapi.model.PasswordHistoryCfg;
import app.kntrl.client.openapi.model.PasswordStrengthRequirements;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import app.kntrl.client.openapi.infra.JSON;

/**
 * Password authentication. To enable this auth set auth name to \&quot;password\&quot; or use \&quot;builtin\&quot;: \&quot;password\&quot; param.
 */
@ApiModel(description = "Password authentication. To enable this auth set auth name to \"password\" or use \"builtin\": \"password\" param.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class PasswordAuthCfg {
  public static final String SERIALIZED_NAME_REQUIRES_AUTH = "requiresAuth";
  @SerializedName(SERIALIZED_NAME_REQUIRES_AUTH)
  private List<List<String>> requiresAuth = null;

  public static final String SERIALIZED_NAME_SKIP_ON_FAIL = "skipOnFail";
  @SerializedName(SERIALIZED_NAME_SKIP_ON_FAIL)
  private Boolean skipOnFail = false;

  public static final String SERIALIZED_NAME_RATE_LIMITER = "rateLimiter";
  @SerializedName(SERIALIZED_NAME_RATE_LIMITER)
  private String rateLimiter;

  public static final String SERIALIZED_NAME_BURN_QUOTA = "burnQuota";
  @SerializedName(SERIALIZED_NAME_BURN_QUOTA)
  private Double burnQuota = 0.0d;

  public static final String SERIALIZED_NAME_MAX_LENGTH = "maxLength";
  @SerializedName(SERIALIZED_NAME_MAX_LENGTH)
  private Integer maxLength = 256;

  public static final String SERIALIZED_NAME_MIN_LENGTH = "minLength";
  @SerializedName(SERIALIZED_NAME_MIN_LENGTH)
  private Integer minLength = 6;

  public static final String SERIALIZED_NAME_REQUIRE_NUMBER = "requireNumber";
  @SerializedName(SERIALIZED_NAME_REQUIRE_NUMBER)
  private Boolean requireNumber = false;

  public static final String SERIALIZED_NAME_REQUIRE_SYMBOL = "requireSymbol";
  @SerializedName(SERIALIZED_NAME_REQUIRE_SYMBOL)
  private Boolean requireSymbol = false;

  public static final String SERIALIZED_NAME_REQUIRE_UPPER_CASE = "requireUpperCase";
  @SerializedName(SERIALIZED_NAME_REQUIRE_UPPER_CASE)
  private Boolean requireUpperCase = false;

  public static final String SERIALIZED_NAME_FORBID_COMMON_PASSWORDS = "forbidCommonPasswords";
  @SerializedName(SERIALIZED_NAME_FORBID_COMMON_PASSWORDS)
  private Boolean forbidCommonPasswords = false;

  public static final String SERIALIZED_NAME_FORBID_LOGIN_AS_PASSWORD = "forbidLoginAsPassword";
  @SerializedName(SERIALIZED_NAME_FORBID_LOGIN_AS_PASSWORD)
  private Boolean forbidLoginAsPassword = false;

  public static final String SERIALIZED_NAME_FORBID_REUSING_PASSWORD = "forbidReusingPassword";
  @SerializedName(SERIALIZED_NAME_FORBID_REUSING_PASSWORD)
  private PasswordHistoryCfg forbidReusingPassword;

  public static final String SERIALIZED_NAME_STRENGTH = "strength";
  @SerializedName(SERIALIZED_NAME_STRENGTH)
  private Map<String, PasswordStrengthRequirements> strength = null;

  public PasswordAuthCfg() {
  }

  public PasswordAuthCfg requiresAuth(List<List<String>> requiresAuth) {
    
    this.requiresAuth = requiresAuth;
    return this;
  }

  public PasswordAuthCfg addRequiresAuthItem(List<String> requiresAuthItem) {
    if (this.requiresAuth == null) {
      this.requiresAuth = new ArrayList<>();
    }
    this.requiresAuth.add(requiresAuthItem);
    return this;
  }

   /**
   * If this is not null, app forbids to add this auth until listed auth enabled. - if this a string -&gt; require specified auth to be enabled before this. - array of strings -&gt; require any of listed auths to be enabled - array of arrays of strings -&gt; works as &#x60;[ [ \&quot;auth1\&quot; and \&quot;auth2\&quot; ] or [ \&quot;auth1\&quot; and \&quot;auth2\&quot; ] ]&#x60;
   * @return requiresAuth
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If this is not null, app forbids to add this auth until listed auth enabled. - if this a string -> require specified auth to be enabled before this. - array of strings -> require any of listed auths to be enabled - array of arrays of strings -> works as `[ [ \"auth1\" and \"auth2\" ] or [ \"auth1\" and \"auth2\" ] ]`")

  public List<List<String>> getRequiresAuth() {
    return requiresAuth;
  }


  public void setRequiresAuth(List<List<String>> requiresAuth) {
    this.requiresAuth = requiresAuth;
  }


  public PasswordAuthCfg skipOnFail(Boolean skipOnFail) {
    
    this.skipOnFail = skipOnFail;
    return this;
  }

   /**
   * When this is set to true app will attempt next auth in case of error on current. It&#39;s works good with IP auth. User can provide both IP auth request and SMS auth request. And SMS will be executed only when IP auth is failed. If set to false any error on this auth will stop the whole request execution.
   * @return skipOnFail
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "When this is set to true app will attempt next auth in case of error on current. It's works good with IP auth. User can provide both IP auth request and SMS auth request. And SMS will be executed only when IP auth is failed. If set to false any error on this auth will stop the whole request execution.")

  public Boolean getSkipOnFail() {
    return skipOnFail;
  }


  public void setSkipOnFail(Boolean skipOnFail) {
    this.skipOnFail = skipOnFail;
  }


  public PasswordAuthCfg rateLimiter(String rateLimiter) {
    
    this.rateLimiter = rateLimiter;
    return this;
  }

   /**
   * Apply rate limiter for this auth.
   * @return rateLimiter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Apply rate limiter for this auth.")

  public String getRateLimiter() {
    return rateLimiter;
  }


  public void setRateLimiter(String rateLimiter) {
    this.rateLimiter = rateLimiter;
  }


  public PasswordAuthCfg burnQuota(Double burnQuota) {
    
    this.burnQuota = burnQuota;
    return this;
  }

   /**
   * Every auth execution will burn this amount of quota. Takes place only when rate limiter is specified
   * @return burnQuota
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Every auth execution will burn this amount of quota. Takes place only when rate limiter is specified")

  public Double getBurnQuota() {
    return burnQuota;
  }


  public void setBurnQuota(Double burnQuota) {
    this.burnQuota = burnQuota;
  }


  public PasswordAuthCfg maxLength(Integer maxLength) {
    
    this.maxLength = maxLength;
    return this;
  }

   /**
   * Max allowed Length of the password.
   * @return maxLength
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Max allowed Length of the password.")

  public Integer getMaxLength() {
    return maxLength;
  }


  public void setMaxLength(Integer maxLength) {
    this.maxLength = maxLength;
  }


  public PasswordAuthCfg minLength(Integer minLength) {
    
    this.minLength = minLength;
    return this;
  }

   /**
   * Minimal length of password
   * @return minLength
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Minimal length of password")

  public Integer getMinLength() {
    return minLength;
  }


  public void setMinLength(Integer minLength) {
    this.minLength = minLength;
  }


  public PasswordAuthCfg requireNumber(Boolean requireNumber) {
    
    this.requireNumber = requireNumber;
    return this;
  }

   /**
   * Require password to contain at least one digit.
   * @return requireNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Require password to contain at least one digit.")

  public Boolean getRequireNumber() {
    return requireNumber;
  }


  public void setRequireNumber(Boolean requireNumber) {
    this.requireNumber = requireNumber;
  }


  public PasswordAuthCfg requireSymbol(Boolean requireSymbol) {
    
    this.requireSymbol = requireSymbol;
    return this;
  }

   /**
   * Require password to contain at least one symbol e.g. @, !, &amp;...
   * @return requireSymbol
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Require password to contain at least one symbol e.g. @, !, &...")

  public Boolean getRequireSymbol() {
    return requireSymbol;
  }


  public void setRequireSymbol(Boolean requireSymbol) {
    this.requireSymbol = requireSymbol;
  }


  public PasswordAuthCfg requireUpperCase(Boolean requireUpperCase) {
    
    this.requireUpperCase = requireUpperCase;
    return this;
  }

   /**
   * This requires password to contain both lowercase and uppercase letters.
   * @return requireUpperCase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "This requires password to contain both lowercase and uppercase letters.")

  public Boolean getRequireUpperCase() {
    return requireUpperCase;
  }


  public void setRequireUpperCase(Boolean requireUpperCase) {
    this.requireUpperCase = requireUpperCase;
  }


  public PasswordAuthCfg forbidCommonPasswords(Boolean forbidCommonPasswords) {
    
    this.forbidCommonPasswords = forbidCommonPasswords;
    return this;
  }

   /**
   * Password will be checked against table 1,000,000 of most overused passwords.
   * @return forbidCommonPasswords
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Password will be checked against table 1,000,000 of most overused passwords.")

  public Boolean getForbidCommonPasswords() {
    return forbidCommonPasswords;
  }


  public void setForbidCommonPasswords(Boolean forbidCommonPasswords) {
    this.forbidCommonPasswords = forbidCommonPasswords;
  }


  public PasswordAuthCfg forbidLoginAsPassword(Boolean forbidLoginAsPassword) {
    
    this.forbidLoginAsPassword = forbidLoginAsPassword;
    return this;
  }

   /**
   * Rejects passwords that match username, email, anything that used as a login according to logins config.
   * @return forbidLoginAsPassword
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Rejects passwords that match username, email, anything that used as a login according to logins config.")

  public Boolean getForbidLoginAsPassword() {
    return forbidLoginAsPassword;
  }


  public void setForbidLoginAsPassword(Boolean forbidLoginAsPassword) {
    this.forbidLoginAsPassword = forbidLoginAsPassword;
  }


  public PasswordAuthCfg forbidReusingPassword(PasswordHistoryCfg forbidReusingPassword) {
    
    this.forbidReusingPassword = forbidReusingPassword;
    return this;
  }

   /**
   * Get forbidReusingPassword
   * @return forbidReusingPassword
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public PasswordHistoryCfg getForbidReusingPassword() {
    return forbidReusingPassword;
  }


  public void setForbidReusingPassword(PasswordHistoryCfg forbidReusingPassword) {
    this.forbidReusingPassword = forbidReusingPassword;
  }


  public PasswordAuthCfg strength(Map<String, PasswordStrengthRequirements> strength) {
    
    this.strength = strength;
    return this;
  }

  public PasswordAuthCfg putStrengthItem(String key, PasswordStrengthRequirements strengthItem) {
    if (this.strength == null) {
      this.strength = new HashMap<>();
    }
    this.strength.put(key, strengthItem);
    return this;
  }

   /**
   * Allows to calculate password strength based on mentioned criteria. Requirements will be checked one by one until first failed. 
   * @return strength
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Allows to calculate password strength based on mentioned criteria. Requirements will be checked one by one until first failed. ")

  public Map<String, PasswordStrengthRequirements> getStrength() {
    return strength;
  }


  public void setStrength(Map<String, PasswordStrengthRequirements> strength) {
    this.strength = strength;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public PasswordAuthCfg putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PasswordAuthCfg passwordAuthCfg = (PasswordAuthCfg) o;
    return Objects.equals(this.requiresAuth, passwordAuthCfg.requiresAuth) &&
        Objects.equals(this.skipOnFail, passwordAuthCfg.skipOnFail) &&
        Objects.equals(this.rateLimiter, passwordAuthCfg.rateLimiter) &&
        Objects.equals(this.burnQuota, passwordAuthCfg.burnQuota) &&
        Objects.equals(this.maxLength, passwordAuthCfg.maxLength) &&
        Objects.equals(this.minLength, passwordAuthCfg.minLength) &&
        Objects.equals(this.requireNumber, passwordAuthCfg.requireNumber) &&
        Objects.equals(this.requireSymbol, passwordAuthCfg.requireSymbol) &&
        Objects.equals(this.requireUpperCase, passwordAuthCfg.requireUpperCase) &&
        Objects.equals(this.forbidCommonPasswords, passwordAuthCfg.forbidCommonPasswords) &&
        Objects.equals(this.forbidLoginAsPassword, passwordAuthCfg.forbidLoginAsPassword) &&
        Objects.equals(this.forbidReusingPassword, passwordAuthCfg.forbidReusingPassword) &&
        Objects.equals(this.strength, passwordAuthCfg.strength)&&
        Objects.equals(this.additionalProperties, passwordAuthCfg.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requiresAuth, skipOnFail, rateLimiter, burnQuota, maxLength, minLength, requireNumber, requireSymbol, requireUpperCase, forbidCommonPasswords, forbidLoginAsPassword, forbidReusingPassword, strength, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PasswordAuthCfg {\n");
    sb.append("    requiresAuth: ").append(toIndentedString(requiresAuth)).append("\n");
    sb.append("    skipOnFail: ").append(toIndentedString(skipOnFail)).append("\n");
    sb.append("    rateLimiter: ").append(toIndentedString(rateLimiter)).append("\n");
    sb.append("    burnQuota: ").append(toIndentedString(burnQuota)).append("\n");
    sb.append("    maxLength: ").append(toIndentedString(maxLength)).append("\n");
    sb.append("    minLength: ").append(toIndentedString(minLength)).append("\n");
    sb.append("    requireNumber: ").append(toIndentedString(requireNumber)).append("\n");
    sb.append("    requireSymbol: ").append(toIndentedString(requireSymbol)).append("\n");
    sb.append("    requireUpperCase: ").append(toIndentedString(requireUpperCase)).append("\n");
    sb.append("    forbidCommonPasswords: ").append(toIndentedString(forbidCommonPasswords)).append("\n");
    sb.append("    forbidLoginAsPassword: ").append(toIndentedString(forbidLoginAsPassword)).append("\n");
    sb.append("    forbidReusingPassword: ").append(toIndentedString(forbidReusingPassword)).append("\n");
    sb.append("    strength: ").append(toIndentedString(strength)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("requiresAuth");
    openapiFields.add("skipOnFail");
    openapiFields.add("rateLimiter");
    openapiFields.add("burnQuota");
    openapiFields.add("maxLength");
    openapiFields.add("minLength");
    openapiFields.add("requireNumber");
    openapiFields.add("requireSymbol");
    openapiFields.add("requireUpperCase");
    openapiFields.add("forbidCommonPasswords");
    openapiFields.add("forbidLoginAsPassword");
    openapiFields.add("forbidReusingPassword");
    openapiFields.add("strength");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to PasswordAuthCfg
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (PasswordAuthCfg.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in PasswordAuthCfg is not found in the empty JSON string", PasswordAuthCfg.openapiRequiredFields.toString()));
        }
      }
      // ensure the json data is an array
      if ((jsonObj.get("requiresAuth") != null && !jsonObj.get("requiresAuth").isJsonNull()) && !jsonObj.get("requiresAuth").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `requiresAuth` to be an array in the JSON string but got `%s`", jsonObj.get("requiresAuth").toString()));
      }
      if ((jsonObj.get("rateLimiter") != null && !jsonObj.get("rateLimiter").isJsonNull()) && !jsonObj.get("rateLimiter").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `rateLimiter` to be a primitive type in the JSON string but got `%s`", jsonObj.get("rateLimiter").toString()));
      }
      // validate the optional field `forbidReusingPassword`
      if (jsonObj.get("forbidReusingPassword") != null && !jsonObj.get("forbidReusingPassword").isJsonNull()) {
        PasswordHistoryCfg.validateJsonObject(jsonObj.getAsJsonObject("forbidReusingPassword"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PasswordAuthCfg.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PasswordAuthCfg' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PasswordAuthCfg> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PasswordAuthCfg.class));

       return (TypeAdapter<T>) new TypeAdapter<PasswordAuthCfg>() {
           @Override
           public void write(JsonWriter out, PasswordAuthCfg value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public PasswordAuthCfg read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             PasswordAuthCfg instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PasswordAuthCfg given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PasswordAuthCfg
  * @throws IOException if the JSON string is invalid with respect to PasswordAuthCfg
  */
  public static PasswordAuthCfg fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PasswordAuthCfg.class);
  }

 /**
  * Convert an instance of PasswordAuthCfg to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

