/*
 * Kntrl API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 0.10.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package app.kntrl.client.openapi.model;

import java.util.Objects;
import java.util.Arrays;
import app.kntrl.client.openapi.model.CodeCfg;
import app.kntrl.client.openapi.model.OAuthCfgExchangeAuthCode;
import app.kntrl.client.openapi.model.OAuthCfgUserInfo;
import app.kntrl.client.openapi.model.PasswordHistoryCfg;
import app.kntrl.client.openapi.model.PasswordStrengthRequirements;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import app.kntrl.client.openapi.infra.JSON;

/**
 * ShAppCfgAuthsValue
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ShAppCfgAuthsValue {
  public static final String SERIALIZED_NAME_REMOTE = "remote";
  @SerializedName(SERIALIZED_NAME_REMOTE)
  private String remote;

  public static final String SERIALIZED_NAME_REQUIRES_AUTH = "requiresAuth";
  @SerializedName(SERIALIZED_NAME_REQUIRES_AUTH)
  private List<List<String>> requiresAuth = null;

  public static final String SERIALIZED_NAME_SKIP_ON_FAIL = "skipOnFail";
  @SerializedName(SERIALIZED_NAME_SKIP_ON_FAIL)
  private Boolean skipOnFail = false;

  public static final String SERIALIZED_NAME_RATE_LIMITER = "rateLimiter";
  @SerializedName(SERIALIZED_NAME_RATE_LIMITER)
  private String rateLimiter;

  public static final String SERIALIZED_NAME_BURN_QUOTA = "burnQuota";
  @SerializedName(SERIALIZED_NAME_BURN_QUOTA)
  private Double burnQuota = 0.0d;

  public static final String SERIALIZED_NAME_QUERY = "query";
  @SerializedName(SERIALIZED_NAME_QUERY)
  private Map<String, String> query = null;

  public static final String SERIALIZED_NAME_HEADERS = "headers";
  @SerializedName(SERIALIZED_NAME_HEADERS)
  private Map<String, String> headers = null;

  public static final String SERIALIZED_NAME_CODE = "code";
  @SerializedName(SERIALIZED_NAME_CODE)
  private CodeCfg code;

  public static final String SERIALIZED_NAME_CODE_TTL = "codeTtl";
  @SerializedName(SERIALIZED_NAME_CODE_TTL)
  private String codeTtl = "10m";

  public static final String SERIALIZED_NAME_SCOPES = "scopes";
  @SerializedName(SERIALIZED_NAME_SCOPES)
  private List<String> scopes = null;

  public static final String SERIALIZED_NAME_SERVER = "server";
  @SerializedName(SERIALIZED_NAME_SERVER)
  private String server;

  public static final String SERIALIZED_NAME_SENDER = "sender";
  @SerializedName(SERIALIZED_NAME_SENDER)
  private String sender;

  public static final String SERIALIZED_NAME_USERNAME = "username";
  @SerializedName(SERIALIZED_NAME_USERNAME)
  private String username;

  public static final String SERIALIZED_NAME_PASSWORD = "password";
  @SerializedName(SERIALIZED_NAME_PASSWORD)
  private String password;

  public static final String SERIALIZED_NAME_CONFIRMATION_URL = "confirmationUrl";
  @SerializedName(SERIALIZED_NAME_CONFIRMATION_URL)
  private String confirmationUrl;

  public static final String SERIALIZED_NAME_TEMPLATES = "templates";
  @SerializedName(SERIALIZED_NAME_TEMPLATES)
  private Map<String, String> templates = null;

  public static final String SERIALIZED_NAME_TEMPLATE_PARAMS = "templateParams";
  @SerializedName(SERIALIZED_NAME_TEMPLATE_PARAMS)
  private Map<String, Object> templateParams = null;

  public static final String SERIALIZED_NAME_IP_BYTES_TO_IGNORE = "ipBytesToIgnore";
  @SerializedName(SERIALIZED_NAME_IP_BYTES_TO_IGNORE)
  private Integer ipBytesToIgnore = 0;

  public static final String SERIALIZED_NAME_HISTORY_SIZE = "historySize";
  @SerializedName(SERIALIZED_NAME_HISTORY_SIZE)
  private Integer historySize = 10;

  public static final String SERIALIZED_NAME_EXCHANGE_AUTH_CODE = "exchangeAuthCode";
  @SerializedName(SERIALIZED_NAME_EXCHANGE_AUTH_CODE)
  private OAuthCfgExchangeAuthCode exchangeAuthCode;

  public static final String SERIALIZED_NAME_USER_INFO = "userInfo";
  @SerializedName(SERIALIZED_NAME_USER_INFO)
  private OAuthCfgUserInfo userInfo;

  public static final String SERIALIZED_NAME_EXTRACT_LOGIN = "extractLogin";
  @SerializedName(SERIALIZED_NAME_EXTRACT_LOGIN)
  private String extractLogin;

  public static final String SERIALIZED_NAME_EXTRACT_PUBLIC_DATA = "extractPublicData";
  @SerializedName(SERIALIZED_NAME_EXTRACT_PUBLIC_DATA)
  private Map<String, String> extractPublicData = null;

  public static final String SERIALIZED_NAME_MAX_LENGTH = "maxLength";
  @SerializedName(SERIALIZED_NAME_MAX_LENGTH)
  private Integer maxLength = 256;

  public static final String SERIALIZED_NAME_MIN_LENGTH = "minLength";
  @SerializedName(SERIALIZED_NAME_MIN_LENGTH)
  private Integer minLength = 3;

  public static final String SERIALIZED_NAME_REQUIRE_NUMBER = "requireNumber";
  @SerializedName(SERIALIZED_NAME_REQUIRE_NUMBER)
  private Boolean requireNumber = false;

  public static final String SERIALIZED_NAME_REQUIRE_SYMBOL = "requireSymbol";
  @SerializedName(SERIALIZED_NAME_REQUIRE_SYMBOL)
  private Boolean requireSymbol = false;

  public static final String SERIALIZED_NAME_REQUIRE_UPPER_CASE = "requireUpperCase";
  @SerializedName(SERIALIZED_NAME_REQUIRE_UPPER_CASE)
  private Boolean requireUpperCase = false;

  public static final String SERIALIZED_NAME_FORBID_COMMON_PASSWORDS = "forbidCommonPasswords";
  @SerializedName(SERIALIZED_NAME_FORBID_COMMON_PASSWORDS)
  private Boolean forbidCommonPasswords = false;

  public static final String SERIALIZED_NAME_FORBID_LOGIN_AS_PASSWORD = "forbidLoginAsPassword";
  @SerializedName(SERIALIZED_NAME_FORBID_LOGIN_AS_PASSWORD)
  private Boolean forbidLoginAsPassword = false;

  public static final String SERIALIZED_NAME_FORBID_REUSING_PASSWORD = "forbidReusingPassword";
  @SerializedName(SERIALIZED_NAME_FORBID_REUSING_PASSWORD)
  private PasswordHistoryCfg forbidReusingPassword;

  public static final String SERIALIZED_NAME_STRENGTH = "strength";
  @SerializedName(SERIALIZED_NAME_STRENGTH)
  private Map<String, PasswordStrengthRequirements> strength = null;

  public static final String SERIALIZED_NAME_LOWERCASE = "lowercase";
  @SerializedName(SERIALIZED_NAME_LOWERCASE)
  private Boolean lowercase = true;

  public static final String SERIALIZED_NAME_REMOVE_SYMBOLS = "removeSymbols";
  @SerializedName(SERIALIZED_NAME_REMOVE_SYMBOLS)
  private Boolean removeSymbols = true;

  public static final String SERIALIZED_NAME_REMOVE_SPACES = "removeSpaces";
  @SerializedName(SERIALIZED_NAME_REMOVE_SPACES)
  private Boolean removeSpaces = true;

  public static final String SERIALIZED_NAME_ANSWERS_REQUIRED = "answersRequired";
  @SerializedName(SERIALIZED_NAME_ANSWERS_REQUIRED)
  private Integer answersRequired = 2;

  public static final String SERIALIZED_NAME_MAX_ANSWERS = "maxAnswers";
  @SerializedName(SERIALIZED_NAME_MAX_ANSWERS)
  private Integer maxAnswers = 10;

  public static final String SERIALIZED_NAME_ENCRYPT_KEY = "encryptKey";
  @SerializedName(SERIALIZED_NAME_ENCRYPT_KEY)
  private String encryptKey = "<change_me>";

  public ShAppCfgAuthsValue() {
  }

  public ShAppCfgAuthsValue remote(String remote) {
    
    this.remote = remote;
    return this;
  }

   /**
   * Path to the API that implements plugin.
   * @return remote
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Path to the API that implements plugin.")

  public String getRemote() {
    return remote;
  }


  public void setRemote(String remote) {
    this.remote = remote;
  }


  public ShAppCfgAuthsValue requiresAuth(List<List<String>> requiresAuth) {
    
    this.requiresAuth = requiresAuth;
    return this;
  }

  public ShAppCfgAuthsValue addRequiresAuthItem(List<String> requiresAuthItem) {
    if (this.requiresAuth == null) {
      this.requiresAuth = new ArrayList<>();
    }
    this.requiresAuth.add(requiresAuthItem);
    return this;
  }

   /**
   * If this is not null, app forbids to add this auth until listed auth enabled. - if this a string -&gt; require specified auth to be enabled before this. - array of strings -&gt; require any of listed auths to be enabled - array of arrays of strings -&gt; works as &#x60;[ [ \&quot;auth1\&quot; and \&quot;auth2\&quot; ] or [ \&quot;auth1\&quot; and \&quot;auth2\&quot; ] ]&#x60;
   * @return requiresAuth
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If this is not null, app forbids to add this auth until listed auth enabled. - if this a string -> require specified auth to be enabled before this. - array of strings -> require any of listed auths to be enabled - array of arrays of strings -> works as `[ [ \"auth1\" and \"auth2\" ] or [ \"auth1\" and \"auth2\" ] ]`")

  public List<List<String>> getRequiresAuth() {
    return requiresAuth;
  }


  public void setRequiresAuth(List<List<String>> requiresAuth) {
    this.requiresAuth = requiresAuth;
  }


  public ShAppCfgAuthsValue skipOnFail(Boolean skipOnFail) {
    
    this.skipOnFail = skipOnFail;
    return this;
  }

   /**
   * When this is set to true app will attempt next auth in case of error on current. It&#39;s works good with IP auth. User can provide both IP auth request and SMS auth request. And SMS will be executed only when IP auth is failed. If set to false any error on this auth will stop the whole request execution.
   * @return skipOnFail
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "When this is set to true app will attempt next auth in case of error on current. It's works good with IP auth. User can provide both IP auth request and SMS auth request. And SMS will be executed only when IP auth is failed. If set to false any error on this auth will stop the whole request execution.")

  public Boolean getSkipOnFail() {
    return skipOnFail;
  }


  public void setSkipOnFail(Boolean skipOnFail) {
    this.skipOnFail = skipOnFail;
  }


  public ShAppCfgAuthsValue rateLimiter(String rateLimiter) {
    
    this.rateLimiter = rateLimiter;
    return this;
  }

   /**
   * Apply rate limiter for this auth.
   * @return rateLimiter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Apply rate limiter for this auth.")

  public String getRateLimiter() {
    return rateLimiter;
  }


  public void setRateLimiter(String rateLimiter) {
    this.rateLimiter = rateLimiter;
  }


  public ShAppCfgAuthsValue burnQuota(Double burnQuota) {
    
    this.burnQuota = burnQuota;
    return this;
  }

   /**
   * Every auth execution will burn this amount of quota. Takes place only when rate limiter is specified
   * @return burnQuota
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Every auth execution will burn this amount of quota. Takes place only when rate limiter is specified")

  public Double getBurnQuota() {
    return burnQuota;
  }


  public void setBurnQuota(Double burnQuota) {
    this.burnQuota = burnQuota;
  }


  public ShAppCfgAuthsValue query(Map<String, String> query) {
    
    this.query = query;
    return this;
  }

  public ShAppCfgAuthsValue putQueryItem(String key, String queryItem) {
    if (this.query == null) {
      this.query = new HashMap<>();
    }
    this.query.put(key, queryItem);
    return this;
  }

   /**
   * Add query params after &#x60;?&#x60; symbol in url. 
   * @return query
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Add query params after `?` symbol in url. ")

  public Map<String, String> getQuery() {
    return query;
  }


  public void setQuery(Map<String, String> query) {
    this.query = query;
  }


  public ShAppCfgAuthsValue headers(Map<String, String> headers) {
    
    this.headers = headers;
    return this;
  }

  public ShAppCfgAuthsValue putHeadersItem(String key, String headersItem) {
    if (this.headers == null) {
      this.headers = new HashMap<>();
    }
    this.headers.put(key, headersItem);
    return this;
  }

   /**
   * Add headers to request. 
   * @return headers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Add headers to request. ")

  public Map<String, String> getHeaders() {
    return headers;
  }


  public void setHeaders(Map<String, String> headers) {
    this.headers = headers;
  }


  public ShAppCfgAuthsValue code(CodeCfg code) {
    
    this.code = code;
    return this;
  }

   /**
   * Get code
   * @return code
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public CodeCfg getCode() {
    return code;
  }


  public void setCode(CodeCfg code) {
    this.code = code;
  }


  public ShAppCfgAuthsValue codeTtl(String codeTtl) {
    
    this.codeTtl = codeTtl;
    return this;
  }

   /**
   * Authorization code lifetime. 
   * @return codeTtl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Authorization code lifetime. ")

  public String getCodeTtl() {
    return codeTtl;
  }


  public void setCodeTtl(String codeTtl) {
    this.codeTtl = codeTtl;
  }


  public ShAppCfgAuthsValue scopes(List<String> scopes) {
    
    this.scopes = scopes;
    return this;
  }

  public ShAppCfgAuthsValue addScopesItem(String scopesItem) {
    if (this.scopes == null) {
      this.scopes = new ArrayList<>();
    }
    this.scopes.add(scopesItem);
    return this;
  }

   /**
   * Get scopes
   * @return scopes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getScopes() {
    return scopes;
  }


  public void setScopes(List<String> scopes) {
    this.scopes = scopes;
  }


  public ShAppCfgAuthsValue server(String server) {
    
    this.server = server;
    return this;
  }

   /**
   * Email server address/IP.
   * @return server
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Email server address/IP.")

  public String getServer() {
    return server;
  }


  public void setServer(String server) {
    this.server = server;
  }


  public ShAppCfgAuthsValue sender(String sender) {
    
    this.sender = sender;
    return this;
  }

   /**
   * Email address of sender.
   * @return sender
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Email address of sender.")

  public String getSender() {
    return sender;
  }


  public void setSender(String sender) {
    this.sender = sender;
  }


  public ShAppCfgAuthsValue username(String username) {
    
    this.username = username;
    return this;
  }

   /**
   * SMTP username.
   * @return username
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "SMTP username.")

  public String getUsername() {
    return username;
  }


  public void setUsername(String username) {
    this.username = username;
  }


  public ShAppCfgAuthsValue password(String password) {
    
    this.password = password;
    return this;
  }

   /**
   * SMTP password.
   * @return password
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "SMTP password.")

  public String getPassword() {
    return password;
  }


  public void setPassword(String password) {
    this.password = password;
  }


  public ShAppCfgAuthsValue confirmationUrl(String confirmationUrl) {
    
    this.confirmationUrl = confirmationUrl;
    return this;
  }

   /**
   * If not null, server will create template param &#x60;confirmationUrl&#x60; that will contain query parameters with confirmation code, session id, etc.
   * @return confirmationUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If not null, server will create template param `confirmationUrl` that will contain query parameters with confirmation code, session id, etc.")

  public String getConfirmationUrl() {
    return confirmationUrl;
  }


  public void setConfirmationUrl(String confirmationUrl) {
    this.confirmationUrl = confirmationUrl;
  }


  public ShAppCfgAuthsValue templates(Map<String, String> templates) {
    
    this.templates = templates;
    return this;
  }

  public ShAppCfgAuthsValue putTemplatesItem(String key, String templatesItem) {
    if (this.templates == null) {
      this.templates = new HashMap<>();
    }
    this.templates.put(key, templatesItem);
    return this;
  }

   /**
   * List of email templates. Key - is name of a template (can be used lately on frontend), value - is path to the template. App uses handlebars templates to generate emails. See docs here https://handlebarsjs.com  Email templates receives &#x60;confirmationUrl&#x60;, &#x60;action&#x60;, &#x60;user&#x60;, &#x60;session&#x60;, &#x60;codeId&#x60;, &#x60;code&#x60;, &#x60;codeExpiresInMinutes&#x60;, &#x60;lang&#x60;, &#x60;headers&#x60; as template params, e.g. you can print user id as &#x60;{{user.id}}&#x60;.  Template engine also provides &#x60;i18n&#x60; helper for localisation. E.g. &#x60;{{i18n &#39;confirmationButton&#39; default&#x3D;&#39;Confirm&#39;}}&#x60; searches key &#x60;confirmationButton&#x60; in files specified by &#x60;i18n.dir&#x60; config.  Use &#x60;{{err ERR_CODE msg&#x3D;&#39;Localised message (if null, will be taken from i18n file)&#39; devMsg&#x3D;&#39;dev message&#39;}}&#x60; to raise an error in a template.  It allows setting subject of email using &#x60;title&#x60; html tag, e.g. &#x60;&lt;title&gt;Email subject&lt;/title&gt;&#x60;.  
   * @return templates
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "{\"welcome\":\"./welcome.html.hbs\",\"restoreAccess\":\"./restore.html.hbs\"}", value = "List of email templates. Key - is name of a template (can be used lately on frontend), value - is path to the template. App uses handlebars templates to generate emails. See docs here https://handlebarsjs.com  Email templates receives `confirmationUrl`, `action`, `user`, `session`, `codeId`, `code`, `codeExpiresInMinutes`, `lang`, `headers` as template params, e.g. you can print user id as `{{user.id}}`.  Template engine also provides `i18n` helper for localisation. E.g. `{{i18n 'confirmationButton' default='Confirm'}}` searches key `confirmationButton` in files specified by `i18n.dir` config.  Use `{{err ERR_CODE msg='Localised message (if null, will be taken from i18n file)' devMsg='dev message'}}` to raise an error in a template.  It allows setting subject of email using `title` html tag, e.g. `<title>Email subject</title>`.  ")

  public Map<String, String> getTemplates() {
    return templates;
  }


  public void setTemplates(Map<String, String> templates) {
    this.templates = templates;
  }


  public ShAppCfgAuthsValue templateParams(Map<String, Object> templateParams) {
    
    this.templateParams = templateParams;
    return this;
  }

  public ShAppCfgAuthsValue putTemplateParamsItem(String key, Object templateParamsItem) {
    if (this.templateParams == null) {
      this.templateParams = new HashMap<>();
    }
    this.templateParams.put(key, templateParamsItem);
    return this;
  }

   /**
   * Additional params for templates that can be passed in request. Key - is a name of additional parameter, value - is a default value for this parameter (when no value present in request) 
   * @return templateParams
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Additional params for templates that can be passed in request. Key - is a name of additional parameter, value - is a default value for this parameter (when no value present in request) ")

  public Map<String, Object> getTemplateParams() {
    return templateParams;
  }


  public void setTemplateParams(Map<String, Object> templateParams) {
    this.templateParams = templateParams;
  }


  public ShAppCfgAuthsValue ipBytesToIgnore(Integer ipBytesToIgnore) {
    
    this.ipBytesToIgnore = ipBytesToIgnore;
    return this;
  }

   /**
   * This allows to drop last bytes of IP. So it allows to authenticate factor when ip has rough match, e.g. the same country, same city, or same internet provider.
   * @return ipBytesToIgnore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "This allows to drop last bytes of IP. So it allows to authenticate factor when ip has rough match, e.g. the same country, same city, or same internet provider.")

  public Integer getIpBytesToIgnore() {
    return ipBytesToIgnore;
  }


  public void setIpBytesToIgnore(Integer ipBytesToIgnore) {
    this.ipBytesToIgnore = ipBytesToIgnore;
  }


  public ShAppCfgAuthsValue historySize(Integer historySize) {
    
    this.historySize = historySize;
    return this;
  }

   /**
   * History of IP addresses user used to sign-in. Authenticated when user attempts to sign in with one of stored IPs.
   * @return historySize
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "History of IP addresses user used to sign-in. Authenticated when user attempts to sign in with one of stored IPs.")

  public Integer getHistorySize() {
    return historySize;
  }


  public void setHistorySize(Integer historySize) {
    this.historySize = historySize;
  }


  public ShAppCfgAuthsValue exchangeAuthCode(OAuthCfgExchangeAuthCode exchangeAuthCode) {
    
    this.exchangeAuthCode = exchangeAuthCode;
    return this;
  }

   /**
   * Get exchangeAuthCode
   * @return exchangeAuthCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public OAuthCfgExchangeAuthCode getExchangeAuthCode() {
    return exchangeAuthCode;
  }


  public void setExchangeAuthCode(OAuthCfgExchangeAuthCode exchangeAuthCode) {
    this.exchangeAuthCode = exchangeAuthCode;
  }


  public ShAppCfgAuthsValue userInfo(OAuthCfgUserInfo userInfo) {
    
    this.userInfo = userInfo;
    return this;
  }

   /**
   * Get userInfo
   * @return userInfo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public OAuthCfgUserInfo getUserInfo() {
    return userInfo;
  }


  public void setUserInfo(OAuthCfgUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  public ShAppCfgAuthsValue extractLogin(String extractLogin) {
    
    this.extractLogin = extractLogin;
    return this;
  }

   /**
   * Json path for login in the exchangeAuthCode or userInfo endpoint response. e.g. &#x60;access_token.user.id&#x60; extracts user login from &#x60;{ \&quot;access_token\&quot;: { \&quot;user\&quot;: { \&quot;id\&quot;: \&quot;...\&quot; } } }&#x60; 
   * @return extractLogin
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "access_token.user_id", value = "Json path for login in the exchangeAuthCode or userInfo endpoint response. e.g. `access_token.user.id` extracts user login from `{ \"access_token\": { \"user\": { \"id\": \"...\" } } }` ")

  public String getExtractLogin() {
    return extractLogin;
  }


  public void setExtractLogin(String extractLogin) {
    this.extractLogin = extractLogin;
  }


  public ShAppCfgAuthsValue extractPublicData(Map<String, String> extractPublicData) {
    
    this.extractPublicData = extractPublicData;
    return this;
  }

  public ShAppCfgAuthsValue putExtractPublicDataItem(String key, String extractPublicDataItem) {
    if (this.extractPublicData == null) {
      this.extractPublicData = new HashMap<>();
    }
    this.extractPublicData.put(key, extractPublicDataItem);
    return this;
  }

   /**
   * Can fill public data from the exchangeAuthCode or userInfo endpoint response. 
   * @return extractPublicData
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "{\"photoUrl:\":\"access_token.user_photo_url\",\"name\":\"access_token.full_name\"}", value = "Can fill public data from the exchangeAuthCode or userInfo endpoint response. ")

  public Map<String, String> getExtractPublicData() {
    return extractPublicData;
  }


  public void setExtractPublicData(Map<String, String> extractPublicData) {
    this.extractPublicData = extractPublicData;
  }


  public ShAppCfgAuthsValue maxLength(Integer maxLength) {
    
    this.maxLength = maxLength;
    return this;
  }

   /**
   * Max length of answer.
   * @return maxLength
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Max length of answer.")

  public Integer getMaxLength() {
    return maxLength;
  }


  public void setMaxLength(Integer maxLength) {
    this.maxLength = maxLength;
  }


  public ShAppCfgAuthsValue minLength(Integer minLength) {
    
    this.minLength = minLength;
    return this;
  }

   /**
   * Min length of answer. Length are checked after all answer transformation.
   * @return minLength
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Min length of answer. Length are checked after all answer transformation.")

  public Integer getMinLength() {
    return minLength;
  }


  public void setMinLength(Integer minLength) {
    this.minLength = minLength;
  }


  public ShAppCfgAuthsValue requireNumber(Boolean requireNumber) {
    
    this.requireNumber = requireNumber;
    return this;
  }

   /**
   * Require password to contain at least one digit.
   * @return requireNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Require password to contain at least one digit.")

  public Boolean getRequireNumber() {
    return requireNumber;
  }


  public void setRequireNumber(Boolean requireNumber) {
    this.requireNumber = requireNumber;
  }


  public ShAppCfgAuthsValue requireSymbol(Boolean requireSymbol) {
    
    this.requireSymbol = requireSymbol;
    return this;
  }

   /**
   * Require password to contain at least one symbol e.g. @, !, &amp;...
   * @return requireSymbol
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Require password to contain at least one symbol e.g. @, !, &...")

  public Boolean getRequireSymbol() {
    return requireSymbol;
  }


  public void setRequireSymbol(Boolean requireSymbol) {
    this.requireSymbol = requireSymbol;
  }


  public ShAppCfgAuthsValue requireUpperCase(Boolean requireUpperCase) {
    
    this.requireUpperCase = requireUpperCase;
    return this;
  }

   /**
   * This requires password to contain both lowercase and uppercase letters.
   * @return requireUpperCase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "This requires password to contain both lowercase and uppercase letters.")

  public Boolean getRequireUpperCase() {
    return requireUpperCase;
  }


  public void setRequireUpperCase(Boolean requireUpperCase) {
    this.requireUpperCase = requireUpperCase;
  }


  public ShAppCfgAuthsValue forbidCommonPasswords(Boolean forbidCommonPasswords) {
    
    this.forbidCommonPasswords = forbidCommonPasswords;
    return this;
  }

   /**
   * Password will be checked against table 1,000,000 of most overused passwords.
   * @return forbidCommonPasswords
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Password will be checked against table 1,000,000 of most overused passwords.")

  public Boolean getForbidCommonPasswords() {
    return forbidCommonPasswords;
  }


  public void setForbidCommonPasswords(Boolean forbidCommonPasswords) {
    this.forbidCommonPasswords = forbidCommonPasswords;
  }


  public ShAppCfgAuthsValue forbidLoginAsPassword(Boolean forbidLoginAsPassword) {
    
    this.forbidLoginAsPassword = forbidLoginAsPassword;
    return this;
  }

   /**
   * Rejects passwords that match username, email, anything that used as a login according to logins config.
   * @return forbidLoginAsPassword
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Rejects passwords that match username, email, anything that used as a login according to logins config.")

  public Boolean getForbidLoginAsPassword() {
    return forbidLoginAsPassword;
  }


  public void setForbidLoginAsPassword(Boolean forbidLoginAsPassword) {
    this.forbidLoginAsPassword = forbidLoginAsPassword;
  }


  public ShAppCfgAuthsValue forbidReusingPassword(PasswordHistoryCfg forbidReusingPassword) {
    
    this.forbidReusingPassword = forbidReusingPassword;
    return this;
  }

   /**
   * Get forbidReusingPassword
   * @return forbidReusingPassword
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public PasswordHistoryCfg getForbidReusingPassword() {
    return forbidReusingPassword;
  }


  public void setForbidReusingPassword(PasswordHistoryCfg forbidReusingPassword) {
    this.forbidReusingPassword = forbidReusingPassword;
  }


  public ShAppCfgAuthsValue strength(Map<String, PasswordStrengthRequirements> strength) {
    
    this.strength = strength;
    return this;
  }

  public ShAppCfgAuthsValue putStrengthItem(String key, PasswordStrengthRequirements strengthItem) {
    if (this.strength == null) {
      this.strength = new HashMap<>();
    }
    this.strength.put(key, strengthItem);
    return this;
  }

   /**
   * Allows to calculate password strength based on mentioned criteria. Requirements will be checked one by one until first failed. 
   * @return strength
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Allows to calculate password strength based on mentioned criteria. Requirements will be checked one by one until first failed. ")

  public Map<String, PasswordStrengthRequirements> getStrength() {
    return strength;
  }


  public void setStrength(Map<String, PasswordStrengthRequirements> strength) {
    this.strength = strength;
  }


  public ShAppCfgAuthsValue lowercase(Boolean lowercase) {
    
    this.lowercase = lowercase;
    return this;
  }

   /**
   * Transform user answer to lowercase letters. This allows user still pass a check when he wrote name or city with different cases. &#x60;false&#x60; means strict match, so \&quot;John\&quot; !&#x3D; \&quot;john\&quot;
   * @return lowercase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Transform user answer to lowercase letters. This allows user still pass a check when he wrote name or city with different cases. `false` means strict match, so \"John\" != \"john\"")

  public Boolean getLowercase() {
    return lowercase;
  }


  public void setLowercase(Boolean lowercase) {
    this.lowercase = lowercase;
  }


  public ShAppCfgAuthsValue removeSymbols(Boolean removeSymbols) {
    
    this.removeSymbols = removeSymbols;
    return this;
  }

   /**
   * Remove all non-letters from user answer.
   * @return removeSymbols
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Remove all non-letters from user answer.")

  public Boolean getRemoveSymbols() {
    return removeSymbols;
  }


  public void setRemoveSymbols(Boolean removeSymbols) {
    this.removeSymbols = removeSymbols;
  }


  public ShAppCfgAuthsValue removeSpaces(Boolean removeSpaces) {
    
    this.removeSpaces = removeSpaces;
    return this;
  }

   /**
   * Remove all spaces from user answer.
   * @return removeSpaces
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Remove all spaces from user answer.")

  public Boolean getRemoveSpaces() {
    return removeSpaces;
  }


  public void setRemoveSpaces(Boolean removeSpaces) {
    this.removeSpaces = removeSpaces;
  }


  public ShAppCfgAuthsValue answersRequired(Integer answersRequired) {
    
    this.answersRequired = answersRequired;
    return this;
  }

   /**
   * Min number of answers required to pass this check.
   * @return answersRequired
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Min number of answers required to pass this check.")

  public Integer getAnswersRequired() {
    return answersRequired;
  }


  public void setAnswersRequired(Integer answersRequired) {
    this.answersRequired = answersRequired;
  }


  public ShAppCfgAuthsValue maxAnswers(Integer maxAnswers) {
    
    this.maxAnswers = maxAnswers;
    return this;
  }

   /**
   * Max answers that user can save.
   * @return maxAnswers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Max answers that user can save.")

  public Integer getMaxAnswers() {
    return maxAnswers;
  }


  public void setMaxAnswers(Integer maxAnswers) {
    this.maxAnswers = maxAnswers;
  }


  public ShAppCfgAuthsValue encryptKey(String encryptKey) {
    
    this.encryptKey = encryptKey;
    return this;
  }

   /**
   * Get encryptKey
   * @return encryptKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getEncryptKey() {
    return encryptKey;
  }


  public void setEncryptKey(String encryptKey) {
    this.encryptKey = encryptKey;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public ShAppCfgAuthsValue putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShAppCfgAuthsValue shAppCfgAuthsValue = (ShAppCfgAuthsValue) o;
    return Objects.equals(this.remote, shAppCfgAuthsValue.remote) &&
        Objects.equals(this.requiresAuth, shAppCfgAuthsValue.requiresAuth) &&
        Objects.equals(this.skipOnFail, shAppCfgAuthsValue.skipOnFail) &&
        Objects.equals(this.rateLimiter, shAppCfgAuthsValue.rateLimiter) &&
        Objects.equals(this.burnQuota, shAppCfgAuthsValue.burnQuota) &&
        Objects.equals(this.query, shAppCfgAuthsValue.query) &&
        Objects.equals(this.headers, shAppCfgAuthsValue.headers) &&
        Objects.equals(this.code, shAppCfgAuthsValue.code) &&
        Objects.equals(this.codeTtl, shAppCfgAuthsValue.codeTtl) &&
        Objects.equals(this.scopes, shAppCfgAuthsValue.scopes) &&
        Objects.equals(this.server, shAppCfgAuthsValue.server) &&
        Objects.equals(this.sender, shAppCfgAuthsValue.sender) &&
        Objects.equals(this.username, shAppCfgAuthsValue.username) &&
        Objects.equals(this.password, shAppCfgAuthsValue.password) &&
        Objects.equals(this.confirmationUrl, shAppCfgAuthsValue.confirmationUrl) &&
        Objects.equals(this.templates, shAppCfgAuthsValue.templates) &&
        Objects.equals(this.templateParams, shAppCfgAuthsValue.templateParams) &&
        Objects.equals(this.ipBytesToIgnore, shAppCfgAuthsValue.ipBytesToIgnore) &&
        Objects.equals(this.historySize, shAppCfgAuthsValue.historySize) &&
        Objects.equals(this.exchangeAuthCode, shAppCfgAuthsValue.exchangeAuthCode) &&
        Objects.equals(this.userInfo, shAppCfgAuthsValue.userInfo) &&
        Objects.equals(this.extractLogin, shAppCfgAuthsValue.extractLogin) &&
        Objects.equals(this.extractPublicData, shAppCfgAuthsValue.extractPublicData) &&
        Objects.equals(this.maxLength, shAppCfgAuthsValue.maxLength) &&
        Objects.equals(this.minLength, shAppCfgAuthsValue.minLength) &&
        Objects.equals(this.requireNumber, shAppCfgAuthsValue.requireNumber) &&
        Objects.equals(this.requireSymbol, shAppCfgAuthsValue.requireSymbol) &&
        Objects.equals(this.requireUpperCase, shAppCfgAuthsValue.requireUpperCase) &&
        Objects.equals(this.forbidCommonPasswords, shAppCfgAuthsValue.forbidCommonPasswords) &&
        Objects.equals(this.forbidLoginAsPassword, shAppCfgAuthsValue.forbidLoginAsPassword) &&
        Objects.equals(this.forbidReusingPassword, shAppCfgAuthsValue.forbidReusingPassword) &&
        Objects.equals(this.strength, shAppCfgAuthsValue.strength) &&
        Objects.equals(this.lowercase, shAppCfgAuthsValue.lowercase) &&
        Objects.equals(this.removeSymbols, shAppCfgAuthsValue.removeSymbols) &&
        Objects.equals(this.removeSpaces, shAppCfgAuthsValue.removeSpaces) &&
        Objects.equals(this.answersRequired, shAppCfgAuthsValue.answersRequired) &&
        Objects.equals(this.maxAnswers, shAppCfgAuthsValue.maxAnswers) &&
        Objects.equals(this.encryptKey, shAppCfgAuthsValue.encryptKey)&&
        Objects.equals(this.additionalProperties, shAppCfgAuthsValue.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(remote, requiresAuth, skipOnFail, rateLimiter, burnQuota, query, headers, code, codeTtl, scopes, server, sender, username, password, confirmationUrl, templates, templateParams, ipBytesToIgnore, historySize, exchangeAuthCode, userInfo, extractLogin, extractPublicData, maxLength, minLength, requireNumber, requireSymbol, requireUpperCase, forbidCommonPasswords, forbidLoginAsPassword, forbidReusingPassword, strength, lowercase, removeSymbols, removeSpaces, answersRequired, maxAnswers, encryptKey, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShAppCfgAuthsValue {\n");
    sb.append("    remote: ").append(toIndentedString(remote)).append("\n");
    sb.append("    requiresAuth: ").append(toIndentedString(requiresAuth)).append("\n");
    sb.append("    skipOnFail: ").append(toIndentedString(skipOnFail)).append("\n");
    sb.append("    rateLimiter: ").append(toIndentedString(rateLimiter)).append("\n");
    sb.append("    burnQuota: ").append(toIndentedString(burnQuota)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    codeTtl: ").append(toIndentedString(codeTtl)).append("\n");
    sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
    sb.append("    server: ").append(toIndentedString(server)).append("\n");
    sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    confirmationUrl: ").append(toIndentedString(confirmationUrl)).append("\n");
    sb.append("    templates: ").append(toIndentedString(templates)).append("\n");
    sb.append("    templateParams: ").append(toIndentedString(templateParams)).append("\n");
    sb.append("    ipBytesToIgnore: ").append(toIndentedString(ipBytesToIgnore)).append("\n");
    sb.append("    historySize: ").append(toIndentedString(historySize)).append("\n");
    sb.append("    exchangeAuthCode: ").append(toIndentedString(exchangeAuthCode)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("    extractLogin: ").append(toIndentedString(extractLogin)).append("\n");
    sb.append("    extractPublicData: ").append(toIndentedString(extractPublicData)).append("\n");
    sb.append("    maxLength: ").append(toIndentedString(maxLength)).append("\n");
    sb.append("    minLength: ").append(toIndentedString(minLength)).append("\n");
    sb.append("    requireNumber: ").append(toIndentedString(requireNumber)).append("\n");
    sb.append("    requireSymbol: ").append(toIndentedString(requireSymbol)).append("\n");
    sb.append("    requireUpperCase: ").append(toIndentedString(requireUpperCase)).append("\n");
    sb.append("    forbidCommonPasswords: ").append(toIndentedString(forbidCommonPasswords)).append("\n");
    sb.append("    forbidLoginAsPassword: ").append(toIndentedString(forbidLoginAsPassword)).append("\n");
    sb.append("    forbidReusingPassword: ").append(toIndentedString(forbidReusingPassword)).append("\n");
    sb.append("    strength: ").append(toIndentedString(strength)).append("\n");
    sb.append("    lowercase: ").append(toIndentedString(lowercase)).append("\n");
    sb.append("    removeSymbols: ").append(toIndentedString(removeSymbols)).append("\n");
    sb.append("    removeSpaces: ").append(toIndentedString(removeSpaces)).append("\n");
    sb.append("    answersRequired: ").append(toIndentedString(answersRequired)).append("\n");
    sb.append("    maxAnswers: ").append(toIndentedString(maxAnswers)).append("\n");
    sb.append("    encryptKey: ").append(toIndentedString(encryptKey)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("remote");
    openapiFields.add("requiresAuth");
    openapiFields.add("skipOnFail");
    openapiFields.add("rateLimiter");
    openapiFields.add("burnQuota");
    openapiFields.add("query");
    openapiFields.add("headers");
    openapiFields.add("code");
    openapiFields.add("codeTtl");
    openapiFields.add("scopes");
    openapiFields.add("server");
    openapiFields.add("sender");
    openapiFields.add("username");
    openapiFields.add("password");
    openapiFields.add("confirmationUrl");
    openapiFields.add("templates");
    openapiFields.add("templateParams");
    openapiFields.add("ipBytesToIgnore");
    openapiFields.add("historySize");
    openapiFields.add("exchangeAuthCode");
    openapiFields.add("userInfo");
    openapiFields.add("extractLogin");
    openapiFields.add("extractPublicData");
    openapiFields.add("maxLength");
    openapiFields.add("minLength");
    openapiFields.add("requireNumber");
    openapiFields.add("requireSymbol");
    openapiFields.add("requireUpperCase");
    openapiFields.add("forbidCommonPasswords");
    openapiFields.add("forbidLoginAsPassword");
    openapiFields.add("forbidReusingPassword");
    openapiFields.add("strength");
    openapiFields.add("lowercase");
    openapiFields.add("removeSymbols");
    openapiFields.add("removeSpaces");
    openapiFields.add("answersRequired");
    openapiFields.add("maxAnswers");
    openapiFields.add("encryptKey");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ShAppCfgAuthsValue
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ShAppCfgAuthsValue.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ShAppCfgAuthsValue is not found in the empty JSON string", ShAppCfgAuthsValue.openapiRequiredFields.toString()));
        }
      }
      if ((jsonObj.get("remote") != null && !jsonObj.get("remote").isJsonNull()) && !jsonObj.get("remote").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `remote` to be a primitive type in the JSON string but got `%s`", jsonObj.get("remote").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("requiresAuth") != null && !jsonObj.get("requiresAuth").isJsonNull()) && !jsonObj.get("requiresAuth").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `requiresAuth` to be an array in the JSON string but got `%s`", jsonObj.get("requiresAuth").toString()));
      }
      if ((jsonObj.get("rateLimiter") != null && !jsonObj.get("rateLimiter").isJsonNull()) && !jsonObj.get("rateLimiter").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `rateLimiter` to be a primitive type in the JSON string but got `%s`", jsonObj.get("rateLimiter").toString()));
      }
      // validate the optional field `code`
      if (jsonObj.get("code") != null && !jsonObj.get("code").isJsonNull()) {
        CodeCfg.validateJsonObject(jsonObj.getAsJsonObject("code"));
      }
      if ((jsonObj.get("codeTtl") != null && !jsonObj.get("codeTtl").isJsonNull()) && !jsonObj.get("codeTtl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `codeTtl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("codeTtl").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("scopes") != null && !jsonObj.get("scopes").isJsonNull()) && !jsonObj.get("scopes").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `scopes` to be an array in the JSON string but got `%s`", jsonObj.get("scopes").toString()));
      }
      if ((jsonObj.get("server") != null && !jsonObj.get("server").isJsonNull()) && !jsonObj.get("server").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `server` to be a primitive type in the JSON string but got `%s`", jsonObj.get("server").toString()));
      }
      if ((jsonObj.get("sender") != null && !jsonObj.get("sender").isJsonNull()) && !jsonObj.get("sender").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `sender` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sender").toString()));
      }
      if ((jsonObj.get("username") != null && !jsonObj.get("username").isJsonNull()) && !jsonObj.get("username").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get("username").toString()));
      }
      if ((jsonObj.get("password") != null && !jsonObj.get("password").isJsonNull()) && !jsonObj.get("password").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `password` to be a primitive type in the JSON string but got `%s`", jsonObj.get("password").toString()));
      }
      if ((jsonObj.get("confirmationUrl") != null && !jsonObj.get("confirmationUrl").isJsonNull()) && !jsonObj.get("confirmationUrl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `confirmationUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("confirmationUrl").toString()));
      }
      // validate the optional field `exchangeAuthCode`
      if (jsonObj.get("exchangeAuthCode") != null && !jsonObj.get("exchangeAuthCode").isJsonNull()) {
        OAuthCfgExchangeAuthCode.validateJsonObject(jsonObj.getAsJsonObject("exchangeAuthCode"));
      }
      // validate the optional field `userInfo`
      if (jsonObj.get("userInfo") != null && !jsonObj.get("userInfo").isJsonNull()) {
        OAuthCfgUserInfo.validateJsonObject(jsonObj.getAsJsonObject("userInfo"));
      }
      if ((jsonObj.get("extractLogin") != null && !jsonObj.get("extractLogin").isJsonNull()) && !jsonObj.get("extractLogin").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `extractLogin` to be a primitive type in the JSON string but got `%s`", jsonObj.get("extractLogin").toString()));
      }
      // validate the optional field `forbidReusingPassword`
      if (jsonObj.get("forbidReusingPassword") != null && !jsonObj.get("forbidReusingPassword").isJsonNull()) {
        PasswordHistoryCfg.validateJsonObject(jsonObj.getAsJsonObject("forbidReusingPassword"));
      }
      if ((jsonObj.get("encryptKey") != null && !jsonObj.get("encryptKey").isJsonNull()) && !jsonObj.get("encryptKey").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `encryptKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get("encryptKey").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ShAppCfgAuthsValue.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ShAppCfgAuthsValue' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ShAppCfgAuthsValue> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ShAppCfgAuthsValue.class));

       return (TypeAdapter<T>) new TypeAdapter<ShAppCfgAuthsValue>() {
           @Override
           public void write(JsonWriter out, ShAppCfgAuthsValue value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public ShAppCfgAuthsValue read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             ShAppCfgAuthsValue instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ShAppCfgAuthsValue given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ShAppCfgAuthsValue
  * @throws IOException if the JSON string is invalid with respect to ShAppCfgAuthsValue
  */
  public static ShAppCfgAuthsValue fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ShAppCfgAuthsValue.class);
  }

 /**
  * Convert an instance of ShAppCfgAuthsValue to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

