/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class AuthorizationCodeAuthCfg {
    public static final String SERIALIZED_NAME_REQUIRES_AUTH = "requiresAuth";
    @SerializedName(value="requiresAuth")
    private List<List<String>> requiresAuth = null;
    public static final String SERIALIZED_NAME_SKIP_ON_FAIL = "skipOnFail";
    @SerializedName(value="skipOnFail")
    private Boolean skipOnFail = false;
    public static final String SERIALIZED_NAME_RATE_LIMITER = "rateLimiter";
    @SerializedName(value="rateLimiter")
    private String rateLimiter;
    public static final String SERIALIZED_NAME_BURN_QUOTA = "burnQuota";
    @SerializedName(value="burnQuota")
    private Double burnQuota = 0.0;
    public static final String SERIALIZED_NAME_CODE_TTL = "codeTtl";
    @SerializedName(value="codeTtl")
    private String codeTtl = "10m";
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    private List<String> scopes = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AuthorizationCodeAuthCfg requiresAuth(List<List<String>> requiresAuth) {
        this.requiresAuth = requiresAuth;
        return this;
    }

    public AuthorizationCodeAuthCfg addRequiresAuthItem(List<String> requiresAuthItem) {
        if (this.requiresAuth == null) {
            this.requiresAuth = new ArrayList<List<String>>();
        }
        this.requiresAuth.add(requiresAuthItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this is not null, app forbids to add this auth until listed auth enabled. - if this a string -> require specified auth to be enabled before this. - array of strings -> require any of listed auths to be enabled - array of arrays of strings -> works as `[ [ \"auth1\" and \"auth2\" ] or [ \"auth1\" and \"auth2\" ] ]`")
    public List<List<String>> getRequiresAuth() {
        return this.requiresAuth;
    }

    public void setRequiresAuth(List<List<String>> requiresAuth) {
        this.requiresAuth = requiresAuth;
    }

    public AuthorizationCodeAuthCfg skipOnFail(Boolean skipOnFail) {
        this.skipOnFail = skipOnFail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When this is set to true app will attempt next auth in case of error on current. It's works good with IP auth. User can provide both IP auth request and SMS auth request. And SMS will be executed only when IP auth is failed. If set to false any error on this auth will stop the whole request execution.")
    public Boolean getSkipOnFail() {
        return this.skipOnFail;
    }

    public void setSkipOnFail(Boolean skipOnFail) {
        this.skipOnFail = skipOnFail;
    }

    public AuthorizationCodeAuthCfg rateLimiter(String rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply rate limiter for this auth.")
    public String getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(String rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public AuthorizationCodeAuthCfg burnQuota(Double burnQuota) {
        this.burnQuota = burnQuota;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Every auth execution will burn this amount of quota. Takes place only when rate limiter is specified")
    public Double getBurnQuota() {
        return this.burnQuota;
    }

    public void setBurnQuota(Double burnQuota) {
        this.burnQuota = burnQuota;
    }

    public AuthorizationCodeAuthCfg codeTtl(String codeTtl) {
        this.codeTtl = codeTtl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Authorization code lifetime. ")
    public String getCodeTtl() {
        return this.codeTtl;
    }

    public void setCodeTtl(String codeTtl) {
        this.codeTtl = codeTtl;
    }

    public AuthorizationCodeAuthCfg scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public AuthorizationCodeAuthCfg addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allowed oauth2 scopes.")
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public AuthorizationCodeAuthCfg putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationCodeAuthCfg authorizationCodeAuthCfg = (AuthorizationCodeAuthCfg)o;
        return Objects.equals(this.requiresAuth, authorizationCodeAuthCfg.requiresAuth) && Objects.equals(this.skipOnFail, authorizationCodeAuthCfg.skipOnFail) && Objects.equals(this.rateLimiter, authorizationCodeAuthCfg.rateLimiter) && Objects.equals(this.burnQuota, authorizationCodeAuthCfg.burnQuota) && Objects.equals(this.codeTtl, authorizationCodeAuthCfg.codeTtl) && Objects.equals(this.scopes, authorizationCodeAuthCfg.scopes) && Objects.equals(this.additionalProperties, authorizationCodeAuthCfg.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.requiresAuth, this.skipOnFail, this.rateLimiter, this.burnQuota, this.codeTtl, this.scopes, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationCodeAuthCfg {\n");
        sb.append("    requiresAuth: ").append(this.toIndentedString(this.requiresAuth)).append("\n");
        sb.append("    skipOnFail: ").append(this.toIndentedString(this.skipOnFail)).append("\n");
        sb.append("    rateLimiter: ").append(this.toIndentedString(this.rateLimiter)).append("\n");
        sb.append("    burnQuota: ").append(this.toIndentedString(this.burnQuota)).append("\n");
        sb.append("    codeTtl: ").append(this.toIndentedString(this.codeTtl)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AuthorizationCodeAuthCfg is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH) != null && !jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `requiresAuth` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RATE_LIMITER) != null && !jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rateLimiter` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CODE_TTL) != null && !jsonObj.get(SERIALIZED_NAME_CODE_TTL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CODE_TTL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `codeTtl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CODE_TTL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCOPES) != null && !jsonObj.get(SERIALIZED_NAME_SCOPES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCOPES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `scopes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPES).toString()));
        }
    }

    public static AuthorizationCodeAuthCfg fromJson(String jsonString) throws IOException {
        return (AuthorizationCodeAuthCfg)JSON.getGson().fromJson(jsonString, AuthorizationCodeAuthCfg.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_REQUIRES_AUTH);
        openapiFields.add(SERIALIZED_NAME_SKIP_ON_FAIL);
        openapiFields.add(SERIALIZED_NAME_RATE_LIMITER);
        openapiFields.add(SERIALIZED_NAME_BURN_QUOTA);
        openapiFields.add(SERIALIZED_NAME_CODE_TTL);
        openapiFields.add(SERIALIZED_NAME_SCOPES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AuthorizationCodeAuthCfg.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AuthorizationCodeAuthCfg.class));
            return new TypeAdapter<AuthorizationCodeAuthCfg>(){

                public void write(JsonWriter out, AuthorizationCodeAuthCfg value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public AuthorizationCodeAuthCfg read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AuthorizationCodeAuthCfg.validateJsonObject(jsonObj);
                    AuthorizationCodeAuthCfg instance = (AuthorizationCodeAuthCfg)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

