/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import app.kntrl.client.openapi.model.CodeCfg;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EmailAuthCfg {
    public static final String SERIALIZED_NAME_REQUIRES_AUTH = "requiresAuth";
    @SerializedName(value="requiresAuth")
    private List<List<String>> requiresAuth = null;
    public static final String SERIALIZED_NAME_SKIP_ON_FAIL = "skipOnFail";
    @SerializedName(value="skipOnFail")
    private Boolean skipOnFail = false;
    public static final String SERIALIZED_NAME_RATE_LIMITER = "rateLimiter";
    @SerializedName(value="rateLimiter")
    private String rateLimiter;
    public static final String SERIALIZED_NAME_BURN_QUOTA = "burnQuota";
    @SerializedName(value="burnQuota")
    private Double burnQuota = 0.0;
    public static final String SERIALIZED_NAME_SERVER = "server";
    @SerializedName(value="server")
    private String server;
    public static final String SERIALIZED_NAME_SENDER = "sender";
    @SerializedName(value="sender")
    private String sender;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(value="password")
    private String password;
    public static final String SERIALIZED_NAME_CONFIRMATION_URL = "confirmationUrl";
    @SerializedName(value="confirmationUrl")
    private String confirmationUrl;
    public static final String SERIALIZED_NAME_TEMPLATES = "templates";
    @SerializedName(value="templates")
    private Map<String, String> templates = null;
    public static final String SERIALIZED_NAME_TEMPLATE_PARAMS = "templateParams";
    @SerializedName(value="templateParams")
    private Map<String, Object> templateParams = null;
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private CodeCfg code;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public EmailAuthCfg requiresAuth(List<List<String>> requiresAuth) {
        this.requiresAuth = requiresAuth;
        return this;
    }

    public EmailAuthCfg addRequiresAuthItem(List<String> requiresAuthItem) {
        if (this.requiresAuth == null) {
            this.requiresAuth = new ArrayList<List<String>>();
        }
        this.requiresAuth.add(requiresAuthItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this is not null, app forbids to add this auth until listed auth enabled. - if this a string -> require specified auth to be enabled before this. - array of strings -> require any of listed auths to be enabled - array of arrays of strings -> works as `[ [ \"auth1\" and \"auth2\" ] or [ \"auth1\" and \"auth2\" ] ]`")
    public List<List<String>> getRequiresAuth() {
        return this.requiresAuth;
    }

    public void setRequiresAuth(List<List<String>> requiresAuth) {
        this.requiresAuth = requiresAuth;
    }

    public EmailAuthCfg skipOnFail(Boolean skipOnFail) {
        this.skipOnFail = skipOnFail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When this is set to true app will attempt next auth in case of error on current. It's works good with IP auth. User can provide both IP auth request and SMS auth request. And SMS will be executed only when IP auth is failed. If set to false any error on this auth will stop the whole request execution.")
    public Boolean getSkipOnFail() {
        return this.skipOnFail;
    }

    public void setSkipOnFail(Boolean skipOnFail) {
        this.skipOnFail = skipOnFail;
    }

    public EmailAuthCfg rateLimiter(String rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply rate limiter for this auth.")
    public String getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(String rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public EmailAuthCfg burnQuota(Double burnQuota) {
        this.burnQuota = burnQuota;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Every auth execution will burn this amount of quota. Takes place only when rate limiter is specified")
    public Double getBurnQuota() {
        return this.burnQuota;
    }

    public void setBurnQuota(Double burnQuota) {
        this.burnQuota = burnQuota;
    }

    public EmailAuthCfg server(String server) {
        this.server = server;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Email server address/IP.")
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public EmailAuthCfg sender(String sender) {
        this.sender = sender;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Email address of sender.")
    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public EmailAuthCfg username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SMTP username.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public EmailAuthCfg password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SMTP password.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public EmailAuthCfg confirmationUrl(String confirmationUrl) {
        this.confirmationUrl = confirmationUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If not null, server will create template param `confirmationUrl` that will contain query parameters with confirmation code, session id, etc.")
    public String getConfirmationUrl() {
        return this.confirmationUrl;
    }

    public void setConfirmationUrl(String confirmationUrl) {
        this.confirmationUrl = confirmationUrl;
    }

    public EmailAuthCfg templates(Map<String, String> templates) {
        this.templates = templates;
        return this;
    }

    public EmailAuthCfg putTemplatesItem(String key, String templatesItem) {
        if (this.templates == null) {
            this.templates = new HashMap<String, String>();
        }
        this.templates.put(key, templatesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"welcome\":\"./welcome.html.hbs\",\"restoreAccess\":\"./restore.html.hbs\"}", value="List of email templates. Key - is name of a template (can be used lately on frontend), value - is path to the template. App uses handlebars templates to generate emails. See docs here https://handlebarsjs.com  Email templates receives `confirmationUrl`, `action`, `user`, `session`, `codeId`, `code`, `codeExpiresInMinutes`, `lang`, `headers` as template params, e.g. you can print user id as `{{user.id}}`.  Template engine also provides `i18n` helper for localisation. E.g. `{{i18n 'confirmationButton' default='Confirm'}}` searches key `confirmationButton` in files specified by `i18n.dir` config.  Use `{{err ERR_CODE msg='Localised message (if null, will be taken from i18n file)' devMsg='dev message'}}` to raise an error in a template.  It allows setting subject of email using `title` html tag, e.g. `<title>Email subject</title>`.  ")
    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public void setTemplates(Map<String, String> templates) {
        this.templates = templates;
    }

    public EmailAuthCfg templateParams(Map<String, Object> templateParams) {
        this.templateParams = templateParams;
        return this;
    }

    public EmailAuthCfg putTemplateParamsItem(String key, Object templateParamsItem) {
        if (this.templateParams == null) {
            this.templateParams = new HashMap<String, Object>();
        }
        this.templateParams.put(key, templateParamsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Additional params for templates that can be passed in request. Key - is a name of additional parameter, value - is a default value for this parameter (when no value present in request) ")
    public Map<String, Object> getTemplateParams() {
        return this.templateParams;
    }

    public void setTemplateParams(Map<String, Object> templateParams) {
        this.templateParams = templateParams;
    }

    public EmailAuthCfg code(CodeCfg code) {
        this.code = code;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CodeCfg getCode() {
        return this.code;
    }

    public void setCode(CodeCfg code) {
        this.code = code;
    }

    public EmailAuthCfg putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailAuthCfg emailAuthCfg = (EmailAuthCfg)o;
        return Objects.equals(this.requiresAuth, emailAuthCfg.requiresAuth) && Objects.equals(this.skipOnFail, emailAuthCfg.skipOnFail) && Objects.equals(this.rateLimiter, emailAuthCfg.rateLimiter) && Objects.equals(this.burnQuota, emailAuthCfg.burnQuota) && Objects.equals(this.server, emailAuthCfg.server) && Objects.equals(this.sender, emailAuthCfg.sender) && Objects.equals(this.username, emailAuthCfg.username) && Objects.equals(this.password, emailAuthCfg.password) && Objects.equals(this.confirmationUrl, emailAuthCfg.confirmationUrl) && Objects.equals(this.templates, emailAuthCfg.templates) && Objects.equals(this.templateParams, emailAuthCfg.templateParams) && Objects.equals(this.code, emailAuthCfg.code) && Objects.equals(this.additionalProperties, emailAuthCfg.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.requiresAuth, this.skipOnFail, this.rateLimiter, this.burnQuota, this.server, this.sender, this.username, this.password, this.confirmationUrl, this.templates, this.templateParams, this.code, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailAuthCfg {\n");
        sb.append("    requiresAuth: ").append(this.toIndentedString(this.requiresAuth)).append("\n");
        sb.append("    skipOnFail: ").append(this.toIndentedString(this.skipOnFail)).append("\n");
        sb.append("    rateLimiter: ").append(this.toIndentedString(this.rateLimiter)).append("\n");
        sb.append("    burnQuota: ").append(this.toIndentedString(this.burnQuota)).append("\n");
        sb.append("    server: ").append(this.toIndentedString(this.server)).append("\n");
        sb.append("    sender: ").append(this.toIndentedString(this.sender)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    confirmationUrl: ").append(this.toIndentedString(this.confirmationUrl)).append("\n");
        sb.append("    templates: ").append(this.toIndentedString(this.templates)).append("\n");
        sb.append("    templateParams: ").append(this.toIndentedString(this.templateParams)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in EmailAuthCfg is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH) != null && !jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `requiresAuth` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RATE_LIMITER) != null && !jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rateLimiter` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVER) != null && !jsonObj.get(SERIALIZED_NAME_SERVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SERVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `server` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SENDER) != null && !jsonObj.get(SERIALIZED_NAME_SENDER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SENDER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sender` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SENDER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWORD) != null && !jsonObj.get(SERIALIZED_NAME_PASSWORD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PASSWORD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `password` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWORD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIRMATION_URL) != null && !jsonObj.get(SERIALIZED_NAME_CONFIRMATION_URL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONFIRMATION_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `confirmationUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFIRMATION_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CODE) != null && !jsonObj.get(SERIALIZED_NAME_CODE).isJsonNull()) {
            CodeCfg.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CODE));
        }
    }

    public static EmailAuthCfg fromJson(String jsonString) throws IOException {
        return (EmailAuthCfg)JSON.getGson().fromJson(jsonString, EmailAuthCfg.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_REQUIRES_AUTH);
        openapiFields.add(SERIALIZED_NAME_SKIP_ON_FAIL);
        openapiFields.add(SERIALIZED_NAME_RATE_LIMITER);
        openapiFields.add(SERIALIZED_NAME_BURN_QUOTA);
        openapiFields.add(SERIALIZED_NAME_SERVER);
        openapiFields.add(SERIALIZED_NAME_SENDER);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiFields.add(SERIALIZED_NAME_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_CONFIRMATION_URL);
        openapiFields.add(SERIALIZED_NAME_TEMPLATES);
        openapiFields.add(SERIALIZED_NAME_TEMPLATE_PARAMS);
        openapiFields.add(SERIALIZED_NAME_CODE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SERVER);
        openapiRequiredFields.add(SERIALIZED_NAME_SENDER);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!EmailAuthCfg.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EmailAuthCfg.class));
            return new TypeAdapter<EmailAuthCfg>(){

                public void write(JsonWriter out, EmailAuthCfg value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public EmailAuthCfg read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    EmailAuthCfg.validateJsonObject(jsonObj);
                    EmailAuthCfg instance = (EmailAuthCfg)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

