/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class OAuthReqData {
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "accessToken";
    @SerializedName(value="accessToken")
    private String accessToken;
    public static final String SERIALIZED_NAME_AUTHORIZATION_CODE = "authorizationCode";
    @SerializedName(value="authorizationCode")
    private String authorizationCode;
    public static final String SERIALIZED_NAME_REDIRECT_URI = "redirectUri";
    @SerializedName(value="redirectUri")
    private String redirectUri;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OAuthReqData accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If you have access-token - put it here.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public OAuthReqData authorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If you have authorisation-code - app will exchange it for access-token.")
    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public OAuthReqData redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Redirect uri used when requested user login.")
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public OAuthReqData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthReqData oauthReqData = (OAuthReqData)o;
        return Objects.equals(this.accessToken, oauthReqData.accessToken) && Objects.equals(this.authorizationCode, oauthReqData.authorizationCode) && Objects.equals(this.redirectUri, oauthReqData.redirectUri) && Objects.equals(this.additionalProperties, oauthReqData.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.authorizationCode, this.redirectUri, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthReqData {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    authorizationCode: ").append(this.toIndentedString(this.authorizationCode)).append("\n");
        sb.append("    redirectUri: ").append(this.toIndentedString(this.redirectUri)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in OAuthReqData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `accessToken` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHORIZATION_CODE) != null && !jsonObj.get(SERIALIZED_NAME_AUTHORIZATION_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AUTHORIZATION_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `authorizationCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHORIZATION_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REDIRECT_URI) != null && !jsonObj.get(SERIALIZED_NAME_REDIRECT_URI).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REDIRECT_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `redirectUri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REDIRECT_URI).toString()));
        }
    }

    public static OAuthReqData fromJson(String jsonString) throws IOException {
        return (OAuthReqData)JSON.getGson().fromJson(jsonString, OAuthReqData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCESS_TOKEN);
        openapiFields.add(SERIALIZED_NAME_AUTHORIZATION_CODE);
        openapiFields.add(SERIALIZED_NAME_REDIRECT_URI);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!OAuthReqData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OAuthReqData.class));
            return new TypeAdapter<OAuthReqData>(){

                public void write(JsonWriter out, OAuthReqData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public OAuthReqData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    OAuthReqData.validateJsonObject(jsonObj);
                    OAuthReqData instance = (OAuthReqData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

