/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import app.kntrl.client.openapi.model.PasswordHistoryCfg;
import app.kntrl.client.openapi.model.PasswordStrengthRequirements;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Password authentication. To enable this auth set auth name to \"password\" or use \"builtin\": \"password\" param.")
public class PasswordAuthCfg {
    public static final String SERIALIZED_NAME_REQUIRES_AUTH = "requiresAuth";
    @SerializedName(value="requiresAuth")
    private List<List<String>> requiresAuth = null;
    public static final String SERIALIZED_NAME_SKIP_ON_FAIL = "skipOnFail";
    @SerializedName(value="skipOnFail")
    private Boolean skipOnFail = false;
    public static final String SERIALIZED_NAME_RATE_LIMITER = "rateLimiter";
    @SerializedName(value="rateLimiter")
    private String rateLimiter;
    public static final String SERIALIZED_NAME_BURN_QUOTA = "burnQuota";
    @SerializedName(value="burnQuota")
    private Double burnQuota = 0.0;
    public static final String SERIALIZED_NAME_MAX_LENGTH = "maxLength";
    @SerializedName(value="maxLength")
    private Integer maxLength = 256;
    public static final String SERIALIZED_NAME_MIN_LENGTH = "minLength";
    @SerializedName(value="minLength")
    private Integer minLength = 6;
    public static final String SERIALIZED_NAME_REQUIRE_NUMBER = "requireNumber";
    @SerializedName(value="requireNumber")
    private Boolean requireNumber = false;
    public static final String SERIALIZED_NAME_REQUIRE_SYMBOL = "requireSymbol";
    @SerializedName(value="requireSymbol")
    private Boolean requireSymbol = false;
    public static final String SERIALIZED_NAME_REQUIRE_UPPER_CASE = "requireUpperCase";
    @SerializedName(value="requireUpperCase")
    private Boolean requireUpperCase = false;
    public static final String SERIALIZED_NAME_FORBID_COMMON_PASSWORDS = "forbidCommonPasswords";
    @SerializedName(value="forbidCommonPasswords")
    private Boolean forbidCommonPasswords = false;
    public static final String SERIALIZED_NAME_FORBID_LOGIN_AS_PASSWORD = "forbidLoginAsPassword";
    @SerializedName(value="forbidLoginAsPassword")
    private Boolean forbidLoginAsPassword = false;
    public static final String SERIALIZED_NAME_FORBID_REUSING_PASSWORD = "forbidReusingPassword";
    @SerializedName(value="forbidReusingPassword")
    private PasswordHistoryCfg forbidReusingPassword;
    public static final String SERIALIZED_NAME_STRENGTH = "strength";
    @SerializedName(value="strength")
    private Map<String, PasswordStrengthRequirements> strength = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PasswordAuthCfg requiresAuth(List<List<String>> requiresAuth) {
        this.requiresAuth = requiresAuth;
        return this;
    }

    public PasswordAuthCfg addRequiresAuthItem(List<String> requiresAuthItem) {
        if (this.requiresAuth == null) {
            this.requiresAuth = new ArrayList<List<String>>();
        }
        this.requiresAuth.add(requiresAuthItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this is not null, app forbids to add this auth until listed auth enabled. - if this a string -> require specified auth to be enabled before this. - array of strings -> require any of listed auths to be enabled - array of arrays of strings -> works as `[ [ \"auth1\" and \"auth2\" ] or [ \"auth1\" and \"auth2\" ] ]`")
    public List<List<String>> getRequiresAuth() {
        return this.requiresAuth;
    }

    public void setRequiresAuth(List<List<String>> requiresAuth) {
        this.requiresAuth = requiresAuth;
    }

    public PasswordAuthCfg skipOnFail(Boolean skipOnFail) {
        this.skipOnFail = skipOnFail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When this is set to true app will attempt next auth in case of error on current. It's works good with IP auth. User can provide both IP auth request and SMS auth request. And SMS will be executed only when IP auth is failed. If set to false any error on this auth will stop the whole request execution.")
    public Boolean getSkipOnFail() {
        return this.skipOnFail;
    }

    public void setSkipOnFail(Boolean skipOnFail) {
        this.skipOnFail = skipOnFail;
    }

    public PasswordAuthCfg rateLimiter(String rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply rate limiter for this auth.")
    public String getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(String rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public PasswordAuthCfg burnQuota(Double burnQuota) {
        this.burnQuota = burnQuota;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Every auth execution will burn this amount of quota. Takes place only when rate limiter is specified")
    public Double getBurnQuota() {
        return this.burnQuota;
    }

    public void setBurnQuota(Double burnQuota) {
        this.burnQuota = burnQuota;
    }

    public PasswordAuthCfg maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Max allowed Length of the password.")
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public PasswordAuthCfg minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimal length of password")
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public PasswordAuthCfg requireNumber(Boolean requireNumber) {
        this.requireNumber = requireNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Require password to contain at least one digit.")
    public Boolean getRequireNumber() {
        return this.requireNumber;
    }

    public void setRequireNumber(Boolean requireNumber) {
        this.requireNumber = requireNumber;
    }

    public PasswordAuthCfg requireSymbol(Boolean requireSymbol) {
        this.requireSymbol = requireSymbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Require password to contain at least one symbol e.g. @, !, &...")
    public Boolean getRequireSymbol() {
        return this.requireSymbol;
    }

    public void setRequireSymbol(Boolean requireSymbol) {
        this.requireSymbol = requireSymbol;
    }

    public PasswordAuthCfg requireUpperCase(Boolean requireUpperCase) {
        this.requireUpperCase = requireUpperCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This requires password to contain both lowercase and uppercase letters.")
    public Boolean getRequireUpperCase() {
        return this.requireUpperCase;
    }

    public void setRequireUpperCase(Boolean requireUpperCase) {
        this.requireUpperCase = requireUpperCase;
    }

    public PasswordAuthCfg forbidCommonPasswords(Boolean forbidCommonPasswords) {
        this.forbidCommonPasswords = forbidCommonPasswords;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Password will be checked against table 1,000,000 of most overused passwords.")
    public Boolean getForbidCommonPasswords() {
        return this.forbidCommonPasswords;
    }

    public void setForbidCommonPasswords(Boolean forbidCommonPasswords) {
        this.forbidCommonPasswords = forbidCommonPasswords;
    }

    public PasswordAuthCfg forbidLoginAsPassword(Boolean forbidLoginAsPassword) {
        this.forbidLoginAsPassword = forbidLoginAsPassword;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Rejects passwords that match username, email, anything that used as a login according to logins config.")
    public Boolean getForbidLoginAsPassword() {
        return this.forbidLoginAsPassword;
    }

    public void setForbidLoginAsPassword(Boolean forbidLoginAsPassword) {
        this.forbidLoginAsPassword = forbidLoginAsPassword;
    }

    public PasswordAuthCfg forbidReusingPassword(PasswordHistoryCfg forbidReusingPassword) {
        this.forbidReusingPassword = forbidReusingPassword;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PasswordHistoryCfg getForbidReusingPassword() {
        return this.forbidReusingPassword;
    }

    public void setForbidReusingPassword(PasswordHistoryCfg forbidReusingPassword) {
        this.forbidReusingPassword = forbidReusingPassword;
    }

    public PasswordAuthCfg strength(Map<String, PasswordStrengthRequirements> strength) {
        this.strength = strength;
        return this;
    }

    public PasswordAuthCfg putStrengthItem(String key, PasswordStrengthRequirements strengthItem) {
        if (this.strength == null) {
            this.strength = new HashMap<String, PasswordStrengthRequirements>();
        }
        this.strength.put(key, strengthItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows to calculate password strength based on mentioned criteria. Requirements will be checked one by one until first failed. ")
    public Map<String, PasswordStrengthRequirements> getStrength() {
        return this.strength;
    }

    public void setStrength(Map<String, PasswordStrengthRequirements> strength) {
        this.strength = strength;
    }

    public PasswordAuthCfg putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PasswordAuthCfg passwordAuthCfg = (PasswordAuthCfg)o;
        return Objects.equals(this.requiresAuth, passwordAuthCfg.requiresAuth) && Objects.equals(this.skipOnFail, passwordAuthCfg.skipOnFail) && Objects.equals(this.rateLimiter, passwordAuthCfg.rateLimiter) && Objects.equals(this.burnQuota, passwordAuthCfg.burnQuota) && Objects.equals(this.maxLength, passwordAuthCfg.maxLength) && Objects.equals(this.minLength, passwordAuthCfg.minLength) && Objects.equals(this.requireNumber, passwordAuthCfg.requireNumber) && Objects.equals(this.requireSymbol, passwordAuthCfg.requireSymbol) && Objects.equals(this.requireUpperCase, passwordAuthCfg.requireUpperCase) && Objects.equals(this.forbidCommonPasswords, passwordAuthCfg.forbidCommonPasswords) && Objects.equals(this.forbidLoginAsPassword, passwordAuthCfg.forbidLoginAsPassword) && Objects.equals(this.forbidReusingPassword, passwordAuthCfg.forbidReusingPassword) && Objects.equals(this.strength, passwordAuthCfg.strength) && Objects.equals(this.additionalProperties, passwordAuthCfg.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.requiresAuth, this.skipOnFail, this.rateLimiter, this.burnQuota, this.maxLength, this.minLength, this.requireNumber, this.requireSymbol, this.requireUpperCase, this.forbidCommonPasswords, this.forbidLoginAsPassword, this.forbidReusingPassword, this.strength, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordAuthCfg {\n");
        sb.append("    requiresAuth: ").append(this.toIndentedString(this.requiresAuth)).append("\n");
        sb.append("    skipOnFail: ").append(this.toIndentedString(this.skipOnFail)).append("\n");
        sb.append("    rateLimiter: ").append(this.toIndentedString(this.rateLimiter)).append("\n");
        sb.append("    burnQuota: ").append(this.toIndentedString(this.burnQuota)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    requireNumber: ").append(this.toIndentedString(this.requireNumber)).append("\n");
        sb.append("    requireSymbol: ").append(this.toIndentedString(this.requireSymbol)).append("\n");
        sb.append("    requireUpperCase: ").append(this.toIndentedString(this.requireUpperCase)).append("\n");
        sb.append("    forbidCommonPasswords: ").append(this.toIndentedString(this.forbidCommonPasswords)).append("\n");
        sb.append("    forbidLoginAsPassword: ").append(this.toIndentedString(this.forbidLoginAsPassword)).append("\n");
        sb.append("    forbidReusingPassword: ").append(this.toIndentedString(this.forbidReusingPassword)).append("\n");
        sb.append("    strength: ").append(this.toIndentedString(this.strength)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PasswordAuthCfg is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH) != null && !jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `requiresAuth` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUIRES_AUTH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RATE_LIMITER) != null && !jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rateLimiter` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RATE_LIMITER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORBID_REUSING_PASSWORD) != null && !jsonObj.get(SERIALIZED_NAME_FORBID_REUSING_PASSWORD).isJsonNull()) {
            PasswordHistoryCfg.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FORBID_REUSING_PASSWORD));
        }
    }

    public static PasswordAuthCfg fromJson(String jsonString) throws IOException {
        return (PasswordAuthCfg)JSON.getGson().fromJson(jsonString, PasswordAuthCfg.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_REQUIRES_AUTH);
        openapiFields.add(SERIALIZED_NAME_SKIP_ON_FAIL);
        openapiFields.add(SERIALIZED_NAME_RATE_LIMITER);
        openapiFields.add(SERIALIZED_NAME_BURN_QUOTA);
        openapiFields.add(SERIALIZED_NAME_MAX_LENGTH);
        openapiFields.add(SERIALIZED_NAME_MIN_LENGTH);
        openapiFields.add(SERIALIZED_NAME_REQUIRE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_REQUIRE_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_REQUIRE_UPPER_CASE);
        openapiFields.add(SERIALIZED_NAME_FORBID_COMMON_PASSWORDS);
        openapiFields.add(SERIALIZED_NAME_FORBID_LOGIN_AS_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_FORBID_REUSING_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_STRENGTH);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!PasswordAuthCfg.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PasswordAuthCfg.class));
            return new TypeAdapter<PasswordAuthCfg>(){

                public void write(JsonWriter out, PasswordAuthCfg value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public PasswordAuthCfg read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PasswordAuthCfg.validateJsonObject(jsonObj);
                    PasswordAuthCfg instance = (PasswordAuthCfg)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

