/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import app.kntrl.client.openapi.model.Device;
import app.kntrl.client.openapi.model.LoginId;
import app.kntrl.client.openapi.model.NextFactor;
import app.kntrl.client.openapi.model.SessionDataValue;
import app.kntrl.client.openapi.model.UnconfirmedAuth;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Session {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ENTRY = "entry";
    @SerializedName(value="entry")
    private String entry;
    public static final String SERIALIZED_NAME_IDENTIFIED_BY = "identifiedBy";
    @SerializedName(value="identifiedBy")
    private List<LoginId> identifiedBy = new ArrayList<LoginId>();
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private String userId;
    public static final String SERIALIZED_NAME_AUTHENTICATED_BY = "authenticatedBy";
    @SerializedName(value="authenticatedBy")
    private Map<String, String> authenticatedBy = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_UNCONFIRMED_AUTHS = "unconfirmedAuths";
    @SerializedName(value="unconfirmedAuths")
    private Map<String, UnconfirmedAuth> unconfirmedAuths = new HashMap<String, UnconfirmedAuth>();
    public static final String SERIALIZED_NAME_NEXT_FACTORS = "nextFactors";
    @SerializedName(value="nextFactors")
    private List<NextFactor> nextFactors = new ArrayList<NextFactor>();
    public static final String SERIALIZED_NAME_SIGNED_IN_AT = "signedInAt";
    @SerializedName(value="signedInAt")
    private Long signedInAt;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
    @SerializedName(value="expiresAt")
    private Long expiresAt;
    public static final String SERIALIZED_NAME_REFRESHED_AT = "refreshedAt";
    @SerializedName(value="refreshedAt")
    private Long refreshedAt;
    public static final String SERIALIZED_NAME_NEW_USER = "newUser";
    @SerializedName(value="newUser")
    private Boolean newUser;
    public static final String SERIALIZED_NAME_DEVICE = "device";
    @SerializedName(value="device")
    private Device device;
    public static final String SERIALIZED_NAME_SYSTEM_ACCESS = "systemAccess";
    @SerializedName(value="systemAccess")
    private Boolean systemAccess;
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private Map<String, SessionDataValue> data = new HashMap<String, SessionDataValue>();
    public static final String SERIALIZED_NAME_EXPIRED = "expired";
    @SerializedName(value="expired")
    private Boolean expired;
    public static final String SERIALIZED_NAME_AUTHENTICATED = "authenticated";
    @SerializedName(value="authenticated")
    private Boolean authenticated;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Session id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Session entry(String entry) {
        this.entry = entry;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Entry that authenticates this session")
    public String getEntry() {
        return this.entry;
    }

    public void setEntry(String entry) {
        this.entry = entry;
    }

    public Session identifiedBy(List<LoginId> identifiedBy) {
        this.identifiedBy = identifiedBy;
        return this;
    }

    public Session addIdentifiedByItem(LoginId identifiedByItem) {
        this.identifiedBy.add(identifiedByItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Login used to identify this user")
    public List<LoginId> getIdentifiedBy() {
        return this.identifiedBy;
    }

    public void setIdentifiedBy(List<LoginId> identifiedBy) {
        this.identifiedBy = identifiedBy;
    }

    public Session userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Session authenticatedBy(Map<String, String> authenticatedBy) {
        this.authenticatedBy = authenticatedBy;
        return this;
    }

    public Session putAuthenticatedByItem(String key, String authenticatedByItem) {
        this.authenticatedBy.put(key, authenticatedByItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Authenticator used for factors ")
    public Map<String, String> getAuthenticatedBy() {
        return this.authenticatedBy;
    }

    public void setAuthenticatedBy(Map<String, String> authenticatedBy) {
        this.authenticatedBy = authenticatedBy;
    }

    public Session unconfirmedAuths(Map<String, UnconfirmedAuth> unconfirmedAuths) {
        this.unconfirmedAuths = unconfirmedAuths;
        return this;
    }

    public Session putUnconfirmedAuthsItem(String key, UnconfirmedAuth unconfirmedAuthsItem) {
        this.unconfirmedAuths.put(key, unconfirmedAuthsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Auths that waiting for confirmation ")
    public Map<String, UnconfirmedAuth> getUnconfirmedAuths() {
        return this.unconfirmedAuths;
    }

    public void setUnconfirmedAuths(Map<String, UnconfirmedAuth> unconfirmedAuths) {
        this.unconfirmedAuths = unconfirmedAuths;
    }

    public Session nextFactors(List<NextFactor> nextFactors) {
        this.nextFactors = nextFactors;
        return this;
    }

    public Session addNextFactorsItem(NextFactor nextFactorsItem) {
        this.nextFactors.add(nextFactorsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="List of factors needed to authenticate this session")
    public List<NextFactor> getNextFactors() {
        return this.nextFactors;
    }

    public void setNextFactors(List<NextFactor> nextFactors) {
        this.nextFactors = nextFactors;
    }

    public Session signedInAt(Long signedInAt) {
        this.signedInAt = signedInAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getSignedInAt() {
        return this.signedInAt;
    }

    public void setSignedInAt(Long signedInAt) {
        this.signedInAt = signedInAt;
    }

    public Session expiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Session refreshedAt(Long refreshedAt) {
        this.refreshedAt = refreshedAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getRefreshedAt() {
        return this.refreshedAt;
    }

    public void setRefreshedAt(Long refreshedAt) {
        this.refreshedAt = refreshedAt;
    }

    public Session newUser(Boolean newUser) {
        this.newUser = newUser;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Boolean getNewUser() {
        return this.newUser;
    }

    public void setNewUser(Boolean newUser) {
        this.newUser = newUser;
    }

    public Session device(Device device) {
        this.device = device;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public Session systemAccess(Boolean systemAccess) {
        this.systemAccess = systemAccess;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Boolean getSystemAccess() {
        return this.systemAccess;
    }

    public void setSystemAccess(Boolean systemAccess) {
        this.systemAccess = systemAccess;
    }

    public Session data(Map<String, SessionDataValue> data) {
        this.data = data;
        return this;
    }

    public Session putDataItem(String key, SessionDataValue dataItem) {
        this.data.put(key, dataItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Map<String, SessionDataValue> getData() {
        return this.data;
    }

    public void setData(Map<String, SessionDataValue> data) {
        this.data = data;
    }

    public Session expired(Boolean expired) {
        this.expired = expired;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getExpired() {
        return this.expired;
    }

    public void setExpired(Boolean expired) {
        this.expired = expired;
    }

    public Session authenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
    }

    public Session putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        return Objects.equals(this.id, session.id) && Objects.equals(this.entry, session.entry) && Objects.equals(this.identifiedBy, session.identifiedBy) && Objects.equals(this.userId, session.userId) && Objects.equals(this.authenticatedBy, session.authenticatedBy) && Objects.equals(this.unconfirmedAuths, session.unconfirmedAuths) && Objects.equals(this.nextFactors, session.nextFactors) && Objects.equals(this.signedInAt, session.signedInAt) && Objects.equals(this.expiresAt, session.expiresAt) && Objects.equals(this.refreshedAt, session.refreshedAt) && Objects.equals(this.newUser, session.newUser) && Objects.equals(this.device, session.device) && Objects.equals(this.systemAccess, session.systemAccess) && Objects.equals(this.data, session.data) && Objects.equals(this.expired, session.expired) && Objects.equals(this.authenticated, session.authenticated) && Objects.equals(this.additionalProperties, session.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.entry, this.identifiedBy, this.userId, this.authenticatedBy, this.unconfirmedAuths, this.nextFactors, this.signedInAt, this.expiresAt, this.refreshedAt, this.newUser, this.device, this.systemAccess, this.data, this.expired, this.authenticated, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Session {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    entry: ").append(this.toIndentedString(this.entry)).append("\n");
        sb.append("    identifiedBy: ").append(this.toIndentedString(this.identifiedBy)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    authenticatedBy: ").append(this.toIndentedString(this.authenticatedBy)).append("\n");
        sb.append("    unconfirmedAuths: ").append(this.toIndentedString(this.unconfirmedAuths)).append("\n");
        sb.append("    nextFactors: ").append(this.toIndentedString(this.nextFactors)).append("\n");
        sb.append("    signedInAt: ").append(this.toIndentedString(this.signedInAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    refreshedAt: ").append(this.toIndentedString(this.refreshedAt)).append("\n");
        sb.append("    newUser: ").append(this.toIndentedString(this.newUser)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    systemAccess: ").append(this.toIndentedString(this.systemAccess)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    expired: ").append(this.toIndentedString(this.expired)).append("\n");
        sb.append("    authenticated: ").append(this.toIndentedString(this.authenticated)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraynextFactors;
        JsonArray jsonArrayidentifiedBy;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Session is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENTRY) != null && !jsonObj.get(SERIALIZED_NAME_ENTRY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `entry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IDENTIFIED_BY) != null && !jsonObj.get(SERIALIZED_NAME_IDENTIFIED_BY).isJsonNull() && (jsonArrayidentifiedBy = jsonObj.getAsJsonArray(SERIALIZED_NAME_IDENTIFIED_BY)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_IDENTIFIED_BY).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `identifiedBy` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IDENTIFIED_BY).toString()));
            }
            for (int i = 0; i < jsonArrayidentifiedBy.size(); ++i) {
                LoginId.validateJsonObject(jsonArrayidentifiedBy.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_USER_ID) != null && !jsonObj.get(SERIALIZED_NAME_USER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `userId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NEXT_FACTORS) != null && !jsonObj.get(SERIALIZED_NAME_NEXT_FACTORS).isJsonNull() && (jsonArraynextFactors = jsonObj.getAsJsonArray(SERIALIZED_NAME_NEXT_FACTORS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_NEXT_FACTORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `nextFactors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEXT_FACTORS).toString()));
            }
            for (int i = 0; i < jsonArraynextFactors.size(); ++i) {
                NextFactor.validateJsonObject(jsonArraynextFactors.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICE) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE).isJsonNull()) {
            Device.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DEVICE));
        }
    }

    public static Session fromJson(String jsonString) throws IOException {
        return (Session)JSON.getGson().fromJson(jsonString, Session.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ENTRY);
        openapiFields.add(SERIALIZED_NAME_IDENTIFIED_BY);
        openapiFields.add(SERIALIZED_NAME_USER_ID);
        openapiFields.add(SERIALIZED_NAME_AUTHENTICATED_BY);
        openapiFields.add(SERIALIZED_NAME_UNCONFIRMED_AUTHS);
        openapiFields.add(SERIALIZED_NAME_NEXT_FACTORS);
        openapiFields.add(SERIALIZED_NAME_SIGNED_IN_AT);
        openapiFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiFields.add(SERIALIZED_NAME_REFRESHED_AT);
        openapiFields.add(SERIALIZED_NAME_NEW_USER);
        openapiFields.add(SERIALIZED_NAME_DEVICE);
        openapiFields.add(SERIALIZED_NAME_SYSTEM_ACCESS);
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiFields.add(SERIALIZED_NAME_EXPIRED);
        openapiFields.add(SERIALIZED_NAME_AUTHENTICATED);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ENTRY);
        openapiRequiredFields.add(SERIALIZED_NAME_IDENTIFIED_BY);
        openapiRequiredFields.add(SERIALIZED_NAME_AUTHENTICATED_BY);
        openapiRequiredFields.add(SERIALIZED_NAME_UNCONFIRMED_AUTHS);
        openapiRequiredFields.add(SERIALIZED_NAME_NEXT_FACTORS);
        openapiRequiredFields.add(SERIALIZED_NAME_SIGNED_IN_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_REFRESHED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_NEW_USER);
        openapiRequiredFields.add(SERIALIZED_NAME_DEVICE);
        openapiRequiredFields.add(SERIALIZED_NAME_SYSTEM_ACCESS);
        openapiRequiredFields.add(SERIALIZED_NAME_DATA);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Session.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Session.class));
            return new TypeAdapter<Session>(){

                public void write(JsonWriter out, Session value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Session read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Session.validateJsonObject(jsonObj);
                    Session instance = (Session)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

