/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import app.kntrl.client.openapi.model.AccessTokenCfg;
import app.kntrl.client.openapi.model.RefreshTokenCfg;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Token lifetime config.")
public class TokenCfg {
    public static final String SERIALIZED_NAME_ACCESS = "access";
    @SerializedName(value="access")
    private AccessTokenCfg access;
    public static final String SERIALIZED_NAME_REFRESH = "refresh";
    @SerializedName(value="refresh")
    private RefreshTokenCfg refresh;
    public static final String SERIALIZED_NAME_SAME_USER_AGENT = "sameUserAgent";
    @SerializedName(value="sameUserAgent")
    private Boolean sameUserAgent = true;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TokenCfg access(AccessTokenCfg access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccessTokenCfg getAccess() {
        return this.access;
    }

    public void setAccess(AccessTokenCfg access) {
        this.access = access;
    }

    public TokenCfg refresh(RefreshTokenCfg refresh) {
        this.refresh = refresh;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public RefreshTokenCfg getRefresh() {
        return this.refresh;
    }

    public void setRefresh(RefreshTokenCfg refresh) {
        this.refresh = refresh;
    }

    public TokenCfg sameUserAgent(Boolean sameUserAgent) {
        this.sameUserAgent = sameUserAgent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Require all request to be made from the same device.")
    public Boolean getSameUserAgent() {
        return this.sameUserAgent;
    }

    public void setSameUserAgent(Boolean sameUserAgent) {
        this.sameUserAgent = sameUserAgent;
    }

    public TokenCfg putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenCfg tokenCfg = (TokenCfg)o;
        return Objects.equals(this.access, tokenCfg.access) && Objects.equals(this.refresh, tokenCfg.refresh) && Objects.equals(this.sameUserAgent, tokenCfg.sameUserAgent) && Objects.equals(this.additionalProperties, tokenCfg.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.access, this.refresh, this.sameUserAgent, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenCfg {\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    refresh: ").append(this.toIndentedString(this.refresh)).append("\n");
        sb.append("    sameUserAgent: ").append(this.toIndentedString(this.sameUserAgent)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TokenCfg is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS).isJsonNull()) {
            AccessTokenCfg.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFRESH) != null && !jsonObj.get(SERIALIZED_NAME_REFRESH).isJsonNull()) {
            RefreshTokenCfg.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_REFRESH));
        }
    }

    public static TokenCfg fromJson(String jsonString) throws IOException {
        return (TokenCfg)JSON.getGson().fromJson(jsonString, TokenCfg.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiFields.add(SERIALIZED_NAME_REFRESH);
        openapiFields.add(SERIALIZED_NAME_SAME_USER_AGENT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TokenCfg.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TokenCfg.class));
            return new TypeAdapter<TokenCfg>(){

                public void write(JsonWriter out, TokenCfg value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public TokenCfg read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TokenCfg.validateJsonObject(jsonObj);
                    TokenCfg instance = (TokenCfg)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

