/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="If specified - app generates code and requires auth to be confirmed")
public class CodeCfg {
    public static final String SERIALIZED_NAME_LENGTH = "length";
    @SerializedName(value="length")
    private Integer length = 4;
    public static final String SERIALIZED_NAME_TTL = "ttl";
    @SerializedName(value="ttl")
    private String ttl;
    public static final String SERIALIZED_NAME_ALPHABET = "alphabet";
    @SerializedName(value="alphabet")
    private String alphabet;
    public static final String SERIALIZED_NAME_EASY_TO_REMEMBER = "easyToRemember";
    @SerializedName(value="easyToRemember")
    private Boolean easyToRemember = true;
    public static final String SERIALIZED_NAME_MAX_ATTEMPTS = "maxAttempts";
    @SerializedName(value="maxAttempts")
    private Integer maxAttempts = 3;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CodeCfg length(Integer length) {
        this.length = length;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Length of code to be generated")
    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public CodeCfg ttl(String ttl) {
        this.ttl = ttl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Generated code lifetime. e.g. 1m, 60s, 1d, etc.")
    public String getTtl() {
        return this.ttl;
    }

    public void setTtl(String ttl) {
        this.ttl = ttl;
    }

    public CodeCfg alphabet(String alphabet) {
        this.alphabet = alphabet;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Symbols used to generate a code. By default `a-z + A-Z + 0-9`.")
    public String getAlphabet() {
        return this.alphabet;
    }

    public void setAlphabet(String alphabet) {
        this.alphabet = alphabet;
    }

    public CodeCfg easyToRemember(Boolean easyToRemember) {
        this.easyToRemember = easyToRemember;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, every second letter will be the same, that allows the codes to rhyme.")
    public Boolean getEasyToRemember() {
        return this.easyToRemember;
    }

    public void setEasyToRemember(Boolean easyToRemember) {
        this.easyToRemember = easyToRemember;
    }

    public CodeCfg maxAttempts(Integer maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Max attempts to enter the code.")
    public Integer getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(Integer maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public CodeCfg putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeCfg codeCfg = (CodeCfg)o;
        return Objects.equals(this.length, codeCfg.length) && Objects.equals(this.ttl, codeCfg.ttl) && Objects.equals(this.alphabet, codeCfg.alphabet) && Objects.equals(this.easyToRemember, codeCfg.easyToRemember) && Objects.equals(this.maxAttempts, codeCfg.maxAttempts) && Objects.equals(this.additionalProperties, codeCfg.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.length, this.ttl, this.alphabet, this.easyToRemember, this.maxAttempts, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CodeCfg {\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    ttl: ").append(this.toIndentedString(this.ttl)).append("\n");
        sb.append("    alphabet: ").append(this.toIndentedString(this.alphabet)).append("\n");
        sb.append("    easyToRemember: ").append(this.toIndentedString(this.easyToRemember)).append("\n");
        sb.append("    maxAttempts: ").append(this.toIndentedString(this.maxAttempts)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CodeCfg is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TTL) != null && !jsonObj.get(SERIALIZED_NAME_TTL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TTL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ttl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TTL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALPHABET) != null && !jsonObj.get(SERIALIZED_NAME_ALPHABET).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALPHABET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `alphabet` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALPHABET).toString()));
        }
    }

    public static CodeCfg fromJson(String jsonString) throws IOException {
        return (CodeCfg)JSON.getGson().fromJson(jsonString, CodeCfg.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LENGTH);
        openapiFields.add(SERIALIZED_NAME_TTL);
        openapiFields.add(SERIALIZED_NAME_ALPHABET);
        openapiFields.add(SERIALIZED_NAME_EASY_TO_REMEMBER);
        openapiFields.add(SERIALIZED_NAME_MAX_ATTEMPTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!CodeCfg.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CodeCfg.class));
            return new TypeAdapter<CodeCfg>(){

                public void write(JsonWriter out, CodeCfg value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public CodeCfg read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CodeCfg.validateJsonObject(jsonObj);
                    CodeCfg instance = (CodeCfg)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

