/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="If specified, app is able to handle authorizationCode from auth request; exchanges it for `access_token` or/and `id_token`")
public class OAuthCfgExchangeAuthCode {
    public static final String SERIALIZED_NAME_TOKEN_URL = "tokenUrl";
    @SerializedName(value="tokenUrl")
    private String tokenUrl;
    public static final String SERIALIZED_NAME_CLIENT_ID = "clientId";
    @SerializedName(value="clientId")
    private String clientId;
    public static final String SERIALIZED_NAME_CLIENT_SECRET = "clientSecret";
    @SerializedName(value="clientSecret")
    private String clientSecret;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OAuthCfgExchangeAuthCode tokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://example.org/token", required=true, value="Url to get access token by authorisation code. ")
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public OAuthCfgExchangeAuthCode clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OAuth client id. Client must be registered on OAuth provider (e.g. facebook, google)")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuthCfgExchangeAuthCode clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OAuth client secret.")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuthCfgExchangeAuthCode putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthCfgExchangeAuthCode oauthCfgExchangeAuthCode = (OAuthCfgExchangeAuthCode)o;
        return Objects.equals(this.tokenUrl, oauthCfgExchangeAuthCode.tokenUrl) && Objects.equals(this.clientId, oauthCfgExchangeAuthCode.clientId) && Objects.equals(this.clientSecret, oauthCfgExchangeAuthCode.clientSecret) && Objects.equals(this.additionalProperties, oauthCfgExchangeAuthCode.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.tokenUrl, this.clientId, this.clientSecret, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthCfgExchangeAuthCode {\n");
        sb.append("    tokenUrl: ").append(this.toIndentedString(this.tokenUrl)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in OAuthCfgExchangeAuthCode is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOKEN_URL) != null && !jsonObj.get(SERIALIZED_NAME_TOKEN_URL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TOKEN_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `tokenUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOKEN_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLIENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `clientId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `clientSecret` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET).toString()));
        }
    }

    public static OAuthCfgExchangeAuthCode fromJson(String jsonString) throws IOException {
        return (OAuthCfgExchangeAuthCode)JSON.getGson().fromJson(jsonString, OAuthCfgExchangeAuthCode.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TOKEN_URL);
        openapiFields.add(SERIALIZED_NAME_CLIENT_ID);
        openapiFields.add(SERIALIZED_NAME_CLIENT_SECRET);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TOKEN_URL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!OAuthCfgExchangeAuthCode.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OAuthCfgExchangeAuthCode.class));
            return new TypeAdapter<OAuthCfgExchangeAuthCode>(){

                public void write(JsonWriter out, OAuthCfgExchangeAuthCode value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public OAuthCfgExchangeAuthCode read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    OAuthCfgExchangeAuthCode.validateJsonObject(jsonObj);
                    OAuthCfgExchangeAuthCode instance = (OAuthCfgExchangeAuthCode)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

