/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Forbids user to change password to the old one. Useful if you force user to change password regularly.")
public class PasswordHistoryCfg {
    public static final String SERIALIZED_NAME_PASSWORD_HISTORY_SIZE = "passwordHistorySize";
    @SerializedName(value="passwordHistorySize")
    private Integer passwordHistorySize = 3;
    public static final String SERIALIZED_NAME_PASSWORD_HISTORY_TTL = "passwordHistoryTtl";
    @SerializedName(value="passwordHistoryTtl")
    private String passwordHistoryTtl;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PasswordHistoryCfg passwordHistorySize(Integer passwordHistorySize) {
        this.passwordHistorySize = passwordHistorySize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of current user passwords to store in database.")
    public Integer getPasswordHistorySize() {
        return this.passwordHistorySize;
    }

    public void setPasswordHistorySize(Integer passwordHistorySize) {
        this.passwordHistorySize = passwordHistorySize;
    }

    public PasswordHistoryCfg passwordHistoryTtl(String passwordHistoryTtl) {
        this.passwordHistoryTtl = passwordHistoryTtl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Lifetime for the password. Accepts time string e.g. 1y, 3m, 2y 6m, etc.")
    public String getPasswordHistoryTtl() {
        return this.passwordHistoryTtl;
    }

    public void setPasswordHistoryTtl(String passwordHistoryTtl) {
        this.passwordHistoryTtl = passwordHistoryTtl;
    }

    public PasswordHistoryCfg putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PasswordHistoryCfg passwordHistoryCfg = (PasswordHistoryCfg)o;
        return Objects.equals(this.passwordHistorySize, passwordHistoryCfg.passwordHistorySize) && Objects.equals(this.passwordHistoryTtl, passwordHistoryCfg.passwordHistoryTtl) && Objects.equals(this.additionalProperties, passwordHistoryCfg.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.passwordHistorySize, this.passwordHistoryTtl, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordHistoryCfg {\n");
        sb.append("    passwordHistorySize: ").append(this.toIndentedString(this.passwordHistorySize)).append("\n");
        sb.append("    passwordHistoryTtl: ").append(this.toIndentedString(this.passwordHistoryTtl)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PasswordHistoryCfg is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWORD_HISTORY_TTL) != null && !jsonObj.get(SERIALIZED_NAME_PASSWORD_HISTORY_TTL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PASSWORD_HISTORY_TTL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `passwordHistoryTtl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWORD_HISTORY_TTL).toString()));
        }
    }

    public static PasswordHistoryCfg fromJson(String jsonString) throws IOException {
        return (PasswordHistoryCfg)JSON.getGson().fromJson(jsonString, PasswordHistoryCfg.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PASSWORD_HISTORY_SIZE);
        openapiFields.add(SERIALIZED_NAME_PASSWORD_HISTORY_TTL);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!PasswordHistoryCfg.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PasswordHistoryCfg.class));
            return new TypeAdapter<PasswordHistoryCfg>(){

                public void write(JsonWriter out, PasswordHistoryCfg value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public PasswordHistoryCfg read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PasswordHistoryCfg.validateJsonObject(jsonObj);
                    PasswordHistoryCfg instance = (PasswordHistoryCfg)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

