/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Rate limiter configuration")
public class RateLimiterCfg {
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private Boolean userId = true;
    public static final String SERIALIZED_NAME_IP = "ip";
    @SerializedName(value="ip")
    private Boolean ip = false;
    public static final String SERIALIZED_NAME_QUOTA = "quota";
    @SerializedName(value="quota")
    private Double quota = 1.0;
    public static final String SERIALIZED_NAME_PERIOD = "period";
    @SerializedName(value="period")
    private String period;
    public static final String SERIALIZED_NAME_ALIGN_LOAD = "alignLoad";
    @SerializedName(value="alignLoad")
    private Boolean alignLoad = false;
    public static final String SERIALIZED_NAME_PARENT = "parent";
    @SerializedName(value="parent")
    private String parent;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RateLimiterCfg userId(Boolean userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Create different rate limiters for different users.")
    public Boolean getUserId() {
        return this.userId;
    }

    public void setUserId(Boolean userId) {
        this.userId = userId;
    }

    public RateLimiterCfg ip(Boolean ip) {
        this.ip = ip;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Create different rate limiters for different ips.")
    public Boolean getIp() {
        return this.ip;
    }

    public void setIp(Boolean ip) {
        this.ip = ip;
    }

    public RateLimiterCfg quota(Double quota) {
        this.quota = quota;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total quota available for time period. Quota means \"weight\" of a request. So quota 1.0 and period 1s allows 10 request with weight 0.1 per seconds or 5 request with weight 0.2 per second.")
    public Double getQuota() {
        return this.quota;
    }

    public void setQuota(Double quota) {
        this.quota = quota;
    }

    public RateLimiterCfg period(String period) {
        this.period = period;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="30s", value="Quota restoring period ")
    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public RateLimiterCfg alignLoad(Boolean alignLoad) {
        this.alignLoad = alignLoad;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Insert delays between requests if there are too many simultaneous requests.")
    public Boolean getAlignLoad() {
        return this.alignLoad;
    }

    public void setAlignLoad(Boolean alignLoad) {
        this.alignLoad = alignLoad;
    }

    public RateLimiterCfg parent(String parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows to combine rate limiters. Let's say rt1 allows 10 reqs per seconds, and rt2 allows 20 reqs per minute. If the rt1 has the rt2 as a parent, that means that rt1 allows 10 reqs per seconds but not more than 20 per minute.")
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public RateLimiterCfg putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RateLimiterCfg rateLimiterCfg = (RateLimiterCfg)o;
        return Objects.equals(this.userId, rateLimiterCfg.userId) && Objects.equals(this.ip, rateLimiterCfg.ip) && Objects.equals(this.quota, rateLimiterCfg.quota) && Objects.equals(this.period, rateLimiterCfg.period) && Objects.equals(this.alignLoad, rateLimiterCfg.alignLoad) && Objects.equals(this.parent, rateLimiterCfg.parent) && Objects.equals(this.additionalProperties, rateLimiterCfg.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.ip, this.quota, this.period, this.alignLoad, this.parent, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RateLimiterCfg {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    quota: ").append(this.toIndentedString(this.quota)).append("\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    alignLoad: ").append(this.toIndentedString(this.alignLoad)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RateLimiterCfg is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PERIOD) != null && !jsonObj.get(SERIALIZED_NAME_PERIOD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PERIOD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `period` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PERIOD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PARENT) != null && !jsonObj.get(SERIALIZED_NAME_PARENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PARENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `parent` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARENT).toString()));
        }
    }

    public static RateLimiterCfg fromJson(String jsonString) throws IOException {
        return (RateLimiterCfg)JSON.getGson().fromJson(jsonString, RateLimiterCfg.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_USER_ID);
        openapiFields.add(SERIALIZED_NAME_IP);
        openapiFields.add(SERIALIZED_NAME_QUOTA);
        openapiFields.add(SERIALIZED_NAME_PERIOD);
        openapiFields.add(SERIALIZED_NAME_ALIGN_LOAD);
        openapiFields.add(SERIALIZED_NAME_PARENT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!RateLimiterCfg.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RateLimiterCfg.class));
            return new TypeAdapter<RateLimiterCfg>(){

                public void write(JsonWriter out, RateLimiterCfg value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public RateLimiterCfg read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RateLimiterCfg.validateJsonObject(jsonObj);
                    RateLimiterCfg instance = (RateLimiterCfg)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

