/*
 * Decompiled with CFR 0.152.
 */
package app.kntrl.client.openapi.model;

import app.kntrl.client.openapi.infra.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Long-living token used for generation of new access token. This is optional. You can set longer access-token lifetime instead.")
public class RefreshTokenCfg {
    public static final String SERIALIZED_NAME_TTL = "ttl";
    @SerializedName(value="ttl")
    private String ttl = "15d";
    public static final String SERIALIZED_NAME_MAX_TTL = "maxTtl";
    @SerializedName(value="maxTtl")
    private String maxTtl = "3M";
    public static final String SERIALIZED_NAME_UNAUTHENTICATED_TTL = "unauthenticatedTtl";
    @SerializedName(value="unauthenticatedTtl")
    private String unauthenticatedTtl = "1h";
    public static final String SERIALIZED_NAME_ALLOW_REUSE = "allowReuse";
    @SerializedName(value="allowReuse")
    private Boolean allowReuse = false;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RefreshTokenCfg ttl(String ttl) {
        this.ttl = ttl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3M", value="Lifetime for refresh token. 10d, 3M, etc. ")
    public String getTtl() {
        return this.ttl;
    }

    public void setTtl(String ttl) {
        this.ttl = ttl;
    }

    public RefreshTokenCfg maxTtl(String maxTtl) {
        this.maxTtl = maxTtl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1Y", value="Refresh token can be prolonged by refresh. ")
    public String getMaxTtl() {
        return this.maxTtl;
    }

    public void setMaxTtl(String maxTtl) {
        this.maxTtl = maxTtl;
    }

    public RefreshTokenCfg unauthenticatedTtl(String unauthenticatedTtl) {
        this.unauthenticatedTtl = unauthenticatedTtl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1d", value="Lifetime of token for unauthenticated session. Limits time that user has to sign in/up, restoring password etc. ")
    public String getUnauthenticatedTtl() {
        return this.unauthenticatedTtl;
    }

    public void setUnauthenticatedTtl(String unauthenticatedTtl) {
        this.unauthenticatedTtl = unauthenticatedTtl;
    }

    public RefreshTokenCfg allowReuse(Boolean allowReuse) {
        this.allowReuse = allowReuse;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If false - one refresh token can't be used twice. New refresh token will be provided by refresh API.")
    public Boolean getAllowReuse() {
        return this.allowReuse;
    }

    public void setAllowReuse(Boolean allowReuse) {
        this.allowReuse = allowReuse;
    }

    public RefreshTokenCfg putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefreshTokenCfg refreshTokenCfg = (RefreshTokenCfg)o;
        return Objects.equals(this.ttl, refreshTokenCfg.ttl) && Objects.equals(this.maxTtl, refreshTokenCfg.maxTtl) && Objects.equals(this.unauthenticatedTtl, refreshTokenCfg.unauthenticatedTtl) && Objects.equals(this.allowReuse, refreshTokenCfg.allowReuse) && Objects.equals(this.additionalProperties, refreshTokenCfg.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.ttl, this.maxTtl, this.unauthenticatedTtl, this.allowReuse, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RefreshTokenCfg {\n");
        sb.append("    ttl: ").append(this.toIndentedString(this.ttl)).append("\n");
        sb.append("    maxTtl: ").append(this.toIndentedString(this.maxTtl)).append("\n");
        sb.append("    unauthenticatedTtl: ").append(this.toIndentedString(this.unauthenticatedTtl)).append("\n");
        sb.append("    allowReuse: ").append(this.toIndentedString(this.allowReuse)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RefreshTokenCfg is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TTL) != null && !jsonObj.get(SERIALIZED_NAME_TTL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TTL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ttl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TTL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAX_TTL) != null && !jsonObj.get(SERIALIZED_NAME_MAX_TTL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MAX_TTL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `maxTtl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAX_TTL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNAUTHENTICATED_TTL) != null && !jsonObj.get(SERIALIZED_NAME_UNAUTHENTICATED_TTL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UNAUTHENTICATED_TTL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unauthenticatedTtl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNAUTHENTICATED_TTL).toString()));
        }
    }

    public static RefreshTokenCfg fromJson(String jsonString) throws IOException {
        return (RefreshTokenCfg)JSON.getGson().fromJson(jsonString, RefreshTokenCfg.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TTL);
        openapiFields.add(SERIALIZED_NAME_MAX_TTL);
        openapiFields.add(SERIALIZED_NAME_UNAUTHENTICATED_TTL);
        openapiFields.add(SERIALIZED_NAME_ALLOW_REUSE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!RefreshTokenCfg.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RefreshTokenCfg.class));
            return new TypeAdapter<RefreshTokenCfg>(){

                public void write(JsonWriter out, RefreshTokenCfg value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public RefreshTokenCfg read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RefreshTokenCfg.validateJsonObject(jsonObj);
                    RefreshTokenCfg instance = (RefreshTokenCfg)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

