/*
 * Decompiled with CFR 0.152.
 */
package com.darkrockstudios.libraries.mpfilepicker.windows.api;

import androidx.compose.runtime.internal.StabilityInferred;
import com.darkrockstudios.libraries.mpfilepicker.windows.win32.Comdlg32;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0013\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0002\u0010\tJ/\u0010\u0018\u001a\u00020\u00192\"\u0010\u0011\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00130\u0014j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0013`\u0012\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\b2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0013\"\u00020\b\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\bJ\u0010\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$J\u0010\u0010%\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$J\u0018\u0010&\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010'\u001a\u00020\"J\b\u0010(\u001a\u00020\bH\u0002J\u000e\u0010)\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\bR(\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0006R(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\r\"\u0004\b\u0010\u0010\u0006R,\u0010\u0011\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00130\u0014j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0013`\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/darkrockstudios/libraries/mpfilepicker/windows/api/WindowsFileChooser;", "", "<init>", "()V", "currentDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "currentDirectoryPath", "", "(Ljava/lang/String;)V", "value", "selectedFile", "getSelectedFile", "()Ljava/io/File;", "setSelectedFile", "getCurrentDirectory", "setCurrentDirectory", "filters", "Lkotlin/collections/ArrayList;", "", "Ljava/util/ArrayList;", "Ljava/util/ArrayList;", "defaultFilename", "dialogTitle", "setFilters", "", "(Ljava/util/ArrayList;)V", "addFilter", "name", "filter", "(Ljava/lang/String;[Ljava/lang/String;)V", "setTitle", "tname", "showOpenDialog", "", "parent", "Ljava/awt/Window;", "showSaveDialog", "showDialog", "open", "buildFilterString", "setDefaultFilename", "mpfilepicker"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nWindowsFileChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsFileChooser.kt\ncom/darkrockstudios/libraries/mpfilepicker/windows/api/WindowsFileChooser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,301:1\n37#2,2:302\n*S KotlinDebug\n*F\n+ 1 WindowsFileChooser.kt\ncom/darkrockstudios/libraries/mpfilepicker/windows/api/WindowsFileChooser\n*L\n146#1:302,2\n*E\n"})
public final class WindowsFileChooser {
    @Nullable
    private File selectedFile;
    @Nullable
    private File currentDirectory;
    @NotNull
    private ArrayList<String[]> filters = new ArrayList();
    @NotNull
    private String defaultFilename = "";
    @NotNull
    private String dialogTitle = "";
    public static final int $stable = 8;

    @Nullable
    public final File getSelectedFile() {
        return this.selectedFile;
    }

    protected final void setSelectedFile(@Nullable File file) {
        this.selectedFile = file;
    }

    @Nullable
    public final File getCurrentDirectory() {
        return this.currentDirectory;
    }

    protected final void setCurrentDirectory(@Nullable File file) {
        this.currentDirectory = file;
    }

    public WindowsFileChooser() {
    }

    public WindowsFileChooser(@Nullable File currentDirectory) {
        if (currentDirectory != null) {
            this.currentDirectory = currentDirectory.isDirectory() ? currentDirectory : currentDirectory.getParentFile();
        }
    }

    public WindowsFileChooser(@Nullable String currentDirectoryPath) {
        this(currentDirectoryPath != null ? new File(currentDirectoryPath) : null);
    }

    public final void setFilters(@NotNull ArrayList<String[]> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        this.filters = filters;
    }

    public final void addFilter(@NotNull String name, String ... filter) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter.length >= 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List parts = new ArrayList();
        parts.add(name);
        Collections.addAll(parts, Arrays.copyOf(filter, filter.length));
        Collection $this$toTypedArray$iv = parts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.filters.add(thisCollection$iv.toArray(new String[0]));
    }

    public final void setTitle(@NotNull String tname) {
        Intrinsics.checkNotNullParameter((Object)tname, (String)"tname");
        this.dialogTitle = tname;
    }

    public final boolean showOpenDialog(@Nullable Window parent) {
        return this.showDialog(parent, true);
    }

    public final boolean showSaveDialog(@Nullable Window parent) {
        return this.showDialog(parent, false);
    }

    public final boolean showDialog(@Nullable Window parent, boolean open) {
        boolean approved;
        Comdlg32.OpenFileName params = new Comdlg32.OpenFileName();
        params.Flags = 0x88000C;
        Window window = parent;
        params.hwndOwner = window == null ? null : Native.getWindowPointer((Window)window);
        int bufferLength = 260;
        int bufferSize = 4 * bufferLength + 1;
        params.lpstrFile = (Pointer)new Memory((long)bufferSize);
        if (((CharSequence)this.defaultFilename).length() > 0) {
            Pointer pointer = params.lpstrFile;
            if (pointer != null) {
                pointer.setWideString(0L, this.defaultFilename);
            }
        } else {
            Pointer pointer = params.lpstrFile;
            if (pointer != null) {
                pointer.clear((long)bufferSize);
            }
        }
        if (!(((CharSequence)this.dialogTitle).length() == 0)) {
            params.lpstrTitle = new WString(this.dialogTitle);
        }
        params.nMaxFile = bufferLength;
        if (this.currentDirectory != null) {
            File file = this.currentDirectory;
            Intrinsics.checkNotNull((Object)file);
            params.lpstrInitialDir = new WString(file.getAbsolutePath());
        }
        if (this.filters.size() > 0) {
            params.lpstrFilter = new WString(this.buildFilterString());
            params.nFilterIndex = 1;
        }
        boolean bl = approved = open ? Comdlg32.INSTANCE.GetOpenFileNameW(params) : Comdlg32.INSTANCE.GetSaveFileNameW(params);
        if (approved) {
            File dir;
            Pointer pointer = params.lpstrFile;
            String filePath = pointer != null ? pointer.getWideString(0L) : null;
            File file = this.selectedFile = new File(filePath);
            Intrinsics.checkNotNull((Object)file);
            this.currentDirectory = dir = file.getParentFile();
        } else {
            int errCode = Comdlg32.INSTANCE.CommDlgExtendedError();
            if (errCode != 0) {
                throw new RuntimeException("GetOpenFileName failed with error " + errCode);
            }
        }
        return approved;
    }

    private final String buildFilterString() {
        StringBuilder filterStr = new StringBuilder();
        Iterator<String[]> iterator = this.filters.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<String[]> iterator2 = iterator;
        while (iterator2.hasNext()) {
            String[] spec;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            String label = spec[0];
            filterStr.append(label);
            filterStr.append('\u0000');
            int n = spec.length;
            for (int i = 1; i < n; ++i) {
                filterStr.append("*.");
                filterStr.append(spec[i]);
                filterStr.append(';');
            }
            filterStr.deleteCharAt(filterStr.length() - 1);
            filterStr.append('\u0000');
        }
        filterStr.append('\u0000');
        String string = filterStr.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void setDefaultFilename(@NotNull String defaultFilename) {
        Intrinsics.checkNotNullParameter((Object)defaultFilename, (String)"defaultFilename");
        this.defaultFilename = defaultFilename;
    }
}

