/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.apm.log.method.aspectj;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.ClassUtils;

@ConfigurationProperties(prefix="myoss-cloud.log.method")
public class MonitorMethodProperties {
    private String appName;
    private Set<String> dynamicExcludeClass;
    private Set<Class> excludeClass;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    private String controllerExceptionErrorCode = "systemException";
    private String controllerExceptionErrorMsg = "We'll be back soon ...";

    @PostConstruct
    public void init() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (this.dynamicExcludeClass == null) {
            this.dynamicExcludeClass = new LinkedHashSet<String>();
        }
        if (this.excludeClass == null) {
            this.excludeClass = new LinkedHashSet<Class>();
        }
        this.dynamicExcludeClass.add("javax.servlet.ServletRequest");
        this.dynamicExcludeClass.add("javax.servlet.ServletResponse");
        for (String item : this.dynamicExcludeClass) {
            if (!ClassUtils.isPresent((String)item, (ClassLoader)classLoader)) continue;
            Class aClass = ClassUtils.resolveClassName((String)item, (ClassLoader)classLoader);
            this.excludeClass.add(aClass);
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public Set<String> getDynamicExcludeClass() {
        return this.dynamicExcludeClass;
    }

    public Set<Class> getExcludeClass() {
        return this.excludeClass;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getControllerExceptionErrorCode() {
        return this.controllerExceptionErrorCode;
    }

    public String getControllerExceptionErrorMsg() {
        return this.controllerExceptionErrorMsg;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setDynamicExcludeClass(Set<String> dynamicExcludeClass) {
        this.dynamicExcludeClass = dynamicExcludeClass;
    }

    public void setExcludeClass(Set<Class> excludeClass) {
        this.excludeClass = excludeClass;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setControllerExceptionErrorCode(String controllerExceptionErrorCode) {
        this.controllerExceptionErrorCode = controllerExceptionErrorCode;
    }

    public void setControllerExceptionErrorMsg(String controllerExceptionErrorMsg) {
        this.controllerExceptionErrorMsg = controllerExceptionErrorMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitorMethodProperties)) {
            return false;
        }
        MonitorMethodProperties other = (MonitorMethodProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        Set<String> this$dynamicExcludeClass = this.getDynamicExcludeClass();
        Set<String> other$dynamicExcludeClass = other.getDynamicExcludeClass();
        if (this$dynamicExcludeClass == null ? other$dynamicExcludeClass != null : !((Object)this$dynamicExcludeClass).equals(other$dynamicExcludeClass)) {
            return false;
        }
        Set<Class> this$excludeClass = this.getExcludeClass();
        Set<Class> other$excludeClass = other.getExcludeClass();
        if (this$excludeClass == null ? other$excludeClass != null : !((Object)this$excludeClass).equals(other$excludeClass)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        String this$controllerExceptionErrorCode = this.getControllerExceptionErrorCode();
        String other$controllerExceptionErrorCode = other.getControllerExceptionErrorCode();
        if (this$controllerExceptionErrorCode == null ? other$controllerExceptionErrorCode != null : !this$controllerExceptionErrorCode.equals(other$controllerExceptionErrorCode)) {
            return false;
        }
        String this$controllerExceptionErrorMsg = this.getControllerExceptionErrorMsg();
        String other$controllerExceptionErrorMsg = other.getControllerExceptionErrorMsg();
        return !(this$controllerExceptionErrorMsg == null ? other$controllerExceptionErrorMsg != null : !this$controllerExceptionErrorMsg.equals(other$controllerExceptionErrorMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitorMethodProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        Set<String> $dynamicExcludeClass = this.getDynamicExcludeClass();
        result = result * 59 + ($dynamicExcludeClass == null ? 43 : ((Object)$dynamicExcludeClass).hashCode());
        Set<Class> $excludeClass = this.getExcludeClass();
        result = result * 59 + ($excludeClass == null ? 43 : ((Object)$excludeClass).hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        String $controllerExceptionErrorCode = this.getControllerExceptionErrorCode();
        result = result * 59 + ($controllerExceptionErrorCode == null ? 43 : $controllerExceptionErrorCode.hashCode());
        String $controllerExceptionErrorMsg = this.getControllerExceptionErrorMsg();
        result = result * 59 + ($controllerExceptionErrorMsg == null ? 43 : $controllerExceptionErrorMsg.hashCode());
        return result;
    }

    public String toString() {
        return "MonitorMethodProperties(appName=" + this.getAppName() + ", dynamicExcludeClass=" + this.getDynamicExcludeClass() + ", excludeClass=" + this.getExcludeClass() + ", dateFormat=" + this.getDateFormat() + ", controllerExceptionErrorCode=" + this.getControllerExceptionErrorCode() + ", controllerExceptionErrorMsg=" + this.getControllerExceptionErrorMsg() + ")";
    }
}

