/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.apm.log.method.aspectj;

import app.myoss.cloud.apm.log.method.aspectj.AbstractMonitorMethod;
import app.myoss.cloud.apm.log.method.aspectj.annotation.MonitorMethodAdvice;
import com.alibaba.fastjson.JSONObject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
@MonitorMethodAdvice
public class MonitorMethodAfter
extends AbstractMonitorMethod {
    private static final Logger log = LoggerFactory.getLogger((String)"MonitorMethod");

    @Pointcut(value="execution(@org.springframework.web.bind.annotation.ExceptionHandler * *(..)) || execution(@org.springframework.scheduling.annotation.Scheduled * *(..)) || @within(app.myoss.cloud.apm.log.method.aspectj.annotation.LogUnMonitor) || @annotation(app.myoss.cloud.apm.log.method.aspectj.annotation.LogUnMonitor) || @within(app.myoss.cloud.apm.log.method.aspectj.annotation.LogMethodAround) || @annotation(app.myoss.cloud.apm.log.method.aspectj.annotation.LogMethodAround)")
    public void unWantToMatch() {
    }

    @Pointcut(value="@within(app.myoss.cloud.apm.log.method.aspectj.annotation.LogMethodAfter) || @annotation(app.myoss.cloud.apm.log.method.aspectj.annotation.LogMethodAfter)")
    public void wantToMatch() {
    }

    @Pointcut(value="wantToMatch() && ! unWantToMatch()")
    public void allWantToMatch() {
    }

    @AfterReturning(value="allWantToMatch()", returning="result")
    public void doAfterReturning(JoinPoint joinPoint, Object result) {
        Signature signature = joinPoint.getSignature();
        String methodName = signature.getDeclaringTypeName() + "#" + signature.getName();
        Logger logger = LoggerFactory.getLogger((String)methodName);
        JSONObject jsonAfter = new JSONObject();
        jsonAfter.put("end", (Object)System.currentTimeMillis());
        jsonAfter.put("result", result);
        jsonAfter.put("app", (Object)this.properties.getAppName());
        logger.info(this.toJSONString(jsonAfter));
    }
}

