/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.apm.spring.config;

import app.myoss.cloud.core.constants.DeployEnvEnum;
import app.myoss.cloud.core.spring.boot.config.CoreCommonEnvironmentPostProcessor;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.util.ClassUtils;

@EnableConfigurationProperties(value={WebEndpointProperties.class})
@ConditionalOnClass(value={WebEndpointProperties.class})
@Configuration
public class ApmWebEndpointEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered,
SmartApplicationListener {
    private static final DeferredLog LOGGER = new DeferredLog();

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        HashMap<String, String> map = new HashMap<String, String>();
        if (!DeployEnvEnum.isDev()) {
            map.put("management.server.port", "8088");
        }
        map.put("management.endpoints.enabled-by-default", "true");
        map.put("management.endpoints.web.base-path", "/");
        map.put("management.endpoint.loggers.enabled", "true");
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (ClassUtils.isPresent((String)"io.prometheus.client.exporter.common.TextFormat", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"io.prometheus.client.CollectorRegistry", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"org.springframework.boot.actuate.metrics.export.prometheus.PrometheusScrapeEndpoint", (ClassLoader)classLoader)) {
            map.put("management.endpoint.prometheus.enabled", "true");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("config APM WebEndpoint: " + JSON.toJSONString(map)));
        }
        CoreCommonEnvironmentPostProcessor.addOrReplace((MutablePropertySources)propertySources, map);
    }

    public int getOrder() {
        return -2147483628;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationPreparedEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            LOGGER.replayTo(ApmWebEndpointEnvironmentPostProcessor.class);
        }
    }
}

