/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.apm.spring.config;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import io.prometheus.client.hotspot.DefaultExports;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.metrics.export.prometheus.PrometheusScrapeEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={WebEndpointProperties.class})
@ConditionalOnClass(value={TextFormat.class, CollectorRegistry.class, PrometheusScrapeEndpoint.class})
@ConditionalOnEnabledEndpoint(endpoint=PrometheusScrapeEndpoint.class)
@Configuration
public class PrometheusEndpointAutoConfiguration {
    private WebEndpointProperties webEndpointProperties;

    public PrometheusEndpointAutoConfiguration(WebEndpointProperties webEndpointProperties) {
        this.webEndpointProperties = webEndpointProperties;
    }

    @ConditionalOnMissingBean
    @Bean
    public CollectorRegistry collectorRegistry() {
        DefaultExports.initialize();
        return CollectorRegistry.defaultRegistry;
    }

    @ConditionalOnMissingBean
    @Bean
    public PrometheusScrapeEndpoint prometheusEndpoint(CollectorRegistry collectorRegistry) {
        WebEndpointProperties.Exposure exposure = this.webEndpointProperties.getExposure();
        exposure.getInclude().add("prometheus");
        return new PrometheusScrapeEndpoint(collectorRegistry);
    }
}

