/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.apm.log.method.aspectj;

import app.myoss.cloud.apm.log.method.aspectj.MonitorMethodProperties;
import app.myoss.cloud.core.lang.json.JsonApi;
import app.myoss.cloud.core.utils.JacksonMapper;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMonitorMethod {
    @Autowired
    protected MonitorMethodProperties properties;
    private JacksonMapper jacksonMapper;
    private Object gson;

    protected Object[] convertArgs(Object[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            Object value = arguments[i];
            if (value == null) continue;
            this.convertArgs(arguments, i, value);
        }
        return arguments;
    }

    protected void convertArgs(Object[] arguments, int i, Object value) {
        if (value instanceof Writer) {
            arguments[i] = value.getClass().getName();
        } else {
            for (Class exclude : this.properties.getExcludeClass()) {
                if (!exclude.isInstance(value)) continue;
                arguments[i] = value.getClass().getName();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String toJSONString(Object input) {
        if (JsonApi.JACKSON_2_PRESENT) {
            if (this.jacksonMapper == null) {
                AbstractMonitorMethod abstractMonitorMethod = this;
                synchronized (abstractMonitorMethod) {
                    if (this.jacksonMapper == null) {
                        this.jacksonMapper = new JacksonMapper();
                        this.jacksonMapper.getMapper().setDateFormat((DateFormat)new SimpleDateFormat(this.properties.getDateFormat()));
                    }
                }
            }
            return this.jacksonMapper.toJson(input);
        }
        if (JsonApi.GSON_PRESENT) {
            if (this.gson == null) {
                AbstractMonitorMethod abstractMonitorMethod = this;
                synchronized (abstractMonitorMethod) {
                    if (this.gson == null) {
                        this.gson = new GsonBuilder().serializeNulls().setDateFormat(this.properties.getDateFormat()).create();
                    }
                }
            }
            return ((Gson)this.gson).toJson(input);
        }
        if (JsonApi.FASTJSON_PRESENT) {
            return JSONObject.toJSONStringWithDateFormat((Object)input, (String)this.properties.getDateFormat(), (SerializerFeature[])new SerializerFeature[0]);
        }
        throw new UnsupportedOperationException("please add json dependency: gson or fastjson or jackson ");
    }
}

