/*
 * Copyright 2018-2018 https://github.com/myoss
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package app.myoss.cloud.apm.log.method.aspectj.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 记录方法的返回值，放在class上记录所有的Method，放在Method上记录当前方法
 * <p>
 * 和{@link LogUnMonitor}互斥关系，如果两者都存在，将会排除{@link LogUnMonitor}匹配的方法
 * <p>
 * 和{@link LogMethodAround}互斥关系，如果两者都存在，将会使用{@link LogMethodAround}匹配的方法
 *
 * @author Jerry.Chen
 * @since 2018年4月11日 上午11:06:24
 */
@Target({ ElementType.METHOD, ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface LogMethodAfter {
}
