/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.apm.log.method.aspectj;

import app.myoss.cloud.apm.log.method.aspectj.AbstractMonitorMethod;
import app.myoss.cloud.apm.log.method.aspectj.annotation.MonitorMethodAdvice;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
@MonitorMethodAdvice
public class MonitorMethodAround
extends AbstractMonitorMethod {
    private static final Logger log = LoggerFactory.getLogger((String)"MonitorMethod");

    @Pointcut(value="execution(@org.springframework.web.bind.annotation.ExceptionHandler * *(..)) || execution(@org.springframework.scheduling.annotation.Scheduled * *(..)) || @within(app.myoss.cloud.apm.log.method.aspectj.annotation.LogUnMonitor) || @annotation(app.myoss.cloud.apm.log.method.aspectj.annotation.LogUnMonitor)")
    public void unWantToMatch() {
    }

    @Pointcut(value="@within(app.myoss.cloud.apm.log.method.aspectj.annotation.LogMethodAround) || @annotation(app.myoss.cloud.apm.log.method.aspectj.annotation.LogMethodAround)")
    public void wantToMatch() {
    }

    @Pointcut(value="wantToMatch() && ! unWantToMatch()")
    public void allWantToMatch() {
    }

    @Around(value="allWantToMatch()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        long startTimeMillis = System.currentTimeMillis();
        long start = System.nanoTime();
        Signature signature = joinPoint.getSignature();
        String methodName = signature.getDeclaringTypeName() + "#" + signature.getName();
        Logger logger = LoggerFactory.getLogger((String)methodName);
        JSONObject jsonBefore = new JSONObject();
        jsonBefore.put("start", (Object)startTimeMillis);
        jsonBefore.put("args", (Object)this.convertArgs(joinPoint.getArgs()));
        jsonBefore.put("app", (Object)this.properties.getAppName());
        logger.info(this.toJSONString(jsonBefore));
        Object result = joinPoint.proceed();
        long costTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        JSONObject jsonAfter = new JSONObject();
        jsonAfter.put("start", (Object)startTimeMillis);
        jsonAfter.put("end", (Object)System.currentTimeMillis());
        jsonAfter.put("cost", (Object)costTime);
        jsonAfter.put("result", result);
        jsonAfter.put("app", (Object)this.properties.getAppName());
        logger.info(this.toJSONString(jsonAfter));
        return result;
    }
}

