/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.apm.spring.job;

import app.myoss.cloud.apm.spring.job.AutoRollingLogFileProperties;
import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class AutoRollingLogFileJob {
    private static final Logger log = LoggerFactory.getLogger(AutoRollingLogFileJob.class);
    private AutoRollingLogFileProperties autoRollingLogFileProperties;

    @Scheduled(cron="${myoss-cloud.log.auto-rolling-log-file.cron:0 10 0 * * ?}")
    public void checkAndRollFile() {
        ArrayList<ch.qos.logback.classic.Logger> loggers = new ArrayList<ch.qos.logback.classic.Logger>();
        List<String> loggerNames = this.autoRollingLogFileProperties.getLoggerNames();
        for (String loggerName : loggerNames) {
            Logger logger = LoggerFactory.getLogger((String)loggerName);
            if (!(logger instanceof ch.qos.logback.classic.Logger)) {
                log.warn("Logger {} is not ch.qos.logback.classic.Logger, ignore", (Object)loggerName);
                return;
            }
            loggers.add((ch.qos.logback.classic.Logger)logger);
        }
        LoggingEvent event = new LoggingEvent();
        List<String> rollingFileAppenderNames = this.autoRollingLogFileProperties.getRollingFileAppenderNames();
        for (String appenderName : rollingFileAppenderNames) {
            String fileName;
            RollingFileAppender file = this.getRollingFileAppender(loggers, appenderName);
            if (file == null) {
                log.warn("{} is null, ignore check and roll file", (Object)appenderName);
                continue;
            }
            TriggeringPolicy triggeringPolicy = file.getTriggeringPolicy();
            if (!triggeringPolicy.isTriggeringEvent(new File(fileName = file.getFile()), (Object)event)) continue;
            log.info("{} rollover begin", (Object)fileName);
            file.rollover();
            log.info("{} rollover complete", (Object)fileName);
        }
    }

    private RollingFileAppender getRollingFileAppender(List<ch.qos.logback.classic.Logger> loggers, String appenderName) {
        for (ch.qos.logback.classic.Logger logger : loggers) {
            Appender appender = logger.getAppender(appenderName);
            if (appender instanceof RollingFileAppender) {
                return (RollingFileAppender)appender;
            }
            Iterator appenderEvents = logger.iteratorForAppenders();
            while (appenderEvents.hasNext()) {
                AsyncAppender asyncAppender;
                Appender next = (Appender)appenderEvents.next();
                if (!(next instanceof AsyncAppender) || !((appender = (asyncAppender = (AsyncAppender)next).getAppender(appenderName)) instanceof RollingFileAppender)) continue;
                return (RollingFileAppender)appender;
            }
        }
        return null;
    }

    public AutoRollingLogFileJob(AutoRollingLogFileProperties autoRollingLogFileProperties) {
        this.autoRollingLogFileProperties = autoRollingLogFileProperties;
    }
}

