/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.apm.spring.cloud.sleuth.trace;

import brave.internal.Nullable;
import brave.internal.Platform;
import brave.internal.codec.HexCodec;
import org.slf4j.MDC;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class ApplicationEventTracer {
    public long nextId() {
        long nextId = Platform.get().randomLong();
        while (nextId == 0L) {
            nextId = Platform.get().randomLong();
        }
        return nextId;
    }

    public void setTraceId(String traceId) {
        this.replace("traceId", traceId);
        this.replace("spanId", traceId);
        this.replace("X-B3-TraceId", traceId);
        this.replace("X-B3-SpanId", traceId);
    }

    public void replace(String key, @Nullable String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        } else {
            MDC.remove((String)key);
        }
    }

    public String startApplication() {
        String traceId = HexCodec.toLowerHex((long)this.nextId());
        this.setTraceId(traceId);
        return traceId;
    }

    public void startedApplication(ConfigurableApplicationContext applicationContext) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        beanFactory.registerSingleton("applicationEventTracer", (Object)this);
        this.setTraceId(null);
    }

    public static String getSpanId() {
        String spanId = MDC.get((String)"X-B3-SpanId");
        return spanId != null ? spanId : MDC.get((String)"spanId");
    }

    public static String getTraceId() {
        String traceId = MDC.get((String)"X-B3-TraceId");
        return traceId != null ? traceId : MDC.get((String)"traceId");
    }
}

