/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.cache.redis;

import app.myoss.cloud.cache.redis.RedisLockServiceImpl;
import app.myoss.cloud.cache.redis.RedisProperties;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.EventListener;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;

@Import(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={RedisProperties.class})
@ConditionalOnClass(value={RedisOperations.class})
@Configuration
public class RedisLockServiceAutoConfiguration {
    private RedisProperties redisProperties;

    public RedisLockServiceAutoConfiguration(RedisProperties redisProperties) {
        this.redisProperties = redisProperties;
    }

    @ConditionalOnBean(name={"redisTemplate"})
    @ConditionalOnMissingBean
    @Bean
    public RedisLockServiceImpl redisLockService(StringRedisTemplate redisTemplate) {
        TimeUnit timeUnit = this.redisProperties.getLockTimeUnit();
        return new RedisLockServiceImpl((RedisTemplate)redisTemplate, timeUnit);
    }

    @EventListener
    public void initRedisConnection(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map stringRedisTemplateMap = applicationContext.getBeansOfType(StringRedisTemplate.class);
        if (CollectionUtils.isEmpty((Map)stringRedisTemplateMap)) {
            return;
        }
        for (Map.Entry entry : stringRedisTemplateMap.entrySet()) {
            StringRedisTemplate redisTemplate = (StringRedisTemplate)entry.getValue();
            String key = this.getClass().getName() + ".test";
            redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"init redis connection", Duration.ofSeconds(10L));
        }
    }
}

