/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.cache.redis;

import app.myoss.cloud.cache.lock.LockService;
import app.myoss.cloud.cache.lock.functions.LockFunction;
import app.myoss.cloud.cache.lock.functions.LockFunctionGeneric;
import app.myoss.cloud.cache.lock.functions.LockFunctionGenericWithArgs;
import app.myoss.cloud.cache.lock.functions.LockFunctionWithArgs;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisLockServiceImpl
implements LockService {
    private RedisTemplate redisTemplate;
    private TimeUnit timeUnit;

    @Override
    public boolean getLock(Serializable key, int expireTime, TimeUnit timeUnit) {
        Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"1", (long)expireTime, timeUnit);
        return Objects.equals(result, true);
    }

    @Override
    public boolean getLock(Serializable key, int expireTime) {
        return this.getLock(key, expireTime, this.timeUnit);
    }

    @Override
    public boolean releaseLock(Serializable key) {
        Boolean delete = this.redisTemplate.delete((Object)key);
        return Objects.equals(delete, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeByLock(Serializable key, int expireTime, LockFunction callback) {
        long begin = System.currentTimeMillis();
        boolean isGetLock = this.getLock(key, expireTime);
        try {
            if (isGetLock) {
                callback.onLockSuccess();
            } else {
                int tryLockTimes = callback.tryLockTimes();
                if (tryLockTimes <= 1) {
                    callback.onLockFailed();
                } else {
                    for (int i = 1; i < tryLockTimes; ++i) {
                        LockService.sleep(callback.tryLockSleepTime());
                        begin = System.currentTimeMillis();
                        isGetLock = this.getLock(key, expireTime);
                        if (isGetLock) break;
                    }
                    if (isGetLock) {
                        callback.onLockSuccess();
                    } else {
                        callback.onLockFailed();
                    }
                }
            }
        }
        finally {
            long expireTimeToMills;
            long cost;
            if (isGetLock && (cost = System.currentTimeMillis() - begin) < (expireTimeToMills = this.timeUnit.toMillis(expireTime))) {
                this.releaseLock(key);
            }
        }
        return isGetLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeByLock(Serializable key, int expireTime, LockFunctionWithArgs callback, Object ... args) {
        long begin = System.currentTimeMillis();
        boolean isGetLock = this.getLock(key, expireTime);
        try {
            if (isGetLock) {
                callback.onLockSuccess(args);
            } else {
                int tryLockTimes = callback.tryLockTimes();
                if (tryLockTimes <= 1) {
                    callback.onLockFailed(args);
                } else {
                    for (int i = 1; i < tryLockTimes; ++i) {
                        LockService.sleep(callback.tryLockSleepTime());
                        begin = System.currentTimeMillis();
                        isGetLock = this.getLock(key, expireTime);
                        if (isGetLock) break;
                    }
                    if (isGetLock) {
                        callback.onLockSuccess(args);
                    } else {
                        callback.onLockFailed(args);
                    }
                }
            }
        }
        finally {
            long expireTimeToMills;
            long cost;
            if (isGetLock && (cost = System.currentTimeMillis() - begin) < (expireTimeToMills = this.timeUnit.toMillis(expireTime))) {
                this.releaseLock(key);
            }
        }
        return isGetLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeByLock(Serializable key, int expireTime, LockFunctionGeneric<T> callback) {
        long begin = System.currentTimeMillis();
        boolean isGetLock = this.getLock(key, expireTime);
        try {
            if (isGetLock) {
                T t = callback.onLockSuccess();
                return t;
            }
            int tryLockTimes = callback.tryLockTimes();
            if (tryLockTimes <= 1) {
                T cost = callback.onLockFailed();
                return cost;
            }
            for (int i = 1; i < tryLockTimes; ++i) {
                LockService.sleep(callback.tryLockSleepTime());
                begin = System.currentTimeMillis();
                isGetLock = this.getLock(key, expireTime);
                if (isGetLock) break;
            }
            if (isGetLock) {
                T t = callback.onLockSuccess();
                return t;
            }
            T t = callback.onLockFailed();
            return t;
        }
        finally {
            long expireTimeToMills;
            long cost;
            if (isGetLock && (cost = System.currentTimeMillis() - begin) < (expireTimeToMills = this.timeUnit.toMillis(expireTime))) {
                this.releaseLock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeByLock(Serializable key, int expireTime, LockFunctionGenericWithArgs<T> callback, Object ... args) {
        long begin = System.currentTimeMillis();
        boolean isGetLock = this.getLock(key, expireTime);
        try {
            if (isGetLock) {
                T t = callback.onLockSuccess(args);
                return t;
            }
            int tryLockTimes = callback.tryLockTimes();
            if (tryLockTimes <= 1) {
                T cost = callback.onLockFailed(args);
                return cost;
            }
            for (int i = 1; i < tryLockTimes; ++i) {
                LockService.sleep(callback.tryLockSleepTime());
                begin = System.currentTimeMillis();
                isGetLock = this.getLock(key, expireTime);
                if (isGetLock) break;
            }
            if (isGetLock) {
                T t = callback.onLockSuccess(args);
                return t;
            }
            T t = callback.onLockFailed(args);
            return t;
        }
        finally {
            long expireTimeToMills;
            long cost;
            if (isGetLock && (cost = System.currentTimeMillis() - begin) < (expireTimeToMills = this.timeUnit.toMillis(expireTime))) {
                this.releaseLock(key);
            }
        }
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisLockServiceImpl)) {
            return false;
        }
        RedisLockServiceImpl other = (RedisLockServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisTemplate this$redisTemplate = this.getRedisTemplate();
        RedisTemplate other$redisTemplate = other.getRedisTemplate();
        if (this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate)) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisLockServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisTemplate $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        return result;
    }

    public String toString() {
        return "RedisLockServiceImpl(redisTemplate=" + this.getRedisTemplate() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ")";
    }

    public RedisLockServiceImpl(RedisTemplate redisTemplate, TimeUnit timeUnit) {
        this.redisTemplate = redisTemplate;
        this.timeUnit = timeUnit;
    }
}

