/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.utils;

import org.apache.commons.lang3.StringUtils;

public enum NameStyle {
    ORIGIN("origin", "\u548c\u5c5e\u6027\u540d\u4fdd\u6301\u4e00\u81f4", new String[]{"origin", "_origin", "origin_"}){

        @Override
        public String transform(String s) {
            return s;
        }
    }
    ,
    SNAKE_CASE("snake_case", "\u9a7c\u5cf0\u8f6c\u4e0b\u5212\u7ebf\uff0c\u5355\u8bcd\u5c0f\u5199", new String[]{"snake_case", "_snake_case", "snake_case_"}){

        @Override
        public String transform(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return s;
            }
            String[] split = StringUtils.splitByCharacterTypeCamelCase((String)s);
            int length = split.length;
            StringBuilder builder = new StringBuilder(s.length() + length);
            int lastIndex = length - 1;
            for (int i = 0; i < length; ++i) {
                String word = split[i];
                if ("_".equals(word)) {
                    if (i != 0) continue;
                    builder.append(word);
                    continue;
                }
                builder.append(word.toLowerCase());
                if (i == lastIndex) continue;
                builder.append("_");
            }
            return builder.toString();
        }
    }
    ,
    SCREAMING_SNAKE_CASE("SCREAMING_SNAKE_CASE", "\u9a7c\u5cf0\u8f6c\u4e0b\u5212\u7ebf\uff0c\u5355\u8bcd\u5927\u5199", new String[]{"SNAKE_CASE", "_SNAKE_CASE", "SNAKE_CASE_"}){

        @Override
        public String transform(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return s;
            }
            String[] split = StringUtils.splitByCharacterTypeCamelCase((String)s);
            int length = split.length;
            StringBuilder builder = new StringBuilder(s.length() + length);
            int lastIndex = length - 1;
            for (int i = 0; i < length; ++i) {
                String word = split[i];
                if ("_".equals(word)) {
                    if (i != 0) continue;
                    builder.append(word);
                    continue;
                }
                builder.append(word.toUpperCase());
                if (i == lastIndex) continue;
                builder.append("_");
            }
            return builder.toString();
        }
    }
    ,
    UPPER_CASE("UPPERCASE", "\u8f6c\u6362\u4e3a\u5927\u5199", new String[]{"UPPERCASE", "_UPPERCASE", "UPPERCASE_"}){

        @Override
        public String transform(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return s;
            }
            return s.toUpperCase();
        }
    }
    ,
    LOWER_CASE("lowercase", "\u8f6c\u6362\u4e3a\u5c0f\u5199", new String[]{"lowercase", "_lowercase", "lowercase_"}){

        @Override
        public String transform(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return s;
            }
            return s.toLowerCase();
        }
    }
    ,
    PASCAL_CASE("PascalCase", "\u5927\u9a7c\u5cf0\u547d\u540d\u6cd5", new String[]{"PascalCase", "_PascalCase", "PascalCase_"}){

        @Override
        public String transform(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return s;
            }
            String[] split = StringUtils.splitByCharacterTypeCamelCase((String)s);
            int length = split.length;
            StringBuilder builder = new StringBuilder(s.length());
            int lastIndex = length - 1;
            for (int i = 0; i < length; ++i) {
                String word = split[i];
                if ("_".equals(word)) {
                    if (i != 0 && i != lastIndex) continue;
                    builder.append(word);
                    continue;
                }
                builder.append(StringUtils.capitalize((String)word));
            }
            return builder.toString();
        }
    }
    ,
    CAMEL_CASE("camelCase", "\u5c0f\u9a7c\u5cf0\u547d\u540d\u6cd5", new String[]{"camelCase", "_camelCase", "camelCase_"}){

        @Override
        public String transform(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return s;
            }
            String[] split = StringUtils.splitByCharacterTypeCamelCase((String)s);
            int length = split.length;
            StringBuilder builder = new StringBuilder(s.length());
            int lastIndex = length - 1;
            for (int i = 0; i < length; ++i) {
                String word = split[i];
                if ("_".equals(word)) {
                    if (i != 0 && i != lastIndex) continue;
                    builder.append(word);
                    continue;
                }
                if (i == 0) {
                    builder.append(StringUtils.uncapitalize((String)word));
                    continue;
                }
                builder.append(StringUtils.capitalize((String)word));
            }
            return builder.toString();
        }
    };

    String type;
    String desc;
    String[] example;

    public abstract String transform(String var1);

    private NameStyle(String type, String desc, String[] example) {
        this.type = type;
        this.desc = desc;
        this.example = example;
    }
}

