/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.dto;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = -8699167988071027834L;
    private T value;
    private boolean success = true;
    private String errorCode;
    private String errorMsg;
    private Map<String, Object> extraInfo;

    public Result() {
    }

    public Result(T value) {
        this();
        this.value = value;
    }

    public Result(String errorCode, String errorMsg) {
        this(false, errorCode, errorMsg);
    }

    public Result(boolean success, String errorCode, String errorMsg) {
        this(null, success, errorCode, errorMsg);
    }

    public Result(T value, boolean success, String errorCode, String errorMsg) {
        this.success = success;
        this.value = value;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public Result<T> addExtraInfo(String key, Object value) {
        if (this.extraInfo == null) {
            this.extraInfo = new HashMap<String, Object>();
        }
        this.extraInfo.put(key, value);
        return this;
    }

    public Object getExtraInfo(String key) {
        return this.extraInfo != null ? this.extraInfo.get(key) : null;
    }

    public String toString() {
        return JSONObject.toJSONString((Object)this);
    }

    public Result(T value, boolean success, String errorCode, String errorMsg, Map<String, Object> extraInfo) {
        this.value = value;
        this.success = success;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.extraInfo = extraInfo;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Map<String, Object> getExtraInfo() {
        return this.extraInfo;
    }

    public Result<T> setValue(T value) {
        this.value = value;
        return this;
    }

    public Result<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public Result<T> setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public Result<T> setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public Result<T> setExtraInfo(Map<String, Object> extraInfo) {
        this.extraInfo = extraInfo;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        Map<String, Object> this$extraInfo = this.getExtraInfo();
        Map<String, Object> other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !((Object)this$extraInfo).equals(other$extraInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        Map<String, Object> $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : ((Object)$extraInfo).hashCode());
        return result;
    }
}

