/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.dto;

import app.myoss.cloud.core.lang.dto.Direction;
import app.myoss.cloud.core.lang.dto.Order;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@JSONType(deserializer=ModelValueDeserializer.class)
public class Sort
implements Iterable<Order>,
Serializable {
    public static final Direction DEFAULT_DIRECTION = Direction.ASC;
    private static final long serialVersionUID = -6185297542401976741L;
    @JSONField(serialize=false, deserialize=false)
    private List<Order> orders;

    public Sort(Order ... orders) {
        this(Arrays.asList(orders));
    }

    public Sort(List<Order> orders) {
        if (null == orders || orders.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one sort property to sort by!");
        }
        this.orders = orders;
    }

    public Sort(String ... properties) {
        this(DEFAULT_DIRECTION, properties);
    }

    public Sort(Direction direction, String ... properties) {
        this(direction, properties != null ? Arrays.asList(properties) : new ArrayList<String>());
    }

    public Sort(Direction direction, List<String> properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one property to sort by!");
        }
        this.orders = new ArrayList<Order>(properties.size());
        for (String property : properties) {
            this.orders.add(new Order(direction, property));
        }
    }

    public Sort and(Sort sort) {
        if (sort == null) {
            return this;
        }
        ArrayList<Order> these = new ArrayList<Order>(this.orders);
        for (Order order : sort) {
            these.add(order);
        }
        return new Sort(these);
    }

    public Order getOrderFor(String property) {
        for (Order order : this) {
            if (!order.getProperty().equals(property)) continue;
            return order;
        }
        return null;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    @Override
    public Iterator<Order> iterator() {
        return this.orders.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort that = (Sort)obj;
        return this.orders.equals(that.orders);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.orders.hashCode();
        return result;
    }

    public String toString() {
        return JSON.toJSONString(this.orders);
    }

    public static class ModelValueDeserializer
    implements ObjectDeserializer {
        public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
            JSONArray jsonArray = (JSONArray)parser.parse();
            if (jsonArray == null) {
                return null;
            }
            ArrayList<Order> orders = new ArrayList<Order>(jsonArray.size());
            for (Object o : jsonArray) {
                JSONObject item = (JSONObject)o;
                String property = (String)item.get((Object)"property");
                String direction = (String)item.get((Object)"direction");
                Order order = new Order(Direction.fromStringOrNull(direction), property);
                orders.add(order);
            }
            return (T)new Sort(orders);
        }

        public int getFastMatchToken() {
            return 0;
        }
    }
}

