/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.concurrent;

import app.myoss.cloud.core.lang.concurrent.ExecuteException;
import app.myoss.cloud.core.lang.concurrent.ExecuteTimeoutException;
import app.myoss.cloud.core.lang.concurrent.ExecuteUnit;
import app.myoss.cloud.core.lang.concurrent.MergeUnit;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorEngine
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ExecutorEngine.class);
    private static final ThreadPoolExecutor SHUTDOWN_EXECUTOR = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MyOSSCloud-Core-ExecutorEngineCloseTimer").build());
    private final ExecutorService executorService;

    public ExecutorEngine(ExecutorService delegate) {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)delegate);
        MoreExecutors.addDelayedShutdownHook((ExecutorService)this.executorService, (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    public static ExecutorEngine buildTreadPoolExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ExecutorEngineThreadPool-%d").build();
        ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(5, 200, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), threadFactory);
        return new ExecutorEngine(poolExecutor);
    }

    @Override
    public void close() {
        SHUTDOWN_EXECUTOR.execute(() -> {
            try {
                this.executorService.shutdown();
                while (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException ex) {
                log.error("ExecutorEngine can not been terminated", (Throwable)ex);
            }
        });
    }

    public <I, O> List<O> execute(I input, Collection<ExecuteUnit<I, O>> executeUnits, Long timeout, TimeUnit timeUnit) {
        if (executeUnits.size() == 1) {
            try {
                return Lists.newArrayList((Object[])new Object[]{executeUnits.iterator().next().execute(input)});
            }
            catch (Exception ex) {
                throw new ExecuteException("execute task throw exception", ex);
            }
        }
        ListenableFuture<List<O>> futures = this.submitFutures(input, executeUnits);
        this.addCallback(futures);
        return this.getFutureResults(futures, timeout, timeUnit);
    }

    public <I, O> List<O> execute(Collection<I> inputs, ExecuteUnit<I, O> executeUnit, Long timeout, TimeUnit timeUnit) {
        if (inputs.size() == 1) {
            try {
                return Lists.newArrayList((Object[])new Object[]{executeUnit.execute(inputs.iterator().next())});
            }
            catch (Exception ex) {
                throw new ExecuteException("execute task throw exception", ex);
            }
        }
        ListenableFuture<List<O>> futures = this.submitFutures(inputs, executeUnit);
        this.addCallback(futures);
        return this.getFutureResults(futures, timeout, timeUnit);
    }

    public <I, O> List<O> execute(Collection<I> inputs, ExecuteUnit<I, O> executeUnit) {
        return this.execute(inputs, executeUnit, null, null);
    }

    public <O> List<O> execute(int size, ExecuteUnit<Integer, O> executeUnit, Long timeout, TimeUnit timeUnit) {
        if (size == 1) {
            try {
                return Lists.newArrayList((Object[])new Object[]{executeUnit.execute(0)});
            }
            catch (Exception ex) {
                throw new ExecuteException("execute task throw exception", ex);
            }
        }
        ArrayList<Integer> inputs = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            inputs.add(i);
        }
        ListenableFuture<List<O>> futures = this.submitFutures(inputs, executeUnit);
        this.addCallback(futures);
        return this.getFutureResults(futures, timeout, timeUnit);
    }

    public <O> List<O> execute(int size, ExecuteUnit<Integer, O> executeUnit) {
        return this.execute(size, executeUnit, null, null);
    }

    public <I, M, O> O execute(Collection<I> inputs, ExecuteUnit<I, M> executeUnit, MergeUnit<M, O> mergeUnit, Long timeout, TimeUnit timeUnit) {
        return mergeUnit.merge(this.execute(inputs, executeUnit, timeout, timeUnit));
    }

    public <I, M, O> O execute(Collection<I> inputs, ExecuteUnit<I, M> executeUnit, MergeUnit<M, O> mergeUnit) {
        return mergeUnit.merge(this.execute(inputs, executeUnit));
    }

    public <I, O> ListenableFuture<List<O>> submitFutures(Collection<I> inputs, ExecuteUnit<I, O> executeUnit) {
        HashSet<ListenableFuture> result = new HashSet<ListenableFuture>(inputs.size());
        for (Object each : inputs) {
            result.add((ListenableFuture)this.executorService.submit(() -> executeUnit.execute(each)));
        }
        return Futures.allAsList(result);
    }

    public <I, O> ListenableFuture<List<O>> submitFutures(I input, Collection<ExecuteUnit<I, O>> executeUnits) {
        HashSet<ListenableFuture> result = new HashSet<ListenableFuture>(executeUnits.size());
        for (ExecuteUnit each : executeUnits) {
            result.add((ListenableFuture)this.executorService.submit(() -> each.execute(input)));
        }
        return Futures.allAsList(result);
    }

    public <O> void addCallback(ListenableFuture<O> allFutures) {
        Futures.addCallback(allFutures, (FutureCallback)new FutureCallback<O>(){

            public void onSuccess(O result) {
                log.trace("Concurrent execute result success {}", result);
            }

            public void onFailure(Throwable thrown) {
                log.warn("Concurrent execute result failure", thrown);
            }
        }, (Executor)this.executorService);
    }

    public <O> O getFutureResults(ListenableFuture<O> allFutures, Long timeout, TimeUnit timeUnit) {
        try {
            if (timeout != null && timeUnit != null) {
                return (O)allFutures.get(timeout.longValue(), timeUnit);
            }
            if (timeout != null) {
                return (O)allFutures.get(timeout.longValue(), TimeUnit.MILLISECONDS);
            }
            return (O)allFutures.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new ExecuteException("execute task throw exception", ex);
        }
        catch (TimeoutException ex) {
            throw new ExecuteTimeoutException("execute task throw times out exception", ex);
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

